/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: ExamQuestionController
 * Author:   phone
 * Date:     2018/3/30 9:29
 * Description: 考试试题
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.application.exam.controller;

import java.util.List;
import java.util.Map;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.exam.application.feign.ExamQuestionClient;
import com.yizhi.exam.application.vo.ExamQuestionLibraryVO;
import com.yizhi.exam.application.vo.ExamQuestionVO;
import com.yizhi.exam.application.vo.QuestionPreview;
import com.yizhi.exam.application.vo.exam.SortVO;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 〈一句话功能简述〉<br>
 * 〈考试试题〉
 *
 * @author fanchunhui
 * @create 2018/3/30
 * @since 1.0.0
 */
@Api(tags = "管理端-题库接口", description = "管理端-题库接口")
@RestController("webExamQuestionController")
@RequestMapping("/manage/exam/question")
public class ExamQuestionController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExamQuestionController.class);


    @Autowired
    ExamQuestionClient examQuestionClient;

    @ApiOperation(value = "考试试题列表",response = ExamQuestionLibraryVO.class)
    @GetMapping("/list")
    public Response<ExamQuestionLibraryVO> getQuestionList(
//            @ApiParam(name = "pageNo", value = "当前页") @RequestParam(name = "pageNo", required = false,defaultValue = "1") Integer pageNo,pageNo
            @ApiParam(name = "pageNo", value = "每页的个数") @RequestParam(name = "pageNo", defaultValue = "1", required = false) Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页的个数") @RequestParam(name = "pageSize", defaultValue = "20", required = false) Integer pageSize,
            @ApiParam(name = "examId", value = "考试id不能为null", required = true) @RequestParam(name = "examId") Long examId) {
        List<ExamQuestionLibraryVO> list = null;
        Map<String,Integer> page = null;
        Pair<List<ExamQuestionLibraryVO>,Map<String,Integer>> pair = null;
        try {
            Map<String,Object> map = examQuestionClient.getQuestionList(pageNo,pageSize,examId);
            if (null != map.get("list")){
                list = (List<ExamQuestionLibraryVO>) map.get("list");
            }
            if (null != map.get("page")){
                page = (Map<String, Integer>) map.get("page");
            }
            pair = new MutablePair<List<ExamQuestionLibraryVO>, Map<String, Integer>>(list, page);
            return Response.ok(pair);
        } catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("查询考试试题列表失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "创建考试试题信息", response = Response.class)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "examId",value = "考试主键ID",paramType = "body"),
            @ApiImplicitParam(name = "subjectId",value = "题目主键ID",paramType = "body"),
            @ApiImplicitParam(name = "stem",value = "题干，题目内容",paramType = "body"),
            @ApiImplicitParam(name = "score",value = "分数",paramType = "body"),
            @ApiImplicitParam(name = "type",value = "试题题型，1单选题、2多选题、3判断题、4问答题",paramType = "body"),
            @ApiImplicitParam(name = "sort",value = "排序",paramType = "body"),
            @ApiImplicitParam(name = "state",value = "0删除 1有效，默认1",paramType = "body",defaultValue = "1"),
            @ApiImplicitParam(name = "questionLibrarySubjectVOS",value = "试题",paramType = "body")
    })
    @PostMapping("/insert")
    public Response<String> insert(@RequestBody ExamQuestionVO examQuestionVO) {
        boolean result = false;
        try {
            RequestContext requestContext = ContextHolder.get();
            examQuestionVO.setAccountId(requestContext.getAccountId());
            examQuestionVO.setAccountName(requestContext.getAccountName());
            examQuestionVO.setCompanyId(requestContext.getCompanyId());
            examQuestionVO.setOrgId(requestContext.getOrgId());
            examQuestionVO.setSiteId(requestContext.getSiteId());
            result = examQuestionClient.insert(examQuestionVO);
            if (result){
                return Response.ok();
            }else {
                return Response.fail(Constants.EXAM_MSG_BIZ_ERROR);
            }
        } catch (Exception e) {
            LOGGER.error("新建试题失败！", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "试题预览",notes="返回试题相关信息", response = QuestionPreview.class)
    @GetMapping("/exam/preview")
    public Response<QuestionPreview> examPreview(
            @ApiParam(value = "考试Id", required = true) @RequestParam(value="examTitleId", required = true) Long examTitleId){
        try {
            QuestionPreview questionPreview = examQuestionClient.examPreview(examTitleId);
            return Response.ok(questionPreview);
        }catch (Exception e){
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "修改试题分数",notes = "修改试题分数")
    @PostMapping("/update/score")
    public Response<String> updateScore(@RequestBody ExamQuestionVO examQuestionVO){
                try {
                    boolean result = examQuestionClient.updateScoreById(examQuestionVO);
                    if (result){
                        return Response.ok();
                    }else{
                        return Response.fail(ReturnCode.UPDATE_FAIL.getCode(),ReturnCode.UPDATE_FAIL.getMsg());
                    }
                }catch (Exception e){
                    e.printStackTrace();
                    return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
                }
    }

    @ApiOperation(value = "调整试题顺序",notes = "调整试题顺序")
    @PostMapping("/move")
    public Response<String> move(@RequestBody List<SortVO> sortVOS){
        try {
            boolean result = examQuestionClient.move(sortVOS);
            if (result){
                return Response.ok();
            }else{
                return Response.fail(ReturnCode.UPDATE_FAIL.getCode(),ReturnCode.UPDATE_FAIL.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "批量删除考试试题",notes = "批量删除考试试题")
    @PostMapping("/delete/all")
    public Response<String> deleteAllById(@RequestBody List<Long> id){
        try {
           Integer count = examQuestionClient.deleteAllById(id);
            if (count > 0){
                return Response.ok("删除试题成功！");
            }else{
                return Response.fail(ReturnCode.DELETE_FAIL.getCode(),ReturnCode.DELETE_FAIL.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "删除指定考试题库的题目",notes = "删除指定考试题库的题目")
    @PostMapping("/update/question")
    public Response<String> updateQuestion(@RequestBody ExamQuestionVO examQuestionVO){
       try {
           Integer result = examQuestionClient.updateQuestion(examQuestionVO);
           if(result>0){
               return Response.ok("删除试题成功！");
           }else {
               return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
           }
       }catch (Exception e){
           LOGGER.error("",e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
       }
    }

}
