package com.yizhi.application.portal.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.album.application.feign.AlbumClient;
import com.yizhi.album.application.vo.ApiSearchAlbumVo;
import com.yizhi.album.application.vo.domain.Album;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.course.application.feign.CourseClient;
import com.yizhi.course.application.feign.CoursePcClient;
import com.yizhi.course.application.vo.ModuleAllVoCourse;
import com.yizhi.course.application.vo.domain.CourseEntityVo;
import com.yizhi.drools.application.feign.RecommendStrategyClient;
import com.yizhi.drools.application.vo.drools.BusinessVo4Portal;
import com.yizhi.drools.application.vo.drools.BusinessVo4PortalParam;
import com.yizhi.drools.application.vo.drools.BusinessVo4PortalResponse;
import com.yizhi.enroll.application.feign.EnrollFeignClient;
import com.yizhi.enroll.application.vo.domain.Enroll;
import com.yizhi.lecturer.application.feign.LecturerClient;
import com.yizhi.lecturer.application.vo.LecturerTemplateVO;
import com.yizhi.lecturer.application.vo.TemplateLecturerVO;
import com.yizhi.lecturer.application.vo.domain.LecturerVo;
import com.yizhi.library.application.feign.StudentCaseClient;
import com.yizhi.library.application.param.HomeListParam;
import com.yizhi.library.application.vo.FavoriteVO;
import com.yizhi.library.application.vo.StudentCaseStudyVO;
import com.yizhi.library.application.vo.StudentCaseVO;
import com.yizhi.live.application.feign.LiveActivityClient;
import com.yizhi.live.application.vo.LiveActivityVO;
import com.yizhi.site.application.enums.PortalEnum;
import com.yizhi.site.application.feign.PortalManagePCFeignClients;
import com.yizhi.site.application.feign.api.PortalApiFeignClients;
import com.yizhi.site.application.feign.api.PortalApiPCFeignClients;
import com.yizhi.site.application.vo.domain.*;
import com.yizhi.site.application.vo.site.*;
import com.yizhi.system.application.system.remote.SiteClient;
import com.yizhi.system.application.vo.SiteVO;
import com.yizhi.training.application.feign.TpPlanActivityClient;
import com.yizhi.training.application.feign.TpProjectClient;
import com.yizhi.training.application.feign.TrainingProjectClient;
import com.yizhi.training.application.vo.api.TrainingProjectVoPortalVo;
import com.yizhi.training.application.vo.domain.TpPlanActivityVo;
import com.yizhi.training.application.vo.domain.TrainingProjectVo;
import com.yizhi.training.application.vo.manage.SearchProjectVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.*;
import lombok.extern.log4j.Log4j2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.toList;

/**
 * 门户PC端管理
 *
 * @author wangfeida
 */
@Log4j2
@Api(tags = "门户PC管理,只限于PC端")
@RestController
@RequestMapping("/manage/portal/pc")
public class SitePortalManagePcController {

    private static final Logger LOG = LoggerFactory.getLogger(SitePortalManagePcController.class);
    
    
    @Autowired
    private LecturerClient lecturerClient;
    
    @Autowired
    private TpProjectClient tpProjectClient;
    
    @Autowired
    private LiveActivityClient liveActivityClient;
    
    @Autowired
    private TpPlanActivityClient tpPlanActivityClient;

    @Autowired
    private TrainingProjectClient trainingProjectClient;

    @Autowired
    private PortalApiFeignClients portalApiFeignClients;

    @Autowired
    private PortalManagePCFeignClients portalManagePCFeignClients;

    @Autowired
    private RecommendStrategyClient recommendStrategyClient;


    @Autowired
    private CourseClient courseClient;

    @Autowired
    private CoursePcClient coursePcClient;

    @Autowired
    private PortalUtil portalUtil;

    @Autowired
    private PortalController portalController;
    @Autowired
    private StudentCaseClient studentCaseClient;

    @Autowired
    private PortalApiPCFeignClients portalApiPCFeignClients;
     @Autowired
     private AlbumClient albumClient;
    @Autowired
    private SiteClient remoteSiteClient;
    @Autowired
    EnrollFeignClient enrollFeignClient;

    @ApiOperation(value = "pc首页logo新增", notes = "返回首页logo Id")
    @PostMapping("/home/logo/insert")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "terminalId", value = "终端ID", dataType = "Long"),
            @ApiImplicitParam(name = "logoPath", value = "logo图片地址", dataType = "String"),
    })
    public Response<HomeLogoVO> insertHomeLogoPc(@RequestBody HomeLogoVO vo) {
        try {
            return Response.ok(portalManagePCFeignClients.insertHomeLogoPc(vo.getTerminalId(), vo.getLogoPath()));
        } catch (Exception e) {
            LOG.error("首页logo新增:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "pc首页logo删除", notes = "pc首页logo删除")
    @GetMapping("/home/logo/delete")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "logoId", value = "图片ID", dataType = "Long")
    })
    public Response<HomeLogoVO> deleteHomeLogoPc(@ApiParam(name = "logoId", value = "图片ID", required = true) @RequestParam(name = "logoId", required = true) Long logoId) {
        try {
            return Response.ok(portalManagePCFeignClients.deleteHomeLogoPc(logoId));
        } catch (Exception e) {
            LOG.error("首页logo删除:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "首页logo修改", notes = "返回首页logo Id")
    @PostMapping("/home/logo/update")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "首页logoID", dataType = "Long"),
            @ApiImplicitParam(name = "logoPath", value = "logo图片地址", dataType = "String")
    })
    public Response<HomeLogoVO> updateHomeLogoPc(@RequestBody HomeLogoVO vo) {
        try {
            return Response.ok(portalManagePCFeignClients.updateHomeLogoPc(vo.getId(), vo.getLogoPath()));
        } catch (Exception e) {
            LOG.error("首页logo修改:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "首页logo 查看", notes = "返回首页logoVo", response = HomeLogoVO.class)
    @GetMapping("/home/logo/view")
    public Response<HomeLogoVO> viewHomeLogoPc(@ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId) {
        try {
            return Response.ok(portalManagePCFeignClients.viewHomeLogoPc(terminalId));
        } catch (Exception e) {
            LOG.error("首页logo 查看:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "查找所有链接", notes = "查找所有链接", response = RelationLinkVo.class)
    @GetMapping("/home/all/list/link")
    public Response<RelationLinkVo> getAllListLink(@ApiParam(name = "name", value = "功能名字", required = false) @RequestParam(name = "name", required = false) String name) {
        try {
            //1代表去这个库里边查找模块信息
            return Response.ok(portalManagePCFeignClients.getAllListLink(name, 1));
        } catch (Exception e) {
            LOG.error("查找所有链接:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    //-------------------------------导航栏--------------------------------

    @ApiOperation(value = "导航栏功能入口修改(pc端)/快捷菜单", notes = "头部导航栏功能入口修改(pc端)/快捷菜单",response = NavigateListVO.class)
    @PostMapping("/navigate/update")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "terminalId", value = "终端ID", dataType = "Long"),
            @ApiImplicitParam(name = "id", value = "导航栏单个链接ID，如果为空，则是新增，如果不为空，则是修改", dataType = "Long"),
            @ApiImplicitParam(name = "showName", value = "pctype=1文字标签，pctype=2栏目名称", dataType = "String"),
            @ApiImplicitParam(name = "relationFunc", value = "关联功能类型，系统提供的为0, 自定义的为1", dataType = "integer"),
            @ApiImplicitParam(name = "relationFuncCode", value = "关联功能编码，如果是链接到url，这个字段不写值", dataType = "integer"),
            @ApiImplicitParam(name = "relationFuncUrl", value = "关联功能链接.只有外链传url", dataType = "String"),
            @ApiImplicitParam(name = "imgPath", value = "pcType=1这个字段不管，pcType=2图片路径", dataType = "String"),
            @ApiImplicitParam(name = "pcType", value = "满足pc端加的字段 pcType=1 上边的导航栏  pcType= 2  下边的导航栏（只适合pc端）", dataType = "integer")
    })
    public Response<PortalNavigateVo> updateAndInsertNavigatePc(@RequestBody NavigateListVO vo) {
        try {
            /**
             * 如果id存在，后台更新，如果id不存在，后台插入
             */
            return Response.ok(portalManagePCFeignClients.updateAndInsertNavigatePc(vo));
        } catch (Exception e) {
            LOG.error("导航栏功能入口修改(pc端)/快捷菜单:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "头部导航栏功能入口展示(pc端)", notes = "头部导航栏功能入口展示(pc端)")
    @GetMapping("/navigate/view")
    public Response<List<PortalNavigateVo>> getNavigatePc(@ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId,
                                                        @ApiParam(name = "pcType", value = "导航类型", required = true) @RequestParam(name = "pcType", required = true) Integer pcType) {
        try {
            int maxNum = 6;
            List<PortalNavigateVo> list = portalManagePCFeignClients.getRelationListLink(terminalId, pcType);
            PortalNavigateVo pn = null;
            if (pcType == 1) {  //导航栏1进行展示显示+链接   导航栏2不需要展示
                if (CollectionUtils.isEmpty(list)) {
                    list = new ArrayList<PortalNavigateVo>(maxNum);
                    for (int i = 1; i <= maxNum; i++) {
                        pn = new PortalNavigateVo();
                        pn.setShowName("+链接");
                        list.add(pn);
                    }
                } else {
                    int size = list.size();
                    for (int i = 1; i <= maxNum - size; i++) {
                        pn = new PortalNavigateVo();
                        pn.setShowName("+链接");
                        list.add(pn);
                    }
                }
            } else {
                if (!CollectionUtils.isEmpty(list)) {
                    for (int i = 0; i < list.size(); i++) {
                        if (list.get(i).getRelationFunc() == 1) {
                            list.get(i).setRelationFuncName("外链");
                        }
                    }
                }
            }

            return Response.ok(list);
        } catch (Exception e) {
            LOG.error("头部导航栏功能入口pc修改/新增:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "头部导航栏功能删除链接", notes = "头部导航栏功能删除链接")
    @GetMapping("/navigate/delete")
    public Response<Boolean> deleteNavigatePc(@ApiParam(name = "id", value = "链接ID", required = true) @RequestParam(name = "id", required = true) Long id) {
        try {
            return Response.ok(portalManagePCFeignClients.deleteNavigatePc(id));
        } catch (Exception e) {
            LOG.error("头部导航栏功能删除链接:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "头部导航栏排序(只有pc_type有排序规则)", notes = "头部导航栏排序")
    @GetMapping("/navigate/update/sort")
    public Response<Boolean> updateSortNavigatePc(@ApiParam(name = "id", value = "链接ID(主键)", required = true) @RequestParam(name = "id", required = true) Long id,
                                                  @ApiParam(name = "isDown", value = "是否下一个0是  1不是", required = true) @RequestParam(name = "isDown", required = true) Integer isDown) {
        try {
            return Response.ok(portalManagePCFeignClients.updateSortNavigatePc(id, isDown));
        } catch (Exception e) {
            LOG.error("头部导航栏功能删除链接:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "查看访问人数页面", notes = "查看访问人数")
    @GetMapping("/look/num/select")
    public Response<TrPortalLookNumVo> lookNumSelect(@ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId) {
        try {
            return Response.ok(portalManagePCFeignClients.lookNumSelectPc(terminalId));
        } catch (Exception e) {
            LOG.error("查看访问人数页面:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "设置访问人数", notes = "设置访问人数")
    @PostMapping("/look/num/set")
    public Response<TrPortalLookNumVo> lookNumSet(@RequestBody TrPortalLookNumVo trPortalLookNum) {
        try {
            return Response.ok(portalManagePCFeignClients.lookNumSetPc(trPortalLookNum));
        } catch (Exception e) {
            LOG.error("设置访问人数:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "查看已经关联的轮播图(banner)", notes = "查看已经关联的轮播图(banner)")
    @GetMapping("/banner/select")
    public Response<List<PreviewImageVO>> getRelationBaner(@ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId) {
        try {
            return Response.ok(portalManagePCFeignClients.getRelationBanerPc(terminalId));
        } catch (Exception e) {
            LOG.error("查看已经关联的轮播图:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "bannner库信息", notes = "bannner库信息")
    @GetMapping("/banner/all")
    public Response<List<PreviewImageVO>> getAllBaner(@ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId,
                                                      @ApiParam(name = "pageNo", value = "pageNo", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                      @ApiParam(name = "pageSize", value = "pageSize", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "100") Integer pageSize) {

        try {
            /**
             * 对已经关联的banner信息，banner库不显示
             */
            Page<ImageListVO> page = portalManagePCFeignClients.getAllBanerPc(terminalId, pageNo, pageSize);
            Map<String, Integer> pageMap = new HashMap<String, Integer>();
            List<ImageListVO> list = new ArrayList<ImageListVO>();
            if (page != null) {
                pageMap.put("pageNo", pageNo);
                pageMap.put("pageSize", pageSize);
                pageMap.put("pageTotal", page.getTotal());
                list = page.getRecords();
            } else {
                pageMap.put("pageNo", pageNo);
                pageMap.put("pageSize", pageSize);
                pageMap.put("pageTotal", 0);
            }

            return Response.ok(list, pageMap);
        } catch (Exception e) {
            LOG.error("查看已经关联的轮播图:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "添加banner", notes = "添加banner")
    @PostMapping("/banner/insert")
    public Response<Boolean> insertBanerPc(@RequestBody AnnouncementVO announcementVO) {
        try {
            Long terminalId = announcementVO.getTerminalId();
            List<Long> ids = announcementVO.getIds();
            return Response.ok(portalManagePCFeignClients.insertBanerPc(terminalId, ids));
        } catch (Exception e) {
            LOG.error("添加banner:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "删除banner", notes = "删除banner")
    @GetMapping("/banner/delete")
    public Response<Boolean> deleteRelationBanerPc(
            @ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId,
            @ApiParam(name = "id", value = "图片ID", required = true) @RequestParam(name = "id", required = true) Long id) {
        try {
            return Response.ok(portalManagePCFeignClients.deleteRelationBanerPc(terminalId, id));
        } catch (Exception e) {
            LOG.error("删除已经关联的轮播图:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation("更改banner排序规则")
    @GetMapping("/banner/update/sort")
    public Response<Boolean> updateBannerSortPC(
            @ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId,
            @ApiParam(name = "currentId", value = "源ID", required = true) @RequestParam(name = "currentId", required = true) Long currentId,
            @ApiParam(name = "isDown", value = "是否下一个0是  1不是", required = true) @RequestParam(name = "isDown", required = true) Integer isDown) {
        try {
            return Response.ok(portalManagePCFeignClients.updateBannerSortPC(terminalId, currentId, isDown));
        } catch (Exception e) {
            LOG.error("终端添加公告/改变模块状态:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "得到所有的直播信息", notes = "得到所有的直播信息")
    @GetMapping("/live/all")
    public Response<Page<PreviewImageVO>> getAllLivePc(
            @ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId,
            @ApiParam(name = "pageNo", value = "pageNo", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "pageSize", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "100") Integer pageSize) {
        try {
            List<Long> ids = portalManagePCFeignClients.getRelationLivePc(terminalId);
            Long siteId = ContextHolder.get().getSiteId();
            //不在已经关联的范围
            Page<LiveActivityVO> page = liveActivityClient.getPageLiveVoListNotIds(ids, siteId, pageNo, pageSize);
            Map<String, Integer> pageMap = new HashMap<String, Integer>();
            List<LiveActivityVO> list = new ArrayList<LiveActivityVO>();
            if (page != null) {
                pageMap.put("pageNo", pageNo);
                pageMap.put("pageSize", pageSize);
                pageMap.put("pageTotal", page.getTotal());
                list = page.getRecords();
            } else {
                pageMap.put("pageNo", pageNo);
                pageMap.put("pageSize", pageSize);
                pageMap.put("pageTotal", 0);
            }
            return Response.ok(list, pageMap);
        } catch (Exception e) {
            LOG.error("得到所有的直播信息:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "得到已经关联的直播信息", notes = "得到已经关联的直播信息")
    @GetMapping("/live/relation")
    public Response<ApiPortalPCLive> getRelationLivePc(
            @ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId,
            @ApiParam(name = "pageNo", value = "pageNo", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "pageSize", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "100") Integer pageSize) {
        try {

            List<Long> listIds = portalManagePCFeignClients.getRelationLivePc(terminalId);
            Page<LiveActivityVO> pageActivities = null;
            if (CollectionUtils.isNotEmpty(listIds)) {
                pageActivities = liveActivityClient.LiveActivityByIds(listIds, pageNo, pageSize);
            }

            List<LiveActivityVO> listLiveActivitys = null;
            if (pageActivities != null) {
                listLiveActivitys = pageActivities.getRecords();
            }

            ApiPortalPCLive apiPortalPCLive = null;
            if (CollectionUtils.isNotEmpty(listLiveActivitys)) {
                LiveActivityVO liveActivity = listLiveActivitys.get(0);

                String channelId = liveActivity.getChannel();
                //1--即将开始  2--live 直播中 3-end 直播结束  -1 获取状态异常

                apiPortalPCLive = new ApiPortalPCLive();
                apiPortalPCLive.setId(liveActivity.getId());
                apiPortalPCLive.setTitle(liveActivity.getTitle());
                apiPortalPCLive.setLogo(liveActivity.getLogoImage());
                apiPortalPCLive.setTeacherName(liveActivity.getAnchor());
                SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
                if (liveActivity.getStartTime() != null && liveActivity.getEndTime() != null) {
                    String startTime = sim.format(liveActivity.getStartTime());
                    String endTime = sim.format(liveActivity.getEndTime());
                    apiPortalPCLive.setStartTime(startTime + "~" + endTime);
                }
                Integer state = -1;
                try {
                    state = liveActivityClient.getLiveStatus(channelId);
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                apiPortalPCLive.setState(state);
            }

            return Response.ok(apiPortalPCLive);
        } catch (Exception e) {
            LOG.error("得到已经关联的直播信息:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "保存修改选择的直播信息", notes = "保存修改选择的直播信息")
    @GetMapping("/live/save")
    public Response<List<PreviewImageVO>> saveLivePc(
            @ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId,
            @ApiParam(name = "liveId", value = "直播ID", required = true) @RequestParam(name = "liveId", required = true) Long liveId) {
        try {
            return Response.ok(portalManagePCFeignClients.saveRelationLive(terminalId, liveId));
        } catch (Exception e) {
            LOG.error("保存修改选择的直播信息:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "直播删除", notes = "直播删除")
    @GetMapping("/live/delete")
    public Response<Boolean> deleteLivePc(
            @ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId,
            @ApiParam(name = "liveId", value = "直播ID", required = true) @RequestParam(name = "liveId", required = true) Long liveId) {
        try {
            return Response.ok(portalManagePCFeignClients.deleteRelationLive(terminalId, liveId));
        } catch (Exception e) {
            LOG.error("直播删除:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "导航栏2信息修改是否显示状态", notes = "导航栏2信息修改是否显示状态")
    @GetMapping("/navigate/update/display")
    public Response<Integer> navigateUpdateDisplay(
            @ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId,
            @ApiParam(name = "display", value = "不显示值0，展示为1", required = true) @RequestParam(name = "display", required = true) Integer display) {
        try {
            return Response.ok(portalManagePCFeignClients.navigateUpdateDisplay(terminalId, display));
        } catch (Exception e) {
            LOG.error("导航栏2信息是否显示:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "查看导航栏2信息是否显示", notes = "查看导航栏2信息是否显示")
    @GetMapping("/navigate/view/display")
    public Response<Integer> navigateViewDisplay(
            @ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId) {
        try {
            return Response.ok(portalManagePCFeignClients.navigateViewDisplay(terminalId));
        } catch (Exception e) {
            LOG.error("导航栏2信息是否显示:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "公告库查看所有公告", notes = "公告库查看所有公告")
    @GetMapping("/announcement/all")
    public Response<List<PreviewImageVO>> getAllAnnouncementPC(
            @ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId,
            @ApiParam(name = "pageNo", value = "pageNo", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "pageSize", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "100") Integer pageSize) {
        try {
            Page<InformationVo> page = portalManagePCFeignClients.getAllAnnouncementPC(terminalId, pageNo, pageSize);
            Map<String, Integer> pageMap = new HashMap<String, Integer>();
            List<InformationVo> list = new ArrayList<InformationVo>();
            if (page != null) {
                pageMap.put("pageNo", pageNo);
                pageMap.put("pageSize", pageSize);
                pageMap.put("pageTotal", page.getTotal());
                list = page.getRecords();
            } else {
                pageMap.put("pageNo", pageNo);
                pageMap.put("pageSize", pageSize);
                pageMap.put("pageTotal", 0);
            }
            return Response.ok(list, pageMap);
        } catch (Exception e) {
            LOG.error("公告库查看所有公告:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "查看已经关联的公告", notes = "查看已经关联的公告")
    @GetMapping("/announcement/select")
    public Response<List<PreviewImageVO>> getRelationAnnouncement(@ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId) {
        try {
            return Response.ok(portalManagePCFeignClients.getRelationAnnouncement(terminalId));
        } catch (Exception e) {
            LOG.error("查看已经关联的公告:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "终端添加公告/改变模块状态", notes = "终端添加公告/改变模块状态")
    @PostMapping("/announcement/insert/update")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "terminalId", value = "终端ID,必填", dataType = "Long"),
            @ApiImplicitParam(name = "announcementIds", value = "添加时用到，公告ID集合", dataType = "List<Long>"),
            @ApiImplicitParam(name = "disPlay", value = "改变模块状态时用到，模块是否显示,0不显示,1显示", dataType = "Long"),
            @ApiImplicitParam(name = "announcementId", value = "删除公告时用到，公告ID", dataType = "Long")
    })
    public Response<Boolean> insertUpdateRelationAnnouncementPC(@RequestBody AnnouncementVO announcementVO) {
        try {
            return Response.ok(portalManagePCFeignClients.insertUpdateRelationAnnouncementPC(announcementVO));
        } catch (Exception e) {
            LOG.error("终端添加公告/改变模块状态:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "查看公告是否显示", notes = "查看公告是否显示")
    @GetMapping("/announcement/view/display")
    public Response<Integer> announcementViewDisplay(
            @ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId) {
        try {
            return Response.ok(portalManagePCFeignClients.announcementViewDisplay(terminalId));
        } catch (Exception e) {
            LOG.error("查看公告是否显示:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation("更改公告排序规则")
    @GetMapping("/announcement/details/update")
    public Response<Boolean> updateDetailsAnnouncementPC(
            @ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId,
            @ApiParam(name = "currentId", value = "源ID", required = true) @RequestParam(name = "currentId", required = true) Long currentId,
            @ApiParam(name = "isDown", value = "是否下一个0是  1不是", required = true) @RequestParam(name = "isDown", required = true) Integer isDown) {
        try {
            return Response.ok(portalManagePCFeignClients.updateDetailsAnnouncementPC(terminalId, currentId, isDown));
        } catch (Exception e) {
            LOG.error("更改公告排序规则:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation("返回模板列表信息，前端再根据模板列表查询到模板具体信息")
    @GetMapping("/module/list/select")
    public Response<List<PortalTemplateVo>> moduleListSelect(
            @ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId) {
        try {
            return Response.ok(portalManagePCFeignClients.moduleListSelect(terminalId));
        } catch (Exception e) {
            LOG.error("返回模板列表信息，前端再根据模板列表查询到模板具体信息:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation("添加模板/返回模板信息")
    @GetMapping("/module/name/add")
    public Response<PortalTemplateVo> moduleNameAdd(
            @ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId,
            @ApiParam(name = "currentId", value = "当前模板ID,新建则不传", required = false) @RequestParam(name = "currentId", required = false) Long currentId,
            @ApiParam(name = "isDown", value = "是否在当前模板上方添加 0是  1 在上方,如果不传默认0", required = false) @RequestParam(name = "isDown", required = false, defaultValue = "0") Integer isDown,
            @ApiParam(name = "moduleType", value = "板块类型,1:推荐/精选,2:项目培训,3:课程,5:新闻", required = true) @RequestParam(name = "moduleType", required = true) Integer moduleType,
            @ApiParam(name = "moduleName", value = "板块名字", required = true) @RequestParam(name = "moduleName", required = true) String moduleName) {
        try {
//            if (moduleName != null && moduleName.length() > 50) {
//                return Response.fail("2000", "模板名字不能大于五十个字");
//            }
            return Response.ok(portalManagePCFeignClients.moduleNameAdd(terminalId, currentId, isDown, moduleType, moduleName));
        } catch (Exception e) {
            LOG.error("添加模块/返回模板信息:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation("更改模板基本信息")
    @GetMapping("/module/update/message")
    public Response<Boolean> moduleUpdateMessage(
            @ApiParam(name = "id", value = "模板ID", required = true) @RequestParam(name = "id", required = true) Long id,
            @ApiParam(name = "name", value = "模板新名字", required = false) @RequestParam(name = "name", required = false) String name,
            @ApiParam(name = "state", value = "0: 删除  1: 未删除", required = false) @RequestParam(name = "state", required = false) Integer state,
            @ApiParam(name = "display", value = "0: 不显示  1: 显示", required = false) @RequestParam(name = "display", required = false) Integer display,
            @ApiParam(name = "isDown", value = "0: 向上方移动  1: 下方移动", required = false) @RequestParam(name = "isDown", required = false) Integer isDown) {
        try {
//            if (name != null && name.length() > 50) {
//                return Response.fail("2000", "模板名字不能大于五十个字");
//            }
            return Response.ok(portalManagePCFeignClients.moduleUpdateMessage(id, name, state, display, isDown));
        } catch (Exception e) {
            LOG.error("更改模板基本信息:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }
	
	
/*	@ApiOperation("模板上移下移")
	@GetMapping("/module/update/sort")
	public Response<Boolean> moduleUpdateSort(
			@ApiParam(name = "sourceId", value = "模板Id", required = true) @RequestParam(name = "sourceId", required = true) Long sourceId,
			@ApiParam(name = "targetId", value = "模板Id", required = true) @RequestParam(name = "targetId", required = true) Long targetId) {
		try {
			return Response.ok(portalManagePCFeignClients.moduleUpdateSort(sourceId, targetId));
		} catch (Exception e) {
			LOG.error("模板上移下移:", e);
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}*/


    @ApiOperation("模板内容添加")
    @PostMapping("/template/content/add")
    public Response<Boolean> templateContentAdd(@RequestBody TemplateInsertPcVO templateInsertPcVO) {
        try {
            Integer moduleType = templateInsertPcVO.getModuleType();
            if (moduleType == 1 && templateInsertPcVO.getListPlate() != null && templateInsertPcVO.getListPlate().size() < 3 && templateInsertPcVO.getListPlate().size() > 8) {
                return Response.fail(InternationalEnums.SITEPORTALMANAGEPCCONTROLLER1.getCode());
            }

//            if (moduleType == 2 && templateInsertPcVO.getListPlate() != null && templateInsertPcVO.getListPlate().size() > 4) {
//                return Response.fail("培训项目存储要求:项目数量大于0个并且小于等于4个。");
//            }

            if (moduleType == 3 && templateInsertPcVO.getListPlate() != null && templateInsertPcVO.getListPlate().size() > 10) {
                return Response.fail(InternationalEnums.SITEPORTALMANAGEPCCONTROLLER2.getCode());
            }

            /*if (moduleType == 5 && templateInsertPcVO.getListPlate() != null && templateInsertPcVO.getListPlate().size() > 2) {
                return Response.fail(InternationalEnums.SITEPORTALMANAGEPCCONTROLLER3.getCode());
            }*/
            if (moduleType == 6 && templateInsertPcVO.getListPlate() != null && templateInsertPcVO.getListPlate().size() > 10) {
                return Response.fail(InternationalEnums.SITEPORTALMANAGEPCCONTROLLER4.getCode());
            }
            return Response.ok(portalManagePCFeignClients.templateContentAdd(templateInsertPcVO));
        } catch (Exception e) {
            LOG.error("模板内容添加:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation(value = "模板内容展示",response = ModuleAllVO.class)
    @GetMapping("/template/content/view")
    public Response<List<ProtalPlateVo>> templateContentView(@ApiParam(name = "id", value = "模板ID", required = true) @RequestParam(name = "id", required = true) Long id,
                                                           @ApiParam(name = "moduleType", value = "板块类型,1:推荐/精选,2:项目培训,3:课程,5:新闻,6案例库", required = true) @RequestParam(name = "moduleType", required = true) Integer moduleType) {
        try {
            //模板关联的活动信息
            List<ProtalPlateVo> listProtalPlate = portalManagePCFeignClients.templateContentView(id);
            //展示集合
            List<ModuleAllVO> listModuleAllVO = null;
            if (CollectionUtils.isNotEmpty(listProtalPlate)) {
                listModuleAllVO = new ArrayList<ModuleAllVO>();
                ModuleAllVO mv = null;
                if (moduleType == 1) {
                	//原来的需求是如果没有图片采用习用的图片，但是现在如果本身没有图片一定会让管理端上传
                	List<RelationLinkVo> listRelationLink = portalManagePCFeignClients.getAllListLink(null, 2);
                    for (ProtalPlateVo portalPlate : listProtalPlate) {
                        Long mId = portalPlate.getLinkContent();
                        Integer type = portalPlate.getLinkType();
                        String imgUrl = portalPlate.getImgPath();
                        Integer thumbnail = portalPlate.getThumbnail();//缩略图, 1:使用内容图片, 2:使用新图片
                        String directions = portalPlate.getDirections();
                        //有logo的业务：  课程、线下课程、投票、直播、证书、  培训项目
                        //没有logo：          考试、调研、作业
                        //0 '课程' 1'考试' 2'调研' 3'直播' 4'投票'  5'作业' 6'证书' 7'外部链接' 8'报名' 9'签到' 10'线下课程' 11营销课程  12培训项目  13门户下的外链
                        //8，9只是培训项目的条件，不是培训项目的活动
                        //List<RelationLink> listRelationLink = portalManagePCFeignClients.getAllListLink(null, 2);
                        mv = portalUtil.getRecommend(mId, type, thumbnail, imgUrl, listRelationLink);
                        mv.setModuleType(type.toString());
                        mv.setDirections(directions);
                        mv.setThumbnail(thumbnail);
                        listModuleAllVO.add(mv);
                    }
                } else if (moduleType == 2) {
                    List<Long> listIds = new ArrayList<Long>();
                    SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
                    for (ProtalPlateVo plate : listProtalPlate) {
                        listIds.add(plate.getLinkContent());
                    }

                    List<TrainingProjectVoPortalVo> listTrainingProject = trainingProjectClient.getTrainingListByIds(listIds);
                    if (CollectionUtils.isNotEmpty(listTrainingProject)) {
                        for (TrainingProjectVoPortalVo tp : listTrainingProject) {
                            mv = new ModuleAllVO();
                            mv.setId(tp.getId());
                            mv.setModuleName(tp.getName());
                            mv.setModuleLogo(tp.getLogoImg());
                            mv.setStartTime(formate.format(tp.getStartTime()));
                            mv.setStartTime(formate.format(tp.getEndTime()));
                            listModuleAllVO.add(mv);
                        }
                    }
                } else if (moduleType == 3) {
                    List<Long> listIds = new ArrayList<Long>();
                    for (ProtalPlateVo plate : listProtalPlate) {
                        listIds.add(plate.getLinkContent());
                    }
                    List<ModuleAllVoCourse> listModuleAllVoCourse = coursePcClient.listCoursePCgrade(listIds);
                    if (CollectionUtils.isNotEmpty(listModuleAllVoCourse)) {
                        BigDecimal bigDecimalValue1 = new BigDecimal(5.0);
                        for (ModuleAllVoCourse mavc : listModuleAllVoCourse) {
                            mv = new ModuleAllVO();
                            mv.setId(mavc.getId());
                            mv.setModuleName(mavc.getModuleName());
                            mv.setModuleLogo(mavc.getModuleLogo());
                            //如果课程没有分数，给默认值为4.0分
                            if (mavc.getGrade() == null) {
                                mv.setGrade(bigDecimalValue1);
                            } else {
                                mv.setGrade(mavc.getGrade());
                            }
                            listModuleAllVO.add(mv);
                        }
                    }
                } else if (moduleType == 5) {
                    List<InformationViewVO> list = portalManagePCFeignClients.getRelationInformation(id);
                    SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
                    if (CollectionUtils.isNotEmpty(list)) {
                        for (InformationViewVO information : list) {
                            mv = new ModuleAllVO();
                            mv.setId(information.getId());
                            mv.setModuleName(information.getFileName());
                            mv.setModuleLogo(information.getLogoPath());
                            mv.setNewsContent(information.getContent());
                            if (information.getReleaseTime() != null) {
                                mv.setReleaseTime(formate.format(information.getReleaseTime()));
                            }
                            listModuleAllVO.add(mv);
                        }
                    }
                } else if (moduleType == PortalEnum.FOUR.ordinal()) {
                    List<PortalPlateVO> portalPlateVOList = portalApiFeignClients.getPlateVOList(id);
                    listModuleAllVO = portalPlateVOList.parallelStream().map(
                            portalPlateVO -> {
                                ModuleAllVO moduleAllVO = new ModuleAllVO();
                                LecturerVo lecturer = lecturerClient.getLecturerById(portalPlateVO.getId());
                                log.info("返回的id：" + portalPlateVO.getPlateId());
                                moduleAllVO.setId(portalPlateVO.getPlateId());
                                moduleAllVO.setModuleName(lecturer.getLecturerName());
                                moduleAllVO.setModuleLogo(lecturer.getAvatar());
                                moduleAllVO.setNewsContent(lecturer.getTitle());
                                return moduleAllVO;
                            }
                    ).collect(toList());

                } else if(moduleType==PortalEnum.SIX.ordinal()){
                    //案例库
                    List<PortalPlateVO> portalPlateVOList = portalApiFeignClients.getPlateVOList(id);
                    listModuleAllVO = portalPlateVOList.parallelStream().map(
                            portalPlateVO -> {
                                ModuleAllVO moduleAllVO = new ModuleAllVO();
                                FavoriteVO caseDetails = studentCaseClient.getStudentCaseDetail(portalPlateVO.getId());
                                log.info("返回的id：" + portalPlateVO.getPlateId());
                                moduleAllVO.setId(portalPlateVO.getPlateId());
                                moduleAllVO.setModuleName(caseDetails.getStudentCaseTittle());
                                moduleAllVO.setModuleLogo(caseDetails.getStudentCaseLogoUrl());
                                moduleAllVO.setCreateByName(caseDetails.getAuthorFullName());
                                return moduleAllVO;
                            }
                    ).collect(toList());

                } else if(moduleType==PortalEnum.SEVEN.ordinal()){
                    // 智能推荐
                    List<PortalPlateVO> portalPlateVOList = portalApiFeignClients.getPlateVOList(id);
                    List<Long> ids = portalPlateVOList.parallelStream().map(
                            portalPlateVO -> {
                                return portalPlateVO.getId();
                            }).collect(toList());
                    Integer num = portalPlateVOList.get(0).getNum();
                    LOG.info("数量num：{}",num);
                    BusinessVo4PortalParam businessVo4PortalParam = new BusinessVo4PortalParam();
                    businessVo4PortalParam.setPageNo(1);
                    businessVo4PortalParam.setPageSize(num);
                    businessVo4PortalParam.setStrategyIds(ids);
                    BusinessVo4PortalResponse businessVo4PortalResponse = recommendStrategyClient.businessVo4Manage(businessVo4PortalParam);
                    LOG.info(" 智能推荐返回结果：{}", JSON.toJSON(businessVo4PortalResponse));
                    List<BusinessVo4Portal> businessVo4Portals = businessVo4PortalResponse.getList();

                    listModuleAllVO = businessVo4Portals.parallelStream().map(
                            businessVo4Portal -> {
                                ModuleAllVO moduleAllVO = new ModuleAllVO();
                                moduleAllVO.setId(businessVo4Portal.getId());
                                moduleAllVO.setModuleName(businessVo4Portal.getName());
                                moduleAllVO.setModuleLogo(businessVo4Portal.getImage());
                                return moduleAllVO;
                            }
                    ).collect(toList());

                }
            }
            return Response.ok(listModuleAllVO);
        } catch (Exception e) {
            LOG.error("模板内容展示:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation("模板内容删除")
    @GetMapping("/template/content/update")
    public Response<Boolean> templateContentUpdate(@ApiParam(name = "id", value = "模板ID", required = true) @RequestParam(name = "id", required = true) Long id,
                                                   @ApiParam(name = "activityId", value = "活动id", required = true) @RequestParam(name = "activityId", required = true) Long activityId,
                                                   @ApiParam(name = "state", value = "0删除", required = false) @RequestParam(name = "state", required = false) Integer state,
                                                   @ApiParam(name = "imgUrl", value = "缩略图", required = false) @RequestParam(name = "imgUrl", required = false) String imgUrl) {
        try {

            return Response.ok(portalManagePCFeignClients.templateContentUpdate(id, activityId, state, imgUrl));
        } catch (Exception e) {
            LOG.error("模板内容删除:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation("精选推荐回显列表")
    @GetMapping("/template/content/select/content/view")
    public Response<PortalTemplateTraining> templateContentSelectContentView(@ApiParam(name = "id", value = "模板ID", required = true) @RequestParam(name = "id", required = true) Long id) {
        try {
            PortalTemplateTraining portalTemplateTraining = portalManagePCFeignClients.templateContentSelectContentView(id);
            if (portalTemplateTraining != null) {
                /*Long trainingProjectId = portalTemplateTraining.getSelectProject();
                TrainingProject trainingProject = trainingProjectClient.getOne(trainingProjectId);
                if (trainingProject != null) {
                    portalTemplateTraining.setSelectProjectName(trainingProject.getName());
                }*/
                List<ProtalPlateVo> listProtalPlate = portalTemplateTraining.getListProtalPlate();
                if (CollectionUtils.isNotEmpty(listProtalPlate)) {
                    //有些模块 没有默认图片，采用甲方给的默认图片
                    List<RelationLinkVo> listRelationLink = portalManagePCFeignClients.getAllListLink(null, 2);
                    for (ProtalPlateVo portalPlate : listProtalPlate) {
                        Long mId = portalPlate.getLinkContent();
                        Integer type = portalPlate.getLinkType();
                        String imgUrl = portalPlate.getImgPath();
                        Integer thumbnail = portalPlate.getThumbnail();//缩略图, 1:使用内容图片, 2:使用新图片
                        //有logo的业务：  课程、线下课程、投票、直播、证书、  培训项目
                        //没有logo：          考试、调研、作业
                        //0 '课程'      1 '考试'             2  '调研'             3  '直播'             4  '投票'                5  '作业'              6  '证书'         7  '外部链接'      8  '报名'       9  '签到'       10  '线下课程'
                        //8，9只是培训项目的条件，不是培训项目的活动  13 纯外链
                        ModuleAllVO mv = portalUtil.getRecommend(mId, type, thumbnail, imgUrl, listRelationLink);
                        //只是为了得到活动的名字
                        if (mv != null) {
                            portalPlate.setLinkContentName(mv.getModuleName());
                        }
                    }
                }

            }
            return Response.ok(portalTemplateTraining);
        } catch (Exception e) {
            LOG.error("精选推荐回显列表:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation("精选推荐/培训项目/课程/新闻选择列表")
    @GetMapping("/template/content/select/trainingProject")
    public Response<Boolean> templateContentSelectTrainingProject(
            @ApiParam(name = "name", value = "查询字段", required = false) @RequestParam(name = "name", required = false) String name,
            @ApiParam(name = "terminalId", value = "终端ID", required = false) @RequestParam(name = "terminalId", required = false) Long terminalId,
            @ApiParam(name = "moduleType", value = "moduleType,6是案例库", required = true) @RequestParam(name = "moduleType", required = true) Integer moduleType,
            @ApiParam(name = "pageNo", value = "pageNo", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "pageSize", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "100") Integer pageSize) {
        try {


            //选出已经关联的内容
            List<Long> ids = portalManagePCFeignClients.templateContentViewByTerminalIdAndModuleType(terminalId, moduleType);
            List<PortalProjectActivityVO> listEnd = new ArrayList<PortalProjectActivityVO>();
            Map<String, Integer> pageMap = new HashMap<String, Integer>();
            PortalProjectActivityVO po = null;
            Integer pagetotal = 0;

            if (moduleType == 1 || moduleType == 2) {
                SearchProjectVo searchProjectVo = new SearchProjectVo();
                searchProjectVo.setSiteId(ContextHolder.get().getSiteId());
                searchProjectVo.setName(name);
                searchProjectVo.setPageNo(pageNo);
                searchProjectVo.setPageSize(pageSize);
                if (moduleType == 2) {//培训项目过滤
                    searchProjectVo.setListIds(ids);
                }
                Page<TrainingProjectVo> page = tpProjectClient.listNotIds(searchProjectVo);

                if (page != null) {
                    pagetotal = page.getTotal();
                    List<TrainingProjectVo> list = page.getRecords();
                    if (CollectionUtils.isNotEmpty(list)) {
                        for (int i = 0; i < list.size(); i++) {
                            po = new PortalProjectActivityVO();
                            po.setId(list.get(i).getId());
                            po.setName(list.get(i).getName());
                            listEnd.add(po);
                        }
                    }
                } else {
                    pagetotal = 0;
                    listEnd = new ArrayList<PortalProjectActivityVO>();
                }
            } else if (moduleType == 3) {
                // 修改 2019-6-28 18:00:23
                Page<CourseEntityVo> page = courseClient.listNotIds(ContextHolder.get().getSiteId(), name, ids, pageNo, pageSize);
                if (page != null) {
                    pagetotal = page.getTotal();
                    List<CourseEntityVo> list = page.getRecords();
                    if (CollectionUtils.isNotEmpty(list)) {
                        for (int i = 0; i < list.size(); i++) {
                            po = new PortalProjectActivityVO();
                            po.setId(list.get(i).getId());
                            po.setName(list.get(i).getName());
                            listEnd.add(po);
                        }
                    }
                } else {
                    pagetotal = 0;
                    listEnd = new ArrayList<PortalProjectActivityVO>();
                }
            } else if (moduleType == 5) {
                Page<InformationViewVO> page = portalManagePCFeignClients.newsGetAll(terminalId, pageNo, pageSize);
                if (page != null) {
                    pagetotal = page.getTotal();
                    List<InformationViewVO> list = page.getRecords();
                    if (CollectionUtils.isNotEmpty(list)) {
                        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        for (int i = 0; i < list.size(); i++) {
                            po = new PortalProjectActivityVO();
                            po.setId(list.get(i).getId());
                            po.setName(list.get(i).getFileName());
                            po.setReleaseTime(sim.format(list.get(i).getReleaseTime()));
                            listEnd.add(po);
                        }
                    }
                } else {
                    pagetotal = 0;
                    listEnd = new ArrayList<PortalProjectActivityVO>();
                }
            } else if (moduleType == PortalEnum.FOUR.ordinal()) {
                LecturerTemplateVO lecturerTemplateVO = new LecturerTemplateVO();
                lecturerTemplateVO.setIds(ids);
                lecturerTemplateVO.setName(name);
                lecturerTemplateVO.setPageNo(PortalEnum.ONE.ordinal());
                lecturerTemplateVO.setPageSize(2000);
                Page<TemplateLecturerVO> templateLecturerVOPage = lecturerClient.queryLecturerByTemplateId(lecturerTemplateVO);
                if (CollectionUtils.isNotEmpty(templateLecturerVOPage.getRecords())) {
                    pagetotal=templateLecturerVOPage.getTotal();
                    listEnd = templateLecturerVOPage.getRecords().parallelStream().map(
                            lecturerListVO -> {
                                PortalProjectActivityVO vo = new PortalProjectActivityVO();
                                vo.setId(lecturerListVO.getId());
                                vo.setName(lecturerListVO.getName());
                                return vo;
                            }
                    ).collect(toList());
                    log.info("长度1：" + listEnd.size());
                    listEnd.stream().filter(p ->
                            !ids.contains(p.getId())
                    ).collect(toList());
                    log.info("长度2：" + listEnd.size());
                } else {
                    pagetotal = 0;
                    listEnd = new ArrayList<PortalProjectActivityVO>();
                }
            } else if((moduleType==PortalEnum.SIX.ordinal())){
                HomeListParam homeListParam = new HomeListParam();
                homeListParam.setKey(name);
                homeListParam.setStudentCaseIds(ids);
                homeListParam.setPageNo(pageNo);
                homeListParam.setPageSize(pageSize);
                try {
                    Page<StudentCaseVO> studentCaseHomeList = studentCaseClient.getStudentCaseHomeList(homeListParam);

                    if (CollectionUtils.isNotEmpty(studentCaseHomeList.getRecords())) {
                        pagetotal=studentCaseHomeList.getTotal();
                        listEnd = studentCaseHomeList.getRecords().parallelStream().map(
                                studentCase -> {
                                    PortalProjectActivityVO vo = new PortalProjectActivityVO();
                                    vo.setId(studentCase.getId());
                                    vo.setName(studentCase.getTitle());
                                    vo.setIcon(studentCase.getLogoUrl());
                                    vo.setCreateByName(studentCase.getCreateByName());
                                    vo.setCreateTime(studentCase.getCreateTime());
                                    return vo;
                                }
                        ).collect(toList());

                        log.info("长度1：" + listEnd.size());
                        listEnd.stream().filter(p ->
                                !ids.contains(p.getId())
                        ).collect(toList());
                        log.info("长度2：" + listEnd.size());

                    } else {
                        pagetotal = 0;
                        listEnd = new ArrayList<PortalProjectActivityVO>();
                    }
                } catch (Exception e) {
                    LOG.info("案例库返回异常{}",e.getMessage());
                    return Response.fail(Constants.CASELIBRARY_MSG_BIZ_ERROR);
                }

            }else if (moduleType == PortalEnum.EIGHT.ordinal()) {
            	ApiSearchAlbumVo vo = new ApiSearchAlbumVo();
            	vo.setName(name);
            	vo.setIds(ids);
            	vo.setCompanyId(ContextHolder.get().getCompanyId());
            	vo.setSiteId(ContextHolder.get().getSiteId());
            	vo.setPageNo(pageNo);
            	vo.setPageSize(pageSize);
				Page<Album> page = albumClient.listNoIds(vo);
                if (page != null) {
                    pagetotal = page.getTotal();
                    List<Album> list = page.getRecords();
                    if (CollectionUtils.isNotEmpty(list)) {
                        for (int i = 0; i < list.size(); i++) {
                            po = new PortalProjectActivityVO();
                            po.setId(list.get(i).getId());
                            po.setName(list.get(i).getName());
                            listEnd.add(po);
                        }
                    }
                } else {
                    pagetotal = 0;
                    listEnd = new ArrayList<PortalProjectActivityVO>();
                }
			}
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            pageMap.put("pageTotal", pagetotal);
            return Response.ok(listEnd, pageMap);
        } catch (Exception e) {
            LOG.error("精选推荐/培训项目/课程/新闻选择列表:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation("根据培训项目挑选活动列表")
    @GetMapping("/template/content/select/activity/by/id")
    public Response<List<PortalProjectActivityVO>> templateContentSelectActivityByTrainingprojectId(
            @ApiParam(name = "id", value = "id", required = true) @RequestParam(name = "id", required = true) Long id) {
        try {

            List<TpPlanActivityVo> list = tpPlanActivityClient.allListByTpId(id);
            List<PortalProjectActivityVO> listPortalProjectActivityVO = null;

            if (CollectionUtils.isNotEmpty(list)) {
                listPortalProjectActivityVO = new ArrayList<PortalProjectActivityVO>();
                PortalProjectActivityVO vo = null;
                for (int i = 0; i < list.size(); i++) {
                    vo = new PortalProjectActivityVO();
                    if (list.get(i).getType() != 7) {
                        vo.setId(list.get(i).getRelationId());
                    } else {//如果是外链取ID
                        vo.setId(list.get(i).getId());
                    }

                    vo.setName(list.get(i).getName());
                    vo.setType(list.get(i).getType());
                    listPortalProjectActivityVO.add(vo);
                }
            }
            return Response.ok(listPortalProjectActivityVO);
        } catch (Exception e) {
            LOG.error("根据培训项目挑选活动列表:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    /**
     * --------------------------------------------------------------------------------------------------------
     * --------------------------------------------------------------------------------------------------------
     * --------------------------------------------------------------------------------------------------------
     * ************************下边的这些接口没用到（页底），也没联调。
     * ************************原因：有人把这部分功能做了。
     * --------------------------------------------------------------------------------------------------------
     * --------------------------------------------------------------------------------------------------------
     * --------------------------------------------------------------------------------------------------------
     */


    @ApiOperation("保存页底/文案/链接保存")
    @PostMapping("/page/save/message")
    public Response<Boolean> pageBottomSave(@RequestBody TrPortalPagePCVo trPortalPagePCVo) {
        try {
            return Response.ok(portalManagePCFeignClients.pageBottomSave(trPortalPagePCVo));
        } catch (Exception e) {
            LOG.error("保存页底/文案/链接保存:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    @ApiOperation("页底展示")
    @GetMapping("/page/bottom/view")
    public Response<Boolean> pageBottomView(@ApiParam(name = "terminalId", value = "终端ID", required = true) @RequestParam(name = "terminalId", required = true) Long terminalId) {
        try {
            return Response.ok(portalManagePCFeignClients.pageBottomView(terminalId));
        } catch (Exception e) {
            LOG.error("页底展示:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }

    }


    @ApiOperation("页底修改规则")
    @GetMapping("/page/message/update")
    public Response<Boolean> pageBottomUpdateSort(@ApiParam(name = "pageId", value = "页底ID", required = true) @RequestParam(name = "pageId", required = true) Long pageId,
                                                  @ApiParam(name = "type", value = "类型,默认页底0，选择页底1", required = true) @RequestParam(name = "type", required = true) Integer type) {
        try {
            return Response.ok(portalManagePCFeignClients.pageBottomUpdate(pageId, type));
        } catch (Exception e) {
            LOG.error("页底修改规则:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }

    }


    @ApiOperation("页底修改排序规则")
    @GetMapping("/page/message/update/sort")
    public Response<Boolean> pageBottomUpdate(@ApiParam(name = "id", value = "链接ID(主键)", required = true) @RequestParam(name = "id", required = true) Long id,
                                              @ApiParam(name = "isDown", value = "是否下一个0是  1不是", required = true) @RequestParam(name = "isDown", required = true) Integer isDown) {
        try {
            return Response.ok(portalManagePCFeignClients.pageBottomUpdateSort(id, isDown));
        } catch (Exception e) {
            LOG.error("页底修改规则:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }

    }

    @ApiOperation("模块排序")
    @GetMapping("/plate/sort")
    public Response<Boolean> sortPlate(@ApiParam(name = "id", value = "链接ID(主键)", required = true) @RequestParam(name = "id", required = true) Long id,
                                       @ApiParam(name = "code", value = "操作code，向上：up;向下：down；指定：top;", required = true) @RequestParam(name = "code", required = true) String code) {
        boolean flag = false;
        try {
            flag = portalApiFeignClients.sortPlate(id, code);
        } catch (Exception e) {
            return Response.fail();
        }
        if (flag) {
            return Response.ok();
        } else {
            return Response.fail();
        }

    }

    @ApiOperation("模板内容删除")
    @PostMapping("/plate/update")
    public Response<Boolean> delPlate(@RequestBody PlateVO plateVO) {
        try {
            Boolean flag = portalManagePCFeignClients.updatePlate(plateVO);
            if (flag) {
                return Response.ok(ReturnCode.SUCCESS);
            } else {
                return Response.fail(ReturnCode.UPDATE_FAIL.getCode(),ReturnCode.UPDATE_FAIL.getMsg());
            }
        } catch (Exception e) {
            LOG.error("模板内容删除:", e);
            return Response.fail();
        }
    }

    @ApiOperation("修改模板内容并回调")
    @PostMapping("/plate/back/update")
    public Response<ProtalPlateVo> updateBackPlate(@RequestBody PlateVO plateVO) {
        try {
            ProtalPlateVo vo = portalManagePCFeignClients.updateBackPlate(plateVO);
            if (null != vo) {
                return Response.ok(vo);
            } else {
                return Response.fail(ReturnCode.RESOURCE_NOT_FOUND.getCode(),ReturnCode.RESOURCE_NOT_FOUND.getMsg());
            }
        } catch (Exception e) {
            LOG.error("修改模板内容出现异常-->plateId:" + plateVO.getId(), e);
            return Response.fail();
        }
    }

    @ApiOperation("获取模板内容")
    @PostMapping({"/plate/get"})
    public Response<ProtalPlateVo> getPlateBy(@RequestBody ProtalPlateVo protalPlate) {
        try {
            ProtalPlateVo vo = portalManagePCFeignClients.getPlateBy(protalPlate);
            if (null != vo) {
                return Response.ok(vo);
            } else {
                return Response.fail(ReturnCode.RESOURCE_NOT_FOUND.getCode(),ReturnCode.RESOURCE_NOT_FOUND.getMsg());
            }
        } catch (Exception e) {
            LOG.error("获取模板内容出现异常-->plateId:" + protalPlate.getId(), e);
            return Response.fail();
        }
    }


    @ApiOperation(value = "模板内容展示", response = ModuleAllVO.class)
    @GetMapping("/template/plate/view")
    public Response<List<ModuleAllVO>> templatePlateView(@ApiParam(name = "id", value = "模板ID", required = true) @RequestParam(name = "id", required = true) Long id,
                                                         @ApiParam(name = "moduleType", value = "板块类型,1:推荐/精选,2:项目培训,4,讲师库3:课程,5:新闻 10专区", required = true) @RequestParam(name = "moduleType", required = true) Integer moduleType) {
            List<PortalPlateVO> portalPlateVOList = portalApiFeignClients.getPlateVOList(id);
        try {
            //模板关联的活动信息
            List<ProtalPlateVo> listProtalPlate = portalManagePCFeignClients.templateContentView(id);
            //展示集合
            List<ModuleAllVO> listModuleAllVO = null;
            if (CollectionUtils.isNotEmpty(listProtalPlate)) {
                listModuleAllVO = new ArrayList<ModuleAllVO>();
                ModuleAllVO mv = null;
                if (moduleType == PortalEnum.ONE.ordinal()) {
                    for (ProtalPlateVo portalPlate : listProtalPlate) {
                        Long mId = portalPlate.getLinkContent();
                        Integer type = portalPlate.getLinkType();
                        String imgUrl = portalPlate.getImgPath();
                        Integer thumbnail = portalPlate.getThumbnail();//缩略图, 1:使用内容图片, 2:使用新图片
                        //有logo的业务：  课程、线下课程、投票、直播、证书、  培训项目
                        //没有logo：          考试、调研、作业
                        //0 '课程'      1 '考试'             2  '调研'             3  '直播'             4  '投票'                5  '作业'              6  '证书'         7  '外部链接'      8  '报名'       9  '签到'       10  '线下课程'
                        //8，9只是培训项目的条件，不是培训项目的活动   13 门户下的外链
                        List<RelationLinkVo> listRelationLink = portalManagePCFeignClients.getAllListLink(null, 2);
                        mv = portalUtil.getRecommend(mId, type, thumbnail, imgUrl, listRelationLink);
                        mv.setDirections(portalPlate.getDirections());
                        mv.setModuleType(type.toString());
                        mv.setThumbnail(thumbnail);
                        listModuleAllVO.add(mv);
                    }
                } else if (moduleType == PortalEnum.TWO.ordinal()) {
                    List<PortalPlateVO> portalPlateVOS = portalController.getTrainingProject(portalPlateVOList);
                    LOG.info("返回portalPlateVOS=======:" + portalPlateVOS);
                    if (CollectionUtils.isNotEmpty(portalPlateVOS)) {
                        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
                        listModuleAllVO = portalPlateVOS.parallelStream().map(
                                portalPlateVO -> {
                                    ModuleAllVO moduleAllVO = new ModuleAllVO();
                                    moduleAllVO.setId(portalPlateVO.getPlateId());
                                    moduleAllVO.setModuleName(portalPlateVO.getName());
                                    moduleAllVO.setModuleLogo(portalPlateVO.getImage());
                                    if (portalPlateVO.getStartTime() != null) {
                                        moduleAllVO.setStartTime(formate.format(portalPlateVO.getStartTime()));
                                    }
                                    if (portalPlateVO.getEndTime() != null) {
                                        moduleAllVO.setEndTime(formate.format(portalPlateVO.getEndTime()));
                                    } else {
                                    }

                                    return moduleAllVO;
                                }
                        ).collect(toList());
                    }
                } else if (moduleType == PortalEnum.THREE.ordinal()) {
                    List<PortalPlateVO> portalPlateVOS = portalController.getCourse(portalPlateVOList);

                    if (CollectionUtils.isNotEmpty(portalPlateVOS)) {
                        LOG.info("返回的结果课程：" + portalPlateVOS);
                        BigDecimal score = new BigDecimal(5.0);
                        listModuleAllVO = portalPlateVOS.parallelStream().map(
                                portalPlateVO -> {
                                    ModuleAllVO moduleAllVO = new ModuleAllVO();
                                    CourseEntityVo course = courseClient.view(portalPlateVO.getId());
                                    log.info("返回的id：" + portalPlateVO.getPlateId());
                                    moduleAllVO.setId(portalPlateVO.getPlateId());
                                    if (course != null) {
                                        moduleAllVO.setModuleName(course.getName());
                                        moduleAllVO.setModuleLogo(course.getImage());
                                    }
                                    moduleAllVO.setGrade(score);

                                    return moduleAllVO;
                                }
                        ).collect(toList());
                    }

                } else if (moduleType == PortalEnum.FIVE.ordinal()) {
                    List<InformationViewVO> list = portalManagePCFeignClients.getRelationInformation(id);
                    SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
                    if (CollectionUtils.isNotEmpty(list)) {
                        ProtalPlateVo protalPlate;
                        for (InformationViewVO information : list) {
                            mv = new ModuleAllVO();
                            protalPlate = new ProtalPlateVo();
                            protalPlate.setTemplateId(id);
                            protalPlate.setLinkContent(information.getId());
                            protalPlate.setState(PortalEnum.ONE.ordinal());
                            ProtalPlateVo plate = portalManagePCFeignClients.getPlate(protalPlate);
                            mv.setId(plate.getId());
                            mv.setModuleName(information.getFileName());
                            mv.setModuleLogo(information.getLogoPath());
                            mv.setNewsContent(information.getContent());
                            if (information.getReleaseTime() != null) {
                                mv.setReleaseTime(formate.format(information.getReleaseTime()));
                            }
                            listModuleAllVO.add(mv);
                        }
                    }
                } else if (moduleType == PortalEnum.FOUR.ordinal()) {
//                List<PortalPlateVO> portalPlateVOList = portalApiFeignClients.getPlateVOList(id);
                    listModuleAllVO = portalPlateVOList.parallelStream().map(
                            portalPlateVO -> {
                                ModuleAllVO moduleAllVO = new ModuleAllVO();
                                LecturerVo lecturer = lecturerClient.getLecturerById(portalPlateVO.getId());
                                log.info("返回的id：" + portalPlateVO.getPlateId());
                                moduleAllVO.setId(portalPlateVO.getPlateId());
                                moduleAllVO.setModuleName(lecturer.getLecturerName());
                                moduleAllVO.setModuleLogo(lecturer.getAvatar());
                                moduleAllVO.setNewsContent(lecturer.getTitle());
                                return moduleAllVO;
                            }
                    ).collect(toList());

                } else if(moduleType==PortalEnum.SIX.ordinal()){
                    //案例库
//                    List<PortalPlateVO> portalPlateVOList = portalApiFeignClients.getPlateVOList(id);
                    listModuleAllVO = portalPlateVOList.parallelStream().map(
                            portalPlateVO -> {
                                ModuleAllVO moduleAllVO = new ModuleAllVO();
                                StudentCaseStudyVO caseDetails = studentCaseClient.getStudentCaseDetails(portalPlateVO.getId());
                                log.info("返回的id：" + portalPlateVO.getPlateId());
                                moduleAllVO.setId(portalPlateVO.getPlateId());
                                moduleAllVO.setModuleName(caseDetails.getTitle());
                                moduleAllVO.setModuleLogo(caseDetails.getLogoUrl());
                                moduleAllVO.setCreateByName(caseDetails.getAuthorName());
                                return moduleAllVO;
                            }
                    ).collect(toList());

                } else if(moduleType==PortalEnum.SEVEN.ordinal()){
                    // 智能推荐
                    List<Long> ids = portalPlateVOList.parallelStream().map(
                            portalPlateVO -> {
                                return portalPlateVO.getId();
                            }
                    ).collect(toList());

                    List<BusinessVo4Portal> businessVo4Portals  = null;
                    PortalTemplateVo portalTemplate = portalApiPCFeignClients.getPortalTemplate(id);
                    Integer num = portalTemplate!=null?portalTemplate.getNum():8;
                    LOG.info("num的值：{}",num);
                    try {
                        BusinessVo4PortalParam businessVo4PortalParam = new BusinessVo4PortalParam();
                        businessVo4PortalParam.setPageNo(1);
                        businessVo4PortalParam.setPageSize(num);
                        businessVo4PortalParam.setStrategyIds(ids);
                        LOG.info(" 参数：{}", JSON.toJSON(businessVo4PortalParam));
                        BusinessVo4PortalResponse businessVo4PortalResponse = recommendStrategyClient.businessVo4Manage(businessVo4PortalParam);
                        LOG.info(" 智能推荐返回结果：{}", JSON.toJSON(businessVo4PortalResponse));
                        businessVo4Portals = businessVo4PortalResponse.getList();
                    } catch (Exception e) {
                        LOG.info("智能推荐接口：{}",e.getMessage());
                    }

                    if (CollectionUtils.isNotEmpty(businessVo4Portals)) {
                        listModuleAllVO =  businessVo4Portals.parallelStream().map(
                                businessVo4Portal -> {
                                    ModuleAllVO moduleAllVO = new ModuleAllVO();

                                    log.info("返回的id：" +businessVo4Portal.getName());
                                    moduleAllVO.setId(businessVo4Portal.getId());
                                    moduleAllVO.setModuleName(businessVo4Portal.getName());
                                    moduleAllVO.setModuleLogo(businessVo4Portal.getImage());
                                    return moduleAllVO;
                                }
                        ).collect(toList());
                    }

                } else if (moduleType==PortalEnum.EIGHT.ordinal()){
                    // 专辑
                    List<Long> ids = portalPlateVOList.parallelStream().map(
                            portalPlateVO -> {
                                return portalPlateVO.getId();
                            }
                    ).collect(toList());
                    listModuleAllVO =  portalPlateVOList.parallelStream().map(portalPlateVO -> {
                        ModuleAllVO moduleAllVO = new ModuleAllVO();
                        Album album = albumClient.get(portalPlateVO.getId());
                        moduleAllVO.setBizId(album.getId());
                        moduleAllVO.setId(portalPlateVO.getPlateId());
                        moduleAllVO.setModuleName(album.getName());
                        moduleAllVO.setModuleLogo(album.getImage());
                        return moduleAllVO;
                    }).collect(Collectors.toList());
                } else if (moduleType==PortalEnum.NINE.ordinal()){
                    PortalPlateVO portalPlateVO = portalPlateVOList.get(0);
                    ModuleAllVO moduleAllVO = new ModuleAllVO();
                    moduleAllVO.setBizId(portalPlateVO.getId());
                    moduleAllVO.setId(portalPlateVO.getId());
                    moduleAllVO.setModuleName(portalPlateVO.getName());
                    moduleAllVO.setModuleLogo(portalPlateVO.getImage());
                    listModuleAllVO.add(moduleAllVO);
                }else if (moduleType==PortalEnum.TEN.ordinal()){
                    //专区
                    getSiteStudent(listProtalPlate,listModuleAllVO);
                }else if (moduleType==PortalEnum.FIFTEEN.getValue()){
                    //直播
                    listModuleAllVO =  portalPlateVOList.parallelStream().map(portalPlateVO -> {
                        ModuleAllVO moduleAllVO = new ModuleAllVO();
                        Long liveId = portalPlateVO.getId();
                        //查询直播
                        LiveActivityVO live = liveActivityClient.getLive(liveId);
                        moduleAllVO.setBizId(liveId);
                        moduleAllVO.setId(portalPlateVO.getPlateId());
                        moduleAllVO.setModuleName(live.getTitle());
                        moduleAllVO.setModuleLogo(live.getLogoImage());
                        moduleAllVO.setCreateByName(live.getAnchor());
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        moduleAllVO.setStartTime(format.format(live.getStartTime()));
                        moduleAllVO.setEndTime(format.format(live.getEndTime()));
                        moduleAllVO.setChannel(live.getChannel());

                        return moduleAllVO;
                    }).collect(Collectors.toList());
                }else if (moduleType==PortalEnum.TWELVE.getValue()){
                    //付费资源
                    getPayResource(listModuleAllVO,listProtalPlate);
                }
            }
            return Response.ok(listModuleAllVO);
        } catch (Exception e) {
            LOG.error("模板内容展示:", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 获取付费资源 的精品内容列表
     * @param portalPlateList 模板关联付费资源列表
     *
     */
    private List<ModuleAllVO> getPayResource(List<ModuleAllVO> list, List<ProtalPlateVo> portalPlateList) {
        if (org.springframework.util.CollectionUtils.isEmpty(portalPlateList)){
            return list;
        }
        portalPlateList.forEach(portalPlateVO -> {

            ModuleAllVO moduleVO = new ModuleAllVO();
            //类型 type=12 项目
            Integer activityType = portalPlateVO.getLinkType();
            if (null != activityType){
                moduleVO.setModuleType(String.valueOf(activityType));
            }
            Long activityId = portalPlateVO.getLinkContent();
            //目前只有一个项目类型，故不做id区分
            TrainingProjectVo trainingProjectVo = trainingProjectClient.getOne(activityId);
            moduleVO.setId(portalPlateVO.getId());
            moduleVO.setBizId(activityId);
            moduleVO.setModuleName(trainingProjectVo.getName());
            //缩略图, 1:使用内容图片, 2:使用新图片
            Integer thumbnail = portalPlateVO.getThumbnail();
            moduleVO.setThumbnail(thumbnail);
            moduleVO.setModuleLogo(trainingProjectVo.getLogoImg());
            if (null != thumbnail && thumbnail.equals(2)){
                moduleVO.setModuleLogo(portalPlateVO.getImgPath());
            }
            list.add(moduleVO);
        });
        return list;
    }

    /**
     * 获取专区的数据
     *
     * @param listProtalPlate
     * @param listModuleAllVO
     */
    private void getSiteStudent(List<ProtalPlateVo> listProtalPlate, List<ModuleAllVO> listModuleAllVO) {
        if (CollectionUtils.isNotEmpty(listProtalPlate)) {
            //获取实时数据
            List<Long> collect = listProtalPlate.parallelStream().map(a -> a.getLinkContent()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                List<SiteVO> siteVOS = remoteSiteClient.selectByIds(collect);
                if (CollectionUtils.isNotEmpty(siteVOS)) {
                    Map<Long, SiteVO> siteVOMap = siteVOS.parallelStream().collect(Collectors.toMap(SiteVO::getId, a -> a));
                    for (ProtalPlateVo a : listProtalPlate) {
                        ModuleAllVO moduleAllVO = new ModuleAllVO();
                        moduleAllVO.setBizId(a.getLinkContent());
                        moduleAllVO.setId(a.getId());
                        moduleAllVO.setModuleName(a.getLinkContentName());
                        moduleAllVO.setModuleLogo(a.getImgPath());
                        moduleAllVO.setThumbnail(a.getThumbnail());
                        if (siteVOMap != null) {
                            SiteVO siteVO = siteVOMap.get(a.getLinkContent());
                            if (siteVO != null) {
                                moduleAllVO.setModuleLogo(a.getThumbnail() == 0 ? siteVO.getLogo() : a.getImgPath());
                                moduleAllVO.setModuleName(siteVO.getName());
                                moduleAllVO.setDirections(siteVO.getCode());
                                moduleAllVO.setStatus(siteVO.getEnabled() ? 1 : 0);
                            }
                        }
                        listModuleAllVO.add(moduleAllVO);
                    }
                }
            }
        }
    }
}
