package com.yizhi.application.mall.student;

import com.yizhi.training.application.feign.TrainingProjectClient;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @ClassName: MallStuControlller
 * @author: zjl
 * @date: 2021/1/19  13:39
 */
@Api(tags = "学员端-积分商城")
@RestController
@RequestMapping("/student/mall")
public class MallStuControlller {

    @Autowired
    private TrainingProjectClient trainingProjectClient;

    @GetMapping("/shelfState/get")
    @ApiOperation(value = "获取资源获取，判断上下架(true:上架 false:下架)")
    public Response<Boolean> recordInit(@ApiParam(value = "变更类型( 200:项目报名 210:课程报名)", required = true) @RequestParam("type") Integer type,
                                        @ApiParam(value = "业务ID", required = true) @RequestParam("id") Long id) {
        boolean b = false;
        switch (type) {
            case 200:
                b = trainingProjectClient.getShelfUp(id);
                break;
            case 210:
                b = false;
                break;
            default:
                break;
        }
        return Response.ok(b);
    }
}
