package com.yizhi.application.drools.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@Api(tags = "DroolsVo", description = "规则引擎参数VO")
public class DroolsParamsVo {

    @ApiModelProperty("业务类型--course：课程、trainingProject：培训项目、exam：考试、assignment：作业、research：调研、live：直播、case：案例、caseActivity：案例活动 必传")
    private String taskType;

    @ApiModelProperty("业务参数--" +
            "name：业务名称、" +
            "code：业务编码、" +
            "keyword：业务关键词、" +
            "classify：业务分类、" +
            "anchorName: 主播名称、" +
            "author：作者、" +
            "belongCaseActivity：所属案例活动、" +
            "fullName：姓名" +
            "duty：职务" +
            "org：所在部门" +
            "remark1：备注1、" +
            "remark2：备注2、" +
            "remark3：备注3     必传")
    private String taskParamsType;


    @ApiModelProperty("业务参数对应需要搜索的值")
    private String taskParamsValue;


    @ApiModelProperty("当前页码")
    private Integer pageNo = 1;

    @ApiModelProperty("页内条数")
    private Integer pageSize = 10;


}
