package com.yizhi.application.portal.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.feign.api.SystemMailboxClients;
import com.yizhi.site.application.vo.domain.SystemMailboxConditionVo;
import com.yizhi.site.application.vo.domain.SystemMailboxParamVo;
import com.yizhi.site.application.vo.domain.SystemMailboxVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.yizhi.util.application.domain.Response;

/**
 * com.yizhi.site.application.controller.api
 *
 * @author yanglang
 * @create 2025-01-09 14:24:07
 */
@RestController
@RequestMapping("/manage/systemMailbox")
public class SystemMailboxManageController {

    @Autowired
    private SystemMailboxClients systemMailboxClients;

    @PostMapping("selectPage")
    public Response<Page<SystemMailboxVo>> selectPage(@RequestBody SystemMailboxConditionVo conditionVo){
        return Response.ok(systemMailboxClients.selectPage(conditionVo));
    }

    @PostMapping("save/{type}")
    public Response<Long> save(@RequestBody SystemMailboxVo systemMailBoxVo,@PathVariable("type") Integer type){
        systemMailBoxVo.setType(type);
        RequestContext context = ContextHolder.get();
        systemMailBoxVo.setSiteId(context.getSiteId());
        return Response.ok(systemMailboxClients.save(systemMailBoxVo));
    }

    @GetMapping("getById")
    public Response<SystemMailboxVo> getById(@RequestParam("id") Long id){
        return Response.ok(systemMailboxClients.getById(id));
    }

    @GetMapping("removeById")
    public Response<Boolean> removeById(@RequestParam("id")Long id){
        return Response.ok(systemMailboxClients.removeById(id));
    }


    @GetMapping("selectMyPage")
    public Response<Page<SystemMailboxParamVo>> selectMyPage(@RequestParam("pageNo")Integer pageNo, @RequestParam("pageSize")Integer pageSize, @RequestParam("type")Integer type){
        return Response.ok(systemMailboxClients.selectMyPage(pageNo,pageSize, type));
    }
}
