package com.yizhi.application.rangeExport;

import java.util.Map;

import com.yizhi.assignment.application.feign.AssignmentClient;
import com.yizhi.assignment.application.vo.VisibleRangeExport;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.system.application.model.AccountRangeExportParam;
import com.yizhi.system.application.system.remote.AccountRangeClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AssignmentVisibleRangeExport extends AbstractDefaultTask<String, Map<String,Object>> {
	
	
	private static final Logger logger = LoggerFactory.getLogger(AssignmentVisibleRangeExport.class);
	

	@Autowired
	private AssignmentClient assignmentClient;
	@Autowired
	private AccountRangeClient accountRangeClient;
	
	

	@Override
	protected String execute(Map<String, Object> map) {
		// TODO Auto-generated method stub
		Long assignmentId=(Long) map.get("assignmentId");
		RequestContext context=(RequestContext) map.get("context");
		
		VisibleRangeExport visibleRangeExport=assignmentClient.exportVisibleRange(assignmentId);
		AccountRangeExportParam accountRangeImportParam=new AccountRangeExportParam();
		if(visibleRangeExport!=null) {
			accountRangeImportParam.setAccountIds(visibleRangeExport.getAccountIds());
			accountRangeImportParam.setBizName(visibleRangeExport.getBizName());
			accountRangeImportParam.setContext(context);
			accountRangeImportParam.setOrgIds(visibleRangeExport.getOrgIds());
		}
		String result=accountRangeClient.doExport(accountRangeImportParam);
		return result;
		 
	}

}
