package com.yizhi.application.report.trainingproject;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.sign.application.feign.ReportSignClient;
import com.yizhi.sign.application.vo.domain.StatisticsSign;
import com.yizhi.statistics.application.feign.StatisticsSignClient;
import com.yizhi.statistics.application.refactor.sign.StatisticsSignVO;
import com.yizhi.statistics.application.vo.sign.SignAccountGroupVo;
import com.yizhi.statistics.application.vo.sign.StatisticsSignVo;
import com.yizhi.training.application.vo.manage.TrainingProjectDataChartsVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = "报表统计-签到", description = "报表统计-签到")
@RestController
@RequestMapping("/manage/report/trainingproject/")
public class ReportSignController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ReportSignController.class);

    @Autowired
    private ReportSignClient reportSignClient;

    @Autowired
    private StatisticsSignClient statisticsSignClient;


    @ApiOperation(value = "图表数据统计", notes = "图表数据统计", response = TrainingProjectDataChartsVo.class)
    @GetMapping("sign/chart/group")
    public Response<List<TrainingProjectDataChartsVo>> chartGroup(
            @ApiParam(value = "培训项目Id", required = false) @RequestParam(name = "trainningProjectId", required = false) Long trainningProjectId,
            @ApiParam(value = "签到开始时间", required = false) @RequestParam(name = "startDate", required = false) String startDate,
            @ApiParam(value = "签到结束时间", required = false) @RequestParam(name = "endDate", required = false) String endDate
    ) {
        try {
            if (startDate.equals("") || endDate.equals("")) {
                return Response.ok();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            RequestContext context = ContextHolder.get();
            Long CompanyId = context.getCompanyId();
            List<Long> orgIds = context.getOrgIds();
            Long siteId = context.getSiteId();
            List<StatisticsSign> statisticsSigns = reportSignClient.chartGroup(trainningProjectId, startDate, endDate, CompanyId, orgIds, siteId);
            List<TrainingProjectDataChartsVo> chartsVos = new ArrayList<TrainingProjectDataChartsVo>();
            TrainingProjectDataChartsVo chartsVo;
            for (StatisticsSign statisticsSign : statisticsSigns) {
                chartsVo = new TrainingProjectDataChartsVo();
                chartsVo.setTotalFinish(statisticsSign.getJoinStateCount());
                chartsVo.setTotalJoin(statisticsSign.getCanStateCount());
                chartsVo.setTotalProject(1);
                chartsVo.setValue(simpleDateFormat.format(statisticsSign.getSignTime()));
                chartsVos.add(chartsVo);
            }
            return Response.ok(chartsVos);
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    //签到统计迁到报表服务
//    @ApiOperation(value = "某个培训项目签到统计", notes = "某个培训项目签到统计")
//    @GetMapping("/sign/group")
//    public Response<String> signGroup(
//            @ApiParam(value = "培训项目Id",required = false) @RequestParam(name = "projectId",required = false) Long projectId,
//            @ApiParam(value = "培训项目名称",required = false) @RequestParam(name = "kwd",required = false)String kwd,
//            @ApiParam(value = "签到开始时间",required = false) @RequestParam(name = "startDate",required = false)String startDate,
//            @ApiParam(value = "签到结束时间",required = false) @RequestParam(name = "endDate",required = false)String endDate,
//            @ApiParam(value = "当前页",required = false,defaultValue = "1")@RequestParam(name = "pageNo",required = false,defaultValue = "1")Integer pageNo,
//            @ApiParam(value = "每页的个数",required = false,defaultValue = "10")@RequestParam(name = "pageSize",required = false,defaultValue = "10")Integer pageSize){
//
//        try {
//            long start = System.currentTimeMillis();
//            if(startDate == ""){
//                startDate = null;
//            }
//            if(endDate == ""){
//                endDate = null;
//            }
//            RequestContext context= ContextHolder.get();
//            Long companyId=context.getCompanyId();
//            List<Long> orgIds=context.getOrgIds();
//            Long siteId=context.getSiteId();
//            Map<String , Integer> map=new HashMap<String, Integer>();
//            map.put("pageNo",pageNo);
//            map.put("pageSize",pageSize);
//            Page<StatisticsSign> page=reportSignClient.signPage(projectId,kwd,startDate,endDate,companyId,orgIds,siteId,pageNo,pageSize);
//            map.put("pageTotal",page.getTotal());
//            long end = System.currentTimeMillis();
//            System.out.println("(end-start) = " + (end-start));
//            return Response.ok(page.getRecords(),map);
//        }catch (Exception e){
//            e.printStackTrace();
//            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
//        }
//
//    }

    @ApiOperation(value = "签到统计列表", notes = "签到统计列表")
    @GetMapping("/sign/group")
    public Response<StatisticsSign> signGroup(
            @ApiParam(value = "培训项目Id", required = false) @RequestParam(name = "projectId", required = false) Long projectId,
            @ApiParam(value = "培训项目名称", required = false) @RequestParam(name = "kwd", required = false) String kwd,
            @ApiParam(value = "签到开始时间", required = false) @RequestParam(name = "startDate", required = false) String startDate,
            @ApiParam(value = "签到结束时间", required = false) @RequestParam(name = "endDate", required = false) String endDate,
            @ApiParam(value = "当前页", required = false, defaultValue = "1") @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @ApiParam(value = "每页的个数", required = false, defaultValue = "10") @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {

        try {
            Map<String, Integer> map = new HashMap<String, Integer>();
            if (StringUtils.isNotBlank(kwd)) {
                kwd = kwd.trim();
            }
            map.put("pageNo", pageNo);
            map.put("pageSize", pageSize);
            Page<StatisticsSignVO> page = statisticsSignClient.signGroup(projectId, kwd, startDate, endDate, pageNo, pageSize);
            map.put("pageTotal", page.getTotal());
            return Response.ok(page.getRecords(), map);
        } catch (Exception e) {
            LOGGER.error("获取报表数据出现错误", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }

    }

    //签到统计查看,迁到报表服务
//    @ApiOperation(value = "某个培训项目签到详情统计", notes = "某个培训项目详情签到统计")
//    @GetMapping("/sign/group/view")
//    public Response<String> signView(
//            @ApiParam(value = "签到id",required = true) @RequestParam(name = "id",required = true) Long id,
//            @ApiParam(value = "培训项目id",required = true) @RequestParam(name = "projectId",required = true) Long projectId,
//            @ApiParam(value = "签到开始时间",required = false) @RequestParam(name = "startDate",required = false) String startDate,
//            @ApiParam(value = "签到结束时间",required = false) @RequestParam(name = "endDate",required = false) String endDate,
//            @ApiParam(value = "部门编码或名称",required = false) @RequestParam(name = "orgNameOrCode",required = false)String orgNameOrCode,
//            @ApiParam(value = "用户关键字",required = false) @RequestParam(name = "accountName",required = false)String accountName,
//            @ApiParam(value = "当前页",required = false,defaultValue = "1")@RequestParam(name = "pageNo",required = false,defaultValue = "1")Integer pageNo,
//            @ApiParam(value = "每页的个数",required = false,defaultValue = "10")@RequestParam(name = "pageSize",required = false,defaultValue = "10")Integer pageSize){
//       try {
//           if(startDate == ""){
//               startDate = null;
//           }
//           if(endDate == ""){
//               endDate = null;
//           }
//           if(orgNameOrCode !=null){
//               orgNameOrCode = orgNameOrCode.replace(" ","");
//           }
//           if(orgNameOrCode == ""){
//               orgNameOrCode = null ;
//           }
//           if(accountName !=null){
//               accountName = accountName.replace(" ","");
//           }
//           if(accountName == ""){
//               accountName = null;
//           }
//           RequestContext context = ContextHolder.get();
//           Map<String, Integer> map = new HashMap<String, Integer>();
//           Page<StatisticsSign> page = reportSignClient.signView(id,projectId,startDate,endDate,orgNameOrCode, accountName, pageNo, pageSize);
//           map.put("pageNo", pageNo);
//           map.put("pageSize", pageSize);
//           map.put("pageTotal", page.getTotal());
//           return Response.ok(page.getRecords(),map);
//       }catch (Exception e){
//           e.printStackTrace();
//           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
//       }
//
//    }

    @ApiOperation(value = "签到统计查看", notes = "签到统计查看")
    @GetMapping("/sign/group/view")
    public Response<StatisticsSign> signView(
            @ApiParam(value = "签到id", required = true) @RequestParam(name = "id", required = true) Long id,
            @ApiParam(value = "签到时间id", required = true) @RequestParam(name = "projectId", required = true) Long projectId,
            @ApiParam(value = "签到开始时间", required = false) @RequestParam(name = "startDate", required = false) String startDate,
            @ApiParam(value = "签到结束时间", required = false) @RequestParam(name = "endDate", required = false) String endDate,
            @ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgNameOrCode", required = false) String orgNameOrCode,
            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountName", required = false) String accountName,
            @ApiParam(value = "当前页", required = false, defaultValue = "1") @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @ApiParam(value = "每页的个数", required = false, defaultValue = "10") @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        try {
            if (StringUtils.isNotBlank(orgNameOrCode)) {
                orgNameOrCode = orgNameOrCode.trim();
            }
            if (StringUtils.isNotBlank(accountName)) {
                accountName = accountName.trim();
            }
            Map<String, Integer> map = new HashMap<String, Integer>();
            Page<StatisticsSignVO> page = statisticsSignClient.signView(id, projectId, startDate, endDate, orgNameOrCode, accountName, pageNo, pageSize);
            map.put("pageNo", pageNo);
            map.put("pageSize", pageSize);
            map.put("pageTotal", page.getTotal());
            return Response.ok(page.getRecords(), map);
        } catch (Exception e) {
            LOGGER.error("获取报表数据出现错误", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }

    }

    @GetMapping("/sign/asynchronous/load/data")
    public Response<String> asynchronousSign(
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startTime", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endTime", required = false) String endTime) {
        reportSignClient.asynchronousSign(startTime, endTime);
        return Response.ok("ok");
    }


    @ApiOperation(value = "签到-按用户统计列表", notes = "签到-按用户统计列表" ,response = SignAccountGroupVo.class)
    @GetMapping("/sign/account/group")
    public Response<SignAccountGroupVo> signAccountGroup(
            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd,
            @ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgKwd", required = false) String orgKwd,
            @ApiParam(value = "签到开始时间", required = true) @RequestParam(name = "startDate", required = true) String startDate,
            @ApiParam(value = "签到结束时间", required = true) @RequestParam(name = "endDate", required = true) String endDate,
            @ApiParam(value = "当前页", required = false, defaultValue = "1") @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @ApiParam(value = "每页的个数", required = false, defaultValue = "10") @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {

        try {
            Map<String, Integer> map = new HashMap<String, Integer>();
            if (StringUtils.isNotBlank(accountKwd)) {
                accountKwd = accountKwd.trim();
            }
            if (StringUtils.isNotBlank(orgKwd)) {
                orgKwd = orgKwd.trim();
            }
            map.put("pageNo", pageNo);
            map.put("pageSize", pageSize);
            Page<SignAccountGroupVo> page = statisticsSignClient.signAccountGroup(accountKwd, orgKwd, startDate, endDate, pageNo, pageSize);
            map.put("pageTotal", page.getTotal());
            return Response.ok(page.getRecords(), map);
        } catch (Exception e) {
            LOGGER.error("获取报表数据出现错误", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }

    }


    @ApiOperation(value = "签到-按用户统计-查看详情", notes = "签到-按用户统计-查看详情" , response = StatisticsSignVo.class)
    @GetMapping("/sign/account/group/view")
    public Response<StatisticsSignVo> signAccountView(
            @ApiParam(value = "用户id", required = true) @RequestParam(name = "accountId", required = true) Long accountId,
            @ApiParam(value = "签到开始时间", required = true) @RequestParam(name = "startDate", required = true) String startDate,
            @ApiParam(value = "签到结束时间", required = true) @RequestParam(name = "endDate", required = true) String endDate,
            @ApiParam(value = "项目关键字", required = false) @RequestParam(name = "projectKwd", required = false) String projectKwd,
            @ApiParam(value = "当前页", required = false, defaultValue = "1") @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @ApiParam(value = "每页的个数", required = false, defaultValue = "10") @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        try {
            if (StringUtils.isNotBlank(projectKwd)) {
                projectKwd = projectKwd.trim();
            }

            Map<String, Integer> map = new HashMap<String, Integer>();
            Page<StatisticsSignVo> page = statisticsSignClient.signAccountView(accountId, startDate, endDate, projectKwd, pageNo, pageSize);
            map.put("pageNo", pageNo);
            map.put("pageSize", pageSize);
            map.put("pageTotal", page.getTotal());
            return Response.ok(page.getRecords(), map);
        } catch (Exception e) {
            LOGGER.error("获取报表数据出现错误", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }

    }
}
