package com.yizhi.application.document;


import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.documents.application.feign.DocumentRelationClient;
import com.yizhi.documents.application.vo.documents.DocumentRelationVo;
import com.yizhi.documents.application.vo.documents.ModelVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author hutao
 * @since 2019-06-11
 */
@Api(tags = "资料库关联表管理端接口", description = "资料库关联表管理端接口")
@RestController
@RequestMapping("/manage/documentRelation")
public class DocumentRelationController {

    @Autowired
    DocumentRelationClient documentRelationClient;


    @PostMapping("/delete")
    @ApiOperation(value = "删除关联关系", notes = "删除关联关系", response = String.class)
    public Response delete(@ApiParam("id必传！") @RequestBody ModelVo modelVo) {
        if (modelVo.getId() == null) {
            return Response.fail(InternationalEnums.DOCUMENTRELATIONCONTROLLER1.getCode());
        }
        if (documentRelationClient.delete(modelVo)) {
            return Response.ok("删除成功!");
        }
        return Response.fail(InternationalEnums.DOCUMENTRELATIONCONTROLLER2.getCode());
    }

    @PostMapping("/batch/save")
    @ApiOperation(value = "保存多个关联关系", notes = "保存多个关联关系", response = String.class)
    public Response save(@ApiParam("documentIds、relationType、relationId 必传") @RequestBody DocumentRelationVo documentRelationVo) {

        if (documentRelationVo.getDocumentIds() == null || documentRelationVo.getRelationType() == null
                || documentRelationVo.getRelationId() == null) {
            return Response.fail(InternationalEnums.DOCUMENTRELATIONCONTROLLER3.getCode());
        }
        if (documentRelationClient.save(documentRelationVo)) {
            return Response.ok("添加成功！");

        } else {
            return Response.fail(InternationalEnums.DOCUMENTRELATIONCONTROLLER4.getCode());
        }
    }

    @PostMapping("/move")
    @ApiOperation(value = "上移下移", notes = "上移下移", response = String.class)
    public Response move(@ApiParam("id、moveUp(true:上移 false:下移 )    必传") @RequestBody DocumentRelationVo documentRelationVo) {

        if (documentRelationVo.getId() == null || documentRelationVo.getMoveUp() == null) {
            return Response.fail(InternationalEnums.DOCUMENTRELATIONCONTROLLER5.getCode());
        }
        if (documentRelationClient.move(documentRelationVo)) {
            if (documentRelationVo.getMoveUp()) {
                return Response.ok("上移成功!");
            } else {
                return Response.ok("下移成功!");
            }
        } else {
            return Response.fail(InternationalEnums.DOCUMENTRELATIONCONTROLLER6.getCode());
        }
    }

}

