/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: TrExamAuthorizeController
 * Author:   phone
 * Date:     2018/3/29 20:34
 * Description: 考试人员范围
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.application.exam.controller;


import com.yizhi.exam.application.feign.ExamAuthorizeClient;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈考试人员范围〉
 *
 * @author fanchunhui
 * @create 2018/3/29
 * @since 1.0.0
 */
@RestController
@Api(tags = "管理端-考试人员接口", description = "管理端-考试人员接口")
@RequestMapping("/manage/exam")
public class ExamAuthorizeController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExamAuthorizeController.class);

    @Autowired
    ExamAuthorizeClient examAuthorizeClient;

    @ApiOperation(value="查看学员", notes="查看学员")
    @GetMapping(value="/account/list")
    public Response<Long> findStudentByExamId(@ApiParam(name = "examId",value = "考试id")@RequestParam(name = "examId",required = true) Long examId){
        List<Long> studentIdList = null;
        try{
            studentIdList= examAuthorizeClient.findStudentByExamId(examId);
            return Response.ok(studentIdList);
        }catch (Exception e) {
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }
}