package com.yizhi.application.report.trainingproject;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.training.application.feign.TrainingProjectReportClient;
import com.yizhi.training.application.vo.manage.*;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.plugins.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 培训项目报表统计
 * @author mei
 *
 */

@Api(tags = "报表统计-培训项目", description = "报表统计-培训项目")
@RestController
@RequestMapping("/manage/report/trainingproject/11111")
public class ReportTrainingProject {
	
	
	@Autowired
	private TrainingProjectReportClient trainingProjectReportClient;
	
	@Autowired
	private TrainingProjectGroupExport trainingProjectGroupExport;
	
	@Autowired
	private TrainingProjectGroupViewExport1 trainingProjectGroupViewExport1;
	
	@Autowired
	private TrainingProjectGroupViewExport2 trainingProjectGroupViewExport2;
	
	@Autowired
	private TrainingProjectGroupViewExport3 trainingProjectGroupViewExport3;
	
	@Autowired
	private TrainingProjectGroupViewExport4 trainingProjectGroupViewExport4;
	
	@Autowired
	private TrainingProjectAccountGroupViewExport trainingProjectAccountGroupViewExport;
	
	@Autowired
	private TrainingProjectAccountGroupExport trainingProjectAccountGroupExport;
	

	
	
	
	@ApiOperation(value = "报表统计入库", notes = "按部门统计")
	@GetMapping("/into/trainingproject/report")
	public Response<String> intoCourseReport(@ApiParam(value = "开始时间（yyyy-mm-dd）", required = false) @RequestParam(name = "startDate", required = false) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = false) @RequestParam(name = "endDate", required = false) String endDate) {
		String result = trainingProjectReportClient.AsynchronousCourse(startDate,endDate);
		return Response.ok(result);
	}
	
	

	@ApiOperation(value = "图表数据统计", notes = "图表数据统计", response = TrainingProjectDataChartsVo.class)
    @GetMapping("/chart/group")
    public Response<TrainingProjectDataChartsVo> chartGroup(
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate){
		Long siteId= ContextHolder.get().getSiteId();
		Long companyId=ContextHolder.get().getCompanyId();
		List<Long> orgIds=ContextHolder.get().getOrgIds();
		RequestContext requestContext=ContextHolder.get();
		if (!requestContext.isAdmin() && !CollectionUtils.isEmpty(requestContext.getOrgIds())) {
			orgIds = requestContext.getOrgIds();
		}
		List<TrainingProjectDataChartsVo> list=null;
		try {
			list=trainingProjectReportClient.chartGroup(startDate, endDate, companyId,orgIds,siteId);
			return Response.ok(list);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}
	
	
	/**
	 *  统计周期只对培训项目起作用，但是对培训项目的应该参加人数，实际参加人数和实际完成人数不起作用
	 * @param startDate
	 * @param endDate
	 * @param kwd
	 * @param pageSize
	 * @param pageNo
	 * @return
	 */
	@ApiOperation(value = "按项目统计", notes = "按项目统计", response = ReportStudyTrainingProjectVo.class)
    @GetMapping("/group")
    public Response<ReportStudyTrainingProjectVo> trainingProjectGroup(
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate, 
    		@ApiParam(value = "项目名称关键字", required = false) @RequestParam(name = "kwd", required = false) String kwd,     		 
    		@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
    		@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo){
		try {
			Long siteId=ContextHolder.get().getSiteId();
			Long companyId=ContextHolder.get().getCompanyId();
			List<Long> orgIds=ContextHolder.get().getOrgIds();
			RequestContext requestContext=ContextHolder.get();
			if (!requestContext.isAdmin() && !CollectionUtils.isEmpty(requestContext.getOrgIds())) {
				orgIds = requestContext.getOrgIds();
			}
			
			//后台获取数据
			Page<ReportStudyTrainingProjectVo> page=trainingProjectReportClient.trainingProjectGroup(kwd, startDate, endDate, pageNo, pageSize,companyId,orgIds, siteId);
			if(page==null) {
				return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
			}
			Map<String, Integer> pageMap = new HashMap<String, Integer>();
			pageMap.put("pageNo", pageNo);
			pageMap.put("pageSize", pageSize);
			pageMap.put("pageTotal", page.getTotal());
			return Response.ok(page.getRecords(), pageMap);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}
	
	
	
	/**
	 * 统计周期只对培训项目起作用，但是对培训项目的应该参加人数，实际参加人数和实际完成人数不起作用
	 * @param startDate
	 * @param endDate
	 * @param kwd
	 * @return
	 */
	@ApiOperation(value = "按项目统计导出记录", notes = "按项目统计导出记录", response = ReportStudyTrainingProjectVo.class)	
    @GetMapping("/group/export")
    public Response<ReportStudyTrainingProjectVo> trainingProjectGroupExport(
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate, 
    		@ApiParam(value = "项目名称关键字", required = false) @RequestParam(name = "kwd", required = false) String kwd){
		
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="培训项目-按项目统计-下载结果数据-"+taskId;
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("startDate", startDate);
		map.put("endDate", endDate);
		map.put("kwd", kwd);
		map.put("accountId", ContextHolder.get().getAccountId());
		map.put("orgIds", ContextHolder.get().getOrgIds());
		map.put("siteId", ContextHolder.get().getSiteId());
		map.put("companyId", ContextHolder.get().getCompanyId());
		map.put("serialNo", serialNo);
		map.put("taskId", taskId);
		map.put("submitTime", submitTime);
		map.put("taskName", taskName);
		trainingProjectGroupExport.execute(map, true);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}
	
	
	
	@ApiOperation(value = "按项目统计-查看", notes = "按项目统计-查看", response = TrainingProjectDataChartsVo.class)	
    @GetMapping("/group/view")
    public Response<TrainingProjectDataChartsVo> trainingProjectGroupView(
    		@ApiParam(value = "项目ID", required = true) @RequestParam(name = "projectId", required = true) Long projectId,     	
    		@ApiParam(value = "每页条数", required = false) @RequestParam(name = "pageSize", required = false) Integer pageSize,
    		@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false) Integer pageNo){
		Page<TrainingProjectDataChartsVo> dataChartsVos=null;
		try {
			if(pageNo==null) {
				pageNo=1;
				
			}
			if(pageSize==null) {
				pageSize=Integer.MAX_VALUE;
			}
			dataChartsVos=trainingProjectReportClient.trainingProjectGroupView(projectId,pageNo,pageSize);
			return Response.ok(dataChartsVos);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}
	
	
	@ApiOperation(value = "按项目统计-查看-下载项目学习结果-导出记录", notes = "按项目统计-查看-下载项目学习结果-导出记录")	
    @GetMapping("/group/view/export1")
    public Response<String> trainingProjectGroupViewExport1(
    		@ApiParam(value = "项目ID", required = true) @RequestParam(name = "projectId", required = true) Long projectId){
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="培训项目-按项目统计-查看-下载项目学习结果-导出记录-"+taskId;
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("projectId", projectId);
		map.put("accountId", ContextHolder.get().getAccountId());
		map.put("orgIds", ContextHolder.get().getOrgIds());
		map.put("siteId", ContextHolder.get().getSiteId());
		map.put("companyId", ContextHolder.get().getCompanyId());
		map.put("serialNo", serialNo);
		map.put("taskId", taskId);
		map.put("submitTime", submitTime);
		map.put("taskName", taskName);
		trainingProjectGroupViewExport1.execute(map, true);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}
	
	
	
	
	@ApiOperation(value = "按项目统计-查看-学习计划明细-导出记录", notes = "按项目统计-查看-学习计划明细-导出记录")	
    @GetMapping("/group/view/export2")
    public Response<String> trainingProjectGroupViewExport2(
    		@ApiParam(value = "项目ID", required = true) @RequestParam(name = "projectId", required = true) Long projectId){
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="培训项目-按项目统计-查看-学习计划明细-导出记录-"+taskId;
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("projectId", projectId);
		map.put("accountId", ContextHolder.get().getAccountId());
		map.put("orgIds", ContextHolder.get().getOrgIds());
		map.put("siteId", ContextHolder.get().getSiteId());
		map.put("companyId", ContextHolder.get().getCompanyId());
		map.put("serialNo", serialNo);
		map.put("taskId", taskId);
		map.put("submitTime", submitTime);
		map.put("taskName", taskName);
		trainingProjectGroupViewExport2.execute(map, true);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}
	
	
	
	
	
	/**
	 *      这个放弃不用了
	 * @param projectId
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	@ApiOperation(value = "按项目统计-查看-学员学习明细-导出记录", notes = "按项目统计-查看-学员学习明细-导出记录")	
    @GetMapping("/group/view/export333333")
    public Response<String> trainingProjectGroupViewExport3(
    		@ApiParam(value = "项目ID", required = true) @RequestParam(name = "projectId", required = true) Long projectId,
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate){
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="培训项目-按项目统计-查看-学员学习明细-导出记录-"+taskId;
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("projectId", projectId);
		map.put("startDate", startDate);
		map.put("endDate", endDate);
		map.put("accountId", ContextHolder.get().getAccountId());
		map.put("orgIds", ContextHolder.get().getOrgIds());
		map.put("siteId", ContextHolder.get().getSiteId());
		map.put("companyId", ContextHolder.get().getCompanyId());
		map.put("serialNo", serialNo);
		map.put("taskId", taskId);
		map.put("submitTime", submitTime);
		map.put("taskName", taskName);
		trainingProjectGroupViewExport3.execute(map, true);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}
	
	
	
	@ApiOperation(value = "按项目统计-查看-学员学习明细-导出记录", notes = "按项目统计-查看-学员学习明细-导出记录")	
    @GetMapping("/group/view/export3")
    public Response<String> trainingProjectGroupViewExport4(
    		@ApiParam(value = "项目ID", required = true) @RequestParam(name = "projectId", required = true) Long projectId){
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="培训项目-按项目统计-查看-学员学习明细-导出记录-"+taskId;
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("projectId", projectId);
		map.put("accountId", ContextHolder.get().getAccountId());
		map.put("orgIds", ContextHolder.get().getOrgIds());
		map.put("siteId", ContextHolder.get().getSiteId());
		map.put("companyId", ContextHolder.get().getCompanyId());
		map.put("serialNo", serialNo);
		map.put("taskId", taskId);
		map.put("submitTime", submitTime);
		map.put("taskName", taskName);
		trainingProjectGroupViewExport4.execute(map, true);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}
	
	
	
	
	@ApiOperation(value = "按用户统计", notes = "按用户统计", response = ReportStudyTrainingProjectAccountVo.class)
    @GetMapping("/account/group")
    public Response<ReportStudyTrainingProjectAccountVo> trainingProjectAccountGroup(
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate, 
    		@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgKwd", required = false) String orgKwd,    
    		@ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd,    
    		@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
    		@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo){
		Long siteId=ContextHolder.get().getSiteId();
		Long companyId=ContextHolder.get().getCompanyId();
		List<Long> orgIds=ContextHolder.get().getOrgIds();
		Date sta=new Date();
		Page<ReportStudyTrainingProjectAccountVo> page=trainingProjectReportClient.trainingProjectAccountGroup(startDate, endDate, orgKwd, accountKwd, pageSize, pageNo, companyId, orgIds, siteId);
		Date end=new Date();
		System.out.println((end.getTime()-sta.getTime())/1000);
		if(page==null) {
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
		//向外抛出
		Map<String, Integer> pageMap = new HashMap<String, Integer>();
		pageMap.put("pageNo", pageNo);
		pageMap.put("pageSize", pageSize);
		pageMap.put("pageTotal", page.getTotal());
		return Response.ok(page.getRecords(), pageMap);
	}
	
	
	
	
	
	@ApiOperation(value = "按用户统计导出记录", notes = "按用户统计导出记录", response = ReportStudyTrainingProjectVo.class)	
    @GetMapping("/account/group/export")
    public Response<ReportStudyTrainingProjectAccountVo> trainingProjectAccountGroupExport(

    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate, 
    		@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgKwd", required = false) String orgKwd,    
    		@ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd){
		
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="培训项目-按用户统计-下载结果数据-"+taskId;
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("startDate", startDate);
		map.put("endDate", endDate);
		map.put("orgKwd", orgKwd);
		map.put("accountKwd", accountKwd);
		map.put("accountId", ContextHolder.get().getAccountId());
		map.put("orgIds", ContextHolder.get().getOrgIds());
		map.put("siteId", ContextHolder.get().getSiteId());
		map.put("companyId", ContextHolder.get().getCompanyId());
		map.put("serialNo", serialNo);
		map.put("taskId", taskId);
		map.put("submitTime", submitTime);
		map.put("taskName", taskName);
		trainingProjectAccountGroupExport.execute(map, true);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}
	
	
	
	
	@ApiOperation(value = "按用户统计-查看", notes = "按用户统计-查看", response = ReportStudyTrainingProjectAccountViewVo.class)
    @GetMapping("/account/group/view")
    public Response<ReportStudyTrainingProjectAccountViewVo> trainingProjectAccountGroupView(
    		@ApiParam(value = "用户ID", required = true) @RequestParam(name = "accountId", required = true) Long accountId,
    		@ApiParam(value=  "项目关键字",required=false) @RequestParam(name = "projectName", required = false) String projectName,
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate, 
    		@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
    		@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo){
	
		Long companyId=ContextHolder.get().getCompanyId();
		Long siteId=ContextHolder.get().getSiteId();
		
		Page<ReportStudyTrainingProjectAccountViewVo> page=trainingProjectReportClient.trainingProjectAccountGroupView(accountId,projectName, pageSize, pageNo, startDate, endDate,companyId,siteId);
		if(page==null) {
			return Response.fail(ReturnCode.RESOURCE_NOT_FOUND.getCode(),ReturnCode.RESOURCE_NOT_FOUND.getMsg());
		}
		Map<String, Integer> pageMap = new HashMap<String, Integer>();
		pageMap.put("pageNo", pageNo);
		pageMap.put("pageSize", pageSize);
		pageMap.put("pageTotal", page.getTotal());
		return Response.ok(page.getRecords(), pageMap);
	}
	
	
	
	
	

	@ApiOperation(value = "按用户统计-查看-导出记录", notes = "按用户统计--查看-导出记录", response = ReportStudyTrainingProjectVo.class)	
    @GetMapping("/account/group/view/export")
    public Response<ReportStudyTrainingProjectAccountViewVo> trainingProjectAccountGroupViewExport(
    		@ApiParam(value = "用户ID", required = false) @RequestParam(name = "accountId", required = false) Long accountId,
    		@ApiParam(value=  "项目关键字",required=false) @RequestParam(name = "projectName", required = false) String projectName,
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate){
		
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="培训项目-按用户统计-查看-下载结果数据-"+taskId;
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("startDate", startDate);
		map.put("endDate", endDate);
		map.put("accountId", accountId);
		map.put("projectName", projectName);
		map.put("adminId", ContextHolder.get().getAccountId());
		map.put("orgIds", ContextHolder.get().getOrgIds());
		map.put("siteId", ContextHolder.get().getSiteId());
		map.put("companyId", ContextHolder.get().getCompanyId());
		map.put("serialNo", serialNo);
		map.put("taskId", taskId);
		map.put("submitTime", submitTime);
		map.put("taskName", taskName);
		trainingProjectAccountGroupViewExport.execute(map, true);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}
	
	
	
	
	@ApiOperation(value = "按部门统计", notes = "按部门统计", response = ReportStudyTrainingProjectOrgVo.class)
    @GetMapping("/org/group")
    public Response<ReportStudyTrainingProjectOrgVo> trainingProjectOrgGroup(
    		@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate, 
    		@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate, 
    		@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "kwd", required = false) String kwd,    
    		@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
    		@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo){
		
		Long siteId=ContextHolder.get().getSiteId();
		Long companyId=ContextHolder.get().getCompanyId();
		List<Long> orgIds=ContextHolder.get().getOrgIds();
		RequestContext requestContext=ContextHolder.get();
		if (!requestContext.isAdmin() && !CollectionUtils.isEmpty(requestContext.getOrgIds())) {
			orgIds = requestContext.getOrgIds();
		}
		Page<ReportStudyTrainingProjectOrgVo> page=trainingProjectReportClient.trainingProjectOrgGroup(startDate, endDate, kwd, companyId, orgIds, siteId, pageSize, pageNo);
		if(page==null) {
			return Response.fail(ReturnCode.RESOURCE_NOT_FOUND.getCode(),ReturnCode.RESOURCE_NOT_FOUND.getMsg());
		}
		Map<String, Integer> pageMap = new HashMap<String, Integer>();
		pageMap.put("pageNo", pageNo);
		pageMap.put("pageSize", pageSize);
		pageMap.put("pageTotal", page.getTotal());
		return Response.ok(page.getRecords(), pageMap);
	}
	
	
	
	@ApiOperation(value="按照名字模糊查询",notes="按照名字模糊查询")
	@GetMapping("/select/by/name")
	public Response<TrainingProjectVo> selectTrainingProjectByLikeName(
			@ApiParam(value = "关键字", required = true) @RequestParam(name = "kwd", required = true) String kwd,    
    		@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
    		@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo){
		Long siteId=ContextHolder.get().getSiteId();
		Long companyId=ContextHolder.get().getCompanyId();
		List<Long> orgIds=ContextHolder.get().getOrgIds();
		RequestContext requestContext=ContextHolder.get();
		if (!requestContext.isAdmin() && !CollectionUtils.isEmpty(requestContext.getOrgIds())) {
			orgIds = requestContext.getOrgIds();
		}
		Page<com.yizhi.training.application.vo.domain.TrainingProjectVo> page=trainingProjectReportClient.selectTrainingProjectByLikeName(kwd, pageNo, pageSize,siteId,orgIds,companyId);
		if(page==null) {
			return Response.fail(ReturnCode.RESOURCE_NOT_FOUND.getCode(),ReturnCode.RESOURCE_NOT_FOUND.getMsg());
		}
		else {
			Map<String, Integer> pageMap = new HashMap<String, Integer>();
			pageMap.put("pageNo", pageNo);
			pageMap.put("pageSize", pageSize);
			pageMap.put("pageTotal", page.getTotal());
			return Response.ok(page.getRecords(), pageMap);
		}
	} 
	
	@GetMapping("/asynchronous/load/date")
    public Response<String> AsynchronousExam(
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startTime", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endTime", required = false) String endTime) {
		trainingProjectReportClient.AsynchronousCourse(startTime, endTime);
        return Response.ok("ok");
    }
}
