package com.yizhi.application.course.controller;

import com.yizhi.course.application.feign.ClassifyGroupClient;
import com.yizhi.course.application.vo.ClassifyGroupStudentVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/classify/group/info")
@Api(tags = "学员端-课程分类组基本信息", description = "课程分类组基本操作")
public class ClassifyGroupInfoController {

    //@Autowired
    //private ClassifyGroupInfoClient classifyGroupInfoClient;

    @Autowired
    private ClassifyGroupClient classifyGroupClient;


    @GetMapping("/view")
    public Response<ClassifyGroupStudentVO> view(
                                    @ApiParam(name = "id", value = "根据分类组的id获取关联的分类详细信息（平铺课程分类信息）", required = true) @RequestParam(name = "id") Long id){
        //return Response.ok(classifyGroupInfoClient.view(id));
        return Response.ok(classifyGroupClient.view(id));
    }
}
