package com.yizhi.application.pc.controller;


import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.point.application.feign.PointDetailsFeignClients;
import com.yizhi.point.application.vo.PointDetailVO;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @description: 我的积分
 * @author: lly
 * @date: 2019-01-02 15:59
 **/
@Api(tags = "PC端-我的积分")
@RestController
@RequestMapping(value = "/pc/point")
public class MyPointController {
    @Autowired
    private PointDetailsFeignClients pointClient;

    @ApiOperation(value = "我的积分明细", notes = "我的积分明细")
    @GetMapping("/list")
    public Response<Object> getPointList(
            @ApiParam(value = "年份", required = false) @RequestParam(name = "year", required = false, defaultValue = "") String year,
            @ApiParam(value = "type", required = false) @RequestParam(name = "type", required = false, defaultValue = "") String type,
            @ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @ApiParam(value = "当前页数默认为1", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
        RequestContext requestContext = ContextHolder.get();

        Long accountId = requestContext.getAccountId();
        Long companyId = requestContext.getCompanyId();
        Long orgId = requestContext.getOrgId();
        Long siteId = requestContext.getSiteId();
        Map<String, Object> map = null;
        try {
            map = pointClient.pointList(year, type, accountId, pageNo, pageSize, companyId, siteId, orgId);
        } catch (Exception e) {
            return Response.fail(Constants.POINT_MSG_BIZ_ERROR);
        }

        Map<String, Object> listMap = (Map<String, Object>) map.get("listMap");
        Map<String, Integer> pageMap = (Map<String, Integer>) map.get("page");

        return Response.ok(listMap, pageMap);
    }

    @ApiOperation(value = "我的积分列表", notes = "我的积分列表")
    @GetMapping("/getPointDetail")
    public Response<PointDetailVO> getPointDetail() {
        RequestContext requestContext = ContextHolder.get();

        Long accountId = requestContext.getAccountId();
        Long siteId = requestContext.getSiteId();
        PointDetailVO pointDetailVO = null;
        try {
            pointDetailVO = pointClient.getPointDetail(accountId, siteId);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(Constants.POINT_MSG_BIZ_ERROR);
        }

        return Response.ok(pointDetailVO);
    }

}
