package com.yizhi.application.album;

import java.util.List;

import com.yizhi.album.application.feign.AlThemeClient;
import com.yizhi.album.application.vo.domain.AlTheme;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.json.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;

@Api(tags = "管理端-专辑主题", description = "专辑活动主题")
@RestController
@RequestMapping("/manage/album/theme")
public class AlThemeController {

	private Logger logger = LoggerFactory.getLogger(AlThemeController.class);
	
	@Autowired
	private AlThemeClient alThemeClient;
	
	@GetMapping("/delete")
	public Response<String> delete(@ApiParam(name = "id",value = "主题id")@RequestParam(name = "id")Long id) {
		try {
			return Response.ok(alThemeClient.delete(id));
		} catch (Exception e) {
			logger.error("", e);
			return Response.fail(InternationalEnums.DOCUMENTRELATIONCONTROLLER2.getName());
		}
	}
	
	@PostMapping("/sortActivity")
	public Response<String> sortTheme(@RequestBody String list) {
		List<AlTheme> list1 = JsonUtil.json2List(list, AlTheme.class);
		try {
			logger.info("web端传入要排序的ID列表----------:" + list);
			return Response.ok(alThemeClient.sortTheme(list1));
		} catch (Exception e) {
			logger.error("", e);
			return Response.fail(InternationalEnums.CLASSIFYCONTROLLER8.getName());
		}
	}
	
	@GetMapping("/updateName")
	public Response<String> updateName(@ApiParam(name = "id",value = "主题id")@RequestParam(name = "id") Long id,@ApiParam(name = "albumId",value = "专辑id")@RequestParam(name = "albumId") Long albumId,@ApiParam(name = "name",value = "新的主题名称")@RequestParam(name = "name") String name) {
		Boolean b = alThemeClient.updateName(id,albumId, name);
		if (!b) {
			return Response.fail(InternationalEnums.ALTHEMEACITICITYCONTROLLER3.getName());
		}
		return Response.ok();
	}
}
