/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: ExamSystemQuestionController
 * Author:   phone
 * Date:     2018/5/25 16:45
 * Description: 系统出题规则
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.application.exam.controller;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.exam.application.feign.ExamSystemQuestionClient;
import com.yizhi.exam.application.vo.ExamSystemQuestionVO;
import com.yizhi.exam.application.vo.QuestionPreview;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈系统出题规则〉
 *
 * @author phone
 * @create 2018/5/25
 * @since 1.0.0
 */
@Api(tags = "管理端-考试接口", description = "管理端-考试接口")
@RestController("webExamSystemQuestionController")
@RequestMapping("/manage/exam/system/question")
public class ExamSystemQuestionController {

    private static final Logger Log = LoggerFactory.getLogger(ExamSystemQuestionController.class);

    @Autowired
    ExamSystemQuestionClient examSystemQuestionClient;

    /**
     * 新增系统出题规则
     * */
    @ApiOperation("新增系统出题规则")
    @PostMapping("/insert/all")
    public Response<String> insert(@RequestBody ExamSystemQuestionVO examSystemQuestionVO){
        boolean result;
        try{
            RequestContext requestContext = ContextHolder.get();
            examSystemQuestionVO.setAccountId(requestContext.getAccountId());
            examSystemQuestionVO.setAccountName(requestContext.getAccountName());
            result = examSystemQuestionClient.insert(examSystemQuestionVO);
            if (result){
                return Response.ok(ReturnCode.SUCCESS);
            }else {
                return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
            }
        }catch (Exception e){
            Log.error("新增系统出题规则错误中台：",e);
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 查看考试系统出题规则
     * */
    @ApiOperation("查看系统出题规则")
    @GetMapping("/select")
    public Response<QuestionPreview> selectExamSystemQuestion(@ApiParam("考试ID")@RequestParam("examId") Long examId){
        List<QuestionPreview> questionPreviews = null;
        try{
            questionPreviews = examSystemQuestionClient.selectExamSystemQuestion(examId);
            if(null != questionPreviews && questionPreviews.size() > 0){
                return Response.ok(questionPreviews);
            }else{
            	questionPreviews = new ArrayList<QuestionPreview>();
                return Response.ok(questionPreviews);
            }
        }catch (Exception e){
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

}