package com.yizhi.application.international.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.tools.PageTools;
import com.yizhi.site.application.feign.InternationalClient;
import com.yizhi.site.application.vo.domain.SiteLanguageVo;
import com.yizhi.site.application.vo.site.InternationalFileUpVO;
import com.yizhi.site.application.vo.site.PortalTemplateVO;
import com.yizhi.site.application.vo.site.SiteLanguageVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 讲师库字典
 * @author: lly
 * @date: 2020-9-3 17:39:51
 **/
@Log4j2
@Api(tags = "国际化—功能模块")
@RestController
@RequestMapping("/manage/siteLanguage")
public class SiteLanguageController {


    @Autowired
    private InternationalClient internationalClient;



    @ApiOperation(value = "国际化导入", notes = "国际化导入")
    @PostMapping(value = "/import")
    public Response<String> importInternational(@RequestBody InternationalFileUpVO model) {
        try {
            String taskNo = internationalClient.importInternational(model);
            return Response.ok(taskNo);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("当前的接口返回异常：{}",e.getMessage());
            return Response.fail();
        }
    }




    @ApiOperation(value = "语言功能模块", notes = "语言功能模块")
    @GetMapping("/page")
    public Response getList(
            @RequestParam(name = "pageNo", required = true, defaultValue = "1") Integer pageNo,
            @RequestParam(name = "pageSize", required = true, defaultValue = "20") Integer pageSize,
            @RequestParam(name = "status",required = false) Integer status
    ) {
        try {
            Page<SiteLanguageVO> page = internationalClient.getList(pageNo, pageSize, status);
            return Response.ok(PageTools.versaPage(page));
        } catch (Exception e) {
            log.info("语言类列表异常：{}", e.getMessage());
            return Response.fail();
        }
    }

    @ApiOperation(value = "管理-语言列表", notes = "管理-语言列表")
    @GetMapping("/public/page")
    public Response getSiteLanguageList(
            @RequestParam(name = "pageNo", required = true, defaultValue = "1") Integer pageNo,
            @RequestParam(name = "pageSize", required = true, defaultValue = "20") Integer pageSize,
            @RequestParam(name = "status",required = false) Integer status
    ) {
        try {
            Page<SiteLanguageVO> page = internationalClient.getList(pageNo, pageSize, status);
            return Response.ok(PageTools.versaPage(page));
        } catch (Exception e) {
            log.info("语言类列表异常：{}", e.getMessage());
            return Response.fail();
        }
    }

    @PostMapping("/sort")
    public Response<String> sortLanguage(@RequestBody PortalTemplateVO sortVO) {
        try {
            return Response.ok(internationalClient.sortLanguage(sortVO));
        } catch (Exception e) {
            log.error("报错：{}", e.getMessage());
            return Response.fail();
        }
    }

    /**
     * 停用启用
     *
     * @param siteLanguage
     * @return
     */
    @PostMapping("/update")
    public Response<String> update(@RequestBody SiteLanguageVo siteLanguage) {
        try {
            return Response.ok(internationalClient.update(siteLanguage));
        } catch (Exception e) {
            log.error("报错：{}", e.getMessage());
            return Response.fail();
        }
    }
}