package com.yizhi.application.portal.controller;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.feign.PortalThemeColorClients;
import com.yizhi.site.application.vo.domain.PortalThemeColorVo;
import com.yizhi.site.application.vo.site.PortalThemeColorEntityVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 门户主题色配置 前端控制器
 * </p>
 *
 * @author fulan123
 * @since 2020-08-12
 */
@Api(tags = "管理端 换肤设置")
@RestController
@RequestMapping("/manage/portal/theme/color")
public class PortalThemeColorController {

    @Autowired
    private PortalThemeColorClients portalThemeColorClients;

    /**
     * 查找改站点终端类型设置的主题颜色
     * @param terminalType
     * @return
     */
    @GetMapping("/get")
    @ApiOperation(value = "根据指定的设备类型获取设置的主题配置信息", response = PortalThemeColorVo.class)
    public Response<PortalThemeColorVo> getThemeColorBySiteId(@ApiParam(name = "terminalType", value = "终端类型：1 后台管理端  ；2 PC端 ； 3 移动端; 不设置就是0: 通用")
                                                            @RequestParam(value = "terminalType",required = false, defaultValue = "0") Integer terminalType){
        RequestContext rt = ContextHolder.get();
        return Response.ok(portalThemeColorClients.getThemeColorBySiteId(rt.getCompanyId(),rt.getSiteId(),terminalType));
    }

    /**
     * 根据主键重置配置的颜色信息
     * @param id
     * @return
     */
    @GetMapping("/reset")
    @ApiOperation(value = "根据配置id重置主题信息", response = Boolean.class)
    public Response<Boolean> reset(@ApiParam(name = "id", value = "主题颜色配置的id", required = true) @RequestParam(value = "id") Long id){
        RequestContext rt = ContextHolder.get();
        return Response.ok(portalThemeColorClients.reset(id, rt.getAccountId()));
    }

    /**
     * 保存主题颜色配置
     * @return
     */
    @GetMapping("/save")
    @ApiOperation(value = "保存主题信息", response = PortalThemeColorEntityVo.class)
    public Response<PortalThemeColorEntityVo> save(@ApiParam(name = "terminalType", value = "终端类型：1 后台管理端  ；2 PC端 ； 3 移动端; 不设置就是0: 通用")
                                 @RequestParam(value = "terminalType", required = false, defaultValue = "0") Integer terminalType,
                                 @ApiParam(name = "themeColor", value = "主题色", required = true)
                                 @RequestParam(value = "themeColor") String themeColor,
                                 @ApiParam(name = "auxiliarColor", value = "辅助色", required = true)
                                 @RequestParam(value = "auxiliarColor") String auxiliarColor){
        RequestContext rt = ContextHolder.get();
        PortalThemeColorEntityVo portalThemeColor = new PortalThemeColorEntityVo();
        portalThemeColor.setCompanyId(rt.getCompanyId());
        portalThemeColor.setSiteId(rt.getSiteId());
        portalThemeColor.setCreateById(rt.getAccountId());
        portalThemeColor.setTerminalType(terminalType);
        portalThemeColor.setThemeColor(themeColor);
        portalThemeColor.setAuxiliarColor(auxiliarColor);
        return Response.ok(portalThemeColorClients.save(portalThemeColor));
    }
}
