package com.yizhi.application.globalsearch;

import com.yizhi.assignment.application.feign.AssignmentClient;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.exam.application.feign.MyExamClient;
import com.yizhi.research.application.feign.ResearchAnswerClient;
import com.yizhi.research.application.vo.api.ViewAnswerVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author: shengchenglong
 * @Date: 2019/1/24 15:08
 */
@Api(tags = "全局搜索相关")
@RestController
@RequestMapping("/api/globalsearch/")
public class GlobalSearchController {

    @Autowired
    private AssignmentClient assignmentClient;

    @Autowired
    private MyExamClient examClient;

    @Autowired
    private ResearchAnswerClient researchAnswerClient;

    @PostMapping("/commited/list")
    public Response<List<Long>> commitedList(@RequestBody IdsVo vo) {
        RequestContext context = ContextHolder.get();

        if (CollectionUtils.isNotEmpty(vo.getIds())) {
            if (vo.getType().equals(1)) {
                return Response.ok(examClient.getMyFinishedIds(context.getAccountId(), context.getSiteId(), vo.getIds()));
            }
            if (vo.getType().equals(2)) {
                return Response.ok(assignmentClient.getListIdsBySiteIdAndAssignmentIdsAndAccountId(context.getSiteId(), context.getAccountId(), vo.getIds()));
            }
        }
        return Response.fail();
    }

    @ApiOperation("调研提交过返回 true，未提交过返回 false")
    @GetMapping("/research/commited/")
    public Response<Boolean> commitedList(
            @ApiParam("调研 id") @RequestParam("researchId") Long researchId) {
        RequestContext context = ContextHolder.get();
        ViewAnswerVo vo = researchAnswerClient.viewResearch(researchId, context.getAccountId());
        if (null == vo) {
            return Response.ok(false);
        }
        return Response.ok(true);
    }

}
