//package com.yizhi.application.message.controller;
//
//import com.yizhi.api.domain.Exam;
//import com.yizhi.api.feign.ExamClient;
//import com.yizhi.application.context.ContextHolder;
//import com.yizhi.application.domain.Research;
//import com.yizhi.application.exception.BizException;
//import com.yizhi.application.feign.*;
//import com.yizhi.application.message.domain.enums.MessageType;
//
//import com.yizhi.application.message.vo.MessagePageVO;
//import com.yizhi.application.message.vo.MessageRealVO;
//import com.yizhi.application.message.vo.MessageVO;
//import com.yizhi.application.util.constant.ReturnCode;
//import com.yizhi.application.util.domain.Response;
//import com.yizhi.application.util.page.PageInfo;
//import com.yizhi.application.vo.AssignmentSelectVo;
//import com.yizhi.application.vo.TrainningEnrollVO;
//import com.yizhi.application.vo.VoteVO;
//import io.swagger.annotations.*;
//import org.apache.commons.collections.CollectionUtils;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.web.bind.annotation.*;
//
//import java.util.ArrayList;
//import java.util.List;
//
///**
// * 消息中台控制器
// * @author yinyuyan
// * @create 2018/4/3
// * @since 1.0.0
// */
//
//@Api(tags = "学员端消息接口", description = "学员端消息接口")
//@RestController
//@RequestMapping("/api/message")
//public class MessageController {
//
//    private static final Logger LOG = LoggerFactory.getLogger(MessageController.class);
////
////    @Autowired
////    MessageClient messageClient;
////    @Autowired
////    ExamClient examClient;
////    @Autowired
////    private ResearchClient researchClient;
////    @Autowired
////    TpProjectClient tpProjectClient;
////    @Autowired
////	private EnrollFeignClient enrollFeignClient;
////    @Autowired
////	AssignmentClient assignmentClient;
////    @Autowired
////	VoteClient voteClient;
////
////    @ApiOperation(value = "我的消息(未读消息)",notes ="我的消息(未读消息)" )
////    @GetMapping(value = "/unread/count")
////    public Response<Integer> unreadCount() throws Exception {
////        int sum = messageClient.unreadCount(ContextHolder.get().getAccountId());
////        return Response.ok(sum);
////    }
////
////    @ApiOperation(value = "我的消息(站内消息)",notes ="我的消息(站内消息)" )
////    @PostMapping("/list")
////    public Response<PageInfo<MessageVO>> list(@RequestBody MessagePageVO pageVO){
////        try {
////        	pageVO.setAccountId(ContextHolder.get().getAccountId());
////        	PageInfo<MessageRealVO> page=messageClient.listByPage(pageVO);
////        	List<MessageRealVO> messages=page.getRecords();
////        	if(CollectionUtils.isNotEmpty(messages)){
////        		for(MessageRealVO vo:messages){
////        			StringBuilder taskName=new StringBuilder("");
////        			try {
////        				String type=vo.getMessageType().toString();
////            			if(MessageType.KS.getKey().equals(type)){
////            				taskName.append("考试名称：");
////            				Exam exam=examClient.examViewInfo(vo.getTaskId());
////            				if(null!=exam){
////            					taskName.append(exam.getName());
////            				}
////            			}else if(MessageType.XX.getKey().equals(type)){
////            				taskName.append("学习计划名称：");
////            			}else if(MessageType.DY.getKey().equals(type)){
////            				taskName.append("调研名称：");
////            				Research research=researchClient.viewOne(vo.getTaskId());
////            				if(null!=research){
////            					taskName.append(research.getName());
////            				}
////            			}else if(MessageType.TP.getKey().equals(type)){
////            				taskName.append("投票名称：");
////            				VoteVO vote=voteClient.viewVote(vo.getTaskId().toString());
////            				if(null!=vote){
////            					taskName.append(vote.getVoteName());
////            				}
////            			}else if(MessageType.BM.getKey().equals(type)){
////            				taskName.append("报名名称：");
////            				List<Long> ids=new ArrayList<Long>(){{add(vo.getId());}};
////            				List<TrainningEnrollVO> enrolls=enrollFeignClient.selectTrainningEnroll(ids);
////            				if(CollectionUtils.isNotEmpty(enrolls)){
////            				//	taskName.append(enrolls.get(0).g)  //TODO 增加名称
////            				}
////            			}else if(MessageType.ZY.getKey().equals(type)){
////            				taskName.append("作业名称：");
////            				AssignmentSelectVo assignment = assignmentClient.query(vo.getId());
////            				if(null!=assignment){
////            					taskName.append(assignment.getName());
////            				}
////            			}else if(MessageType.QD.getKey().equals(type)){
////            				taskName.append("签到名称：");
////            			}else if(MessageType.XM.getKey().equals(type)){
////            				taskName.append("项目名称：");
////            			}else{
////            			}
////					} catch (Exception e) {
////						LOG.error("",e);
////					} finally{
////						vo.setTaskName(taskName.toString());
////						continue;
////					}
////        		}
////        	}
////        	page.setRecords(messages);
////            return Response.ok(page);
////        }catch(BizException be){
////            return Response.fail(be.getCode(),be.getCode());
////        }catch(Exception e){
////            LOG.error("",e);
////            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
////        }
////    }
////
////
////    @ApiOperation(value = "删除消息(站内消息)",notes ="删除消息(站内消息)" )
////    @ApiImplicitParams({
////            @ApiImplicitParam(name = "id",value = "消息id",required=true)
////    })
////    @PostMapping("/delete")
////    public Response<String> delete(@RequestBody MessageRealVO messageVO){
////        try {
////        	messageClient.delete(messageVO);
////        }catch(BizException be){
////            return Response.fail(be.getCode(),be.getCode());
////        }catch(Exception e){
////            LOG.error("",e);
////            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
////        }
////        return Response.ok();
////    }
////
////    @ApiOperation(value = "批量删除消息(站内消息)",notes ="批量删除消息(站内消息)" )
////    @PostMapping("/delete/batch")
////    public Response<String> deleteBatch(@RequestBody List<MessageRealVO> messageVOs){
////        try {
////        	messageClient.deleteBatch(messageVOs);
////        }catch(BizException be){
////            return Response.fail(be.getCode(),be.getCode());
////        }catch(Exception e){
////            LOG.error("",e);
////            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
////        }
////        return Response.ok();
////    }
////
////    @ApiOperation(value = "读消息(站内消息)",notes ="读消息(站内消息)" )
////    @ApiImplicitParams({
////            @ApiImplicitParam(name = "id",value = "消息id",required=true)
////    })
////    @PostMapping("/read")
////    public Response<String> read(@RequestBody MessageRealVO messageVO){
////        try {
////        	messageClient.read(messageVO);
////        }catch(BizException be){
////            return Response.fail(be.getCode(),be.getCode());
////        }catch(Exception e){
////            LOG.error("",e);
////            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
////        }
////        return Response.ok();
////    }
////
////    @ApiOperation(value = "获取消息内容",notes ="获取消息内容" )
////    @GetMapping("/get")
////    public Response<MessageVO> get(@ApiParam(name = "id", value = "消息id", required = true) @RequestParam Long id){
////        try {
////            return Response.ok(messageClient.get(id));
////        }catch(BizException be){
////            return Response.fail(be.getCode(),be.getCode());
////        }catch(Exception e){
////            LOG.error("",e);
////            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
////        }
////    }
//}