package com.yizhi.application.authorize;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.course.application.feign.AccreditClient;
import com.yizhi.course.application.feign.CourseClient;
import com.yizhi.course.application.vo.*;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * <p>
 * 投票 前端控制器
 * </p>
 *
 * @author lilingye
 * @since 2018-6-11 14:55:02
 */
@Api(tags = "授权/销售课程列表")
@RestController
@RequestMapping("/manage/authorize")
public class AuthorizeController {
	private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizeController.class);
	@Autowired
    private CourseClient courseClient;

	@Autowired
    private AccreditClient accreditClient;

    /**
     *  查询课程授权和课程销售的接口
     * @param name
     * @param classifyId
     * @param companyId
     * @param pageNo
     * @param pageSize 
     * @return
     */
    @ApiOperation(value = "查询课程授权/课程销售的接口")
    @GetMapping(value = "/get/list")
    public Response<PageCourseAuthorizeVO> queryeAuthorizeCoursesList(
            @ApiParam(name = "name", value = "名称", required = false) @RequestParam(name = "name",required = false) String name,
            @ApiParam(name = "companyId", value = "公司id") @RequestParam(name = "companyId",required = false) Long companyId,
            @ApiParam(name = "csiteId", value = "站点名称（课程授权必传字段）", required = false) @RequestParam(name = "csiteId",required = false) Long csiteId,
            @ApiParam(name = "classifyId", value = "分类id")@RequestParam(name = "classifyId",required = false) Long classifyId,
            @ApiParam(name = "pageNo", value = "当前页", required = false) @RequestParam(name = "pageNo", defaultValue = "1", required = false) Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页的条数", required = false) @RequestParam(name = "pageSize", defaultValue = "20", required = false) Integer pageSize

    ) {
        PageCourseAuthorizeVO pageCourseAuthorizeVO = courseClient.queryeAuthorizeCoursesList(name,companyId,csiteId,classifyId,pageNo,pageSize);

        return Response.ok(pageCourseAuthorizeVO);
    }

    /**
     * 提交保存授权课程的接口
     * @return
     */
    @ApiOperation(value = "保存授权")
    @PostMapping(value = "/insert")
    public Response<String> saveAuthorization(@RequestBody AuthorizeVO authorizeVO){

        CourseRespVO courseRespVO = courseClient.saveAuthorization(authorizeVO);
        if (courseRespVO!=null){
            if (courseRespVO.getCode()==1){
                return Response.ok();
            } else {
                return Response.fail(courseRespVO.getMsg());
            }
        }else {
            return Response.ok();
        }

    }


    /**
     * 模糊查询授权后列表(销售授权和课程授权)
     * @return
     */
    @ApiOperation(value = "模糊查询授权后列表")
    @GetMapping(value = "/get/authorizelist")
    public Response<PageAuthorizeVO> queryAuthorizeCourse(@ApiParam(name = "type", value = "1课程授权 2 课程销售",required = true)@RequestParam(name = "type",required = true) String type,
                                                          @ApiParam(name = "siteName", value = "站点名称（课程授权字段）") @RequestParam(name = "siteName",required = false) String siteName,
                                                          @ApiParam(name = "companyName", value = "公司名称(销售授权字段)") @RequestParam(name = "companyName",required = false) String companyName,
                                                          @ApiParam(name = "pageNo", value = "当前页") @RequestParam(name = "pageNo", defaultValue = "1",required = false) Integer pageNo,
                                                          @ApiParam(name = "pageSize", value = "当前页条数") @RequestParam(name = "pageSize", defaultValue = "20",required = false) Integer pageSize){
//        PageAuthorizeVO pageAuthorizeVO=  accreditClient.queryAuthorizeCourse(type,siteName,companyName,pageNo,pageSize);
        Page<AuthorizeCourseVO> page = accreditClient.queryAuthorizedCourseList(type, siteName, companyName, pageNo, pageSize);
        PageAuthorizeVO pageAuthorizeVO = new PageAuthorizeVO();
        pageAuthorizeVO.setRecords(page.getRecords());
        pageAuthorizeVO.setPageNo(page.getCurrent());
        pageAuthorizeVO.setPageSize(page.getSize());
        pageAuthorizeVO.setPageRecords(page.getTotal());
        pageAuthorizeVO.setPageTotal(page.getPages());
        return Response.ok(pageAuthorizeVO);
    }

    /**
     * 条件查询站点授权后的课程
     * @return
     */
    @ApiOperation(value = "站点查询站点授权后的课程")
    @GetMapping(value = "/get/authorized")
    public Response<PageAuthorizedVO> queryAuthorizedCourse(@ApiParam(name = "courseKeys", value = "站点名称") @RequestParam(name = "courseKeys",required = false) String courseKeys,
                                                            @ApiParam(name = "startTime", value = "开始时间") @RequestParam(name = "startTime",required = false) String startTime,
                                                            @ApiParam(name = "siteId",value = "站点id",required = true)  @RequestParam(name = "siteId",required = true) Long siteId,
                                                            @ApiParam(name = "endTime", value = "结束时间") @RequestParam(name = "endTime",required = false) String endTime,
                                                            @ApiParam(name = "type",value = "1 课程授权  2课程销售") @RequestParam(name = "type") Integer type,
                                                            @ApiParam(name = "activeType",value = "活跃状态,0：活跃，1：已经到期") @RequestParam(name = "activeType",required = false) Integer activeType,
                                                            @ApiParam(name = "pageNo", value = "当前页") @RequestParam(name = "pageNo", defaultValue = "1",required = false) Integer pageNo,
                                                            @ApiParam(name = "pageSize", value = "当前页条数") @RequestParam(name = "pageSize", defaultValue = "20",required = false) Integer pageSize){

        if ("".equals(activeType)) {
            activeType = null;
        }
        PageAuthorizedVO pageAuthorizedVO = courseClient.getAuthorizedList(courseKeys,startTime,endTime,siteId,activeType,type,pageNo,pageSize);
        return Response.ok(pageAuthorizedVO);
    }

    @ApiOperation(value = "修改课程的有效期")
    @PostMapping(value = "/updateValidDate")
    public Response<String> updateAuthorize(@RequestBody AuthorizeParamVO authorizeParamVO){
        if(authorizeParamVO!=null){

            for (AuthCourseVO  authorizationCourseVO:authorizeParamVO.getAuthorizationCourseVOs()){
                AccreditVO accreditVO = new AccreditVO();
                accreditVO.setId(authorizationCourseVO.getCourseId());
                accreditVO.setUseDuration(authorizationCourseVO.getValidDate());
                accreditClient.updateAuthorize(accreditVO);
            }
            return Response.ok();
        } else {
            return Response.fail(InternationalEnums.SITEINFORMATIONMANAGECONTROLLER1.getName());
        }
    }

}

