package com.yizhi.application.comment;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.comment.application.feign.ManageCommentClient;
import com.yizhi.comment.application.feign.ReplyClient;
import com.yizhi.comment.application.vo.CommentDelVO;
import com.yizhi.comment.application.vo.CommentVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

/**
 * 评论 前端控制器
 * 
 * @author Fairyland
 *
 */

@Api(tags = "管理端-评论", description = "评论接口")
@RestController
@RequestMapping("/comment/manage")
public class NewCommentController {

	@Autowired
	private ManageCommentClient commentClient;
	@Autowired
	private ReplyClient replyClient;
	@ApiOperation(value = "根据业务id获取评论列表(分页查询)", response = CommentVo.class)
	@GetMapping("/list")
	public Response getCommentList(
			@ApiParam(name = "bizId", value = "业务id") @RequestParam(name = "bizId") Long bizId,@ApiParam(name = "bizType", value = "业务类型 0课程 7培训项目 12精选案例 15专辑") @RequestParam("bizType") Integer bizType,
			@ApiParam(name = "pageNo", value = "跳转页数,默认第一页") @RequestParam(name = "pageNo", defaultValue = "1", required = false) Integer pageNo,
			@ApiParam(name = "pageSize", value = "每页条数,默认10条") @RequestParam(name = "pageSize", defaultValue = "10", required = false) Integer pageSize) {
		Page<CommentVo> page = commentClient.list(bizId,bizType, pageNo, pageSize);
		return Response.ok(page);
	}
	
	@ApiOperation(value = "根据业务id获取评论列表(分页查询)", response = CommentVo.class)
	@GetMapping("/reply/list")
	public Response getReplyList(
			@ApiParam(name = "bizId", value = "业务id") @RequestParam(name = "bizId") Long bizId,
			@ApiParam(name = "pageNo", value = "跳转页数,默认第一页") @RequestParam(name = "pageNo", defaultValue = "1", required = false) Integer pageNo,
			@ApiParam(name = "pageSize", value = "每页条数,默认10条") @RequestParam(name = "pageSize", defaultValue = "10", required = false) Integer pageSize) {
		Page<CommentVo> page = replyClient.list(bizId, pageNo, pageSize);
		return Response.ok(page);
	}
	
	@ApiOperation(value = "删除评论和回复")
	@PostMapping("/deleteComment")
	public Response<String> delateComment(@ApiParam(name = "CommentDelVO", value = "评论回复删除参数") @RequestBody CommentDelVO vo) {
		String result = commentClient.delateComment(vo);
		if (!StringUtils.isEmpty(result)) {
			if ("success".equals(result)) {
				return Response.ok();
			} else {
				return Response.fail();
			}
		}
		return Response.fail();
	}
	
	@ApiOperation(value = "上架")
	@GetMapping("/up")
	public Response<String> up(@ApiParam(name = "id", value = "评论或回复id")@RequestParam("id") Long id, @ApiParam(name = "type", value = "0评论 1回复")@RequestParam("type") Integer type) {
		Boolean up = commentClient.up(id, type);
		if (up) {
			return Response.ok();
		} else {
			return Response.fail();
		}
	}

	@ApiOperation(value = "下架")
	@GetMapping("/down")
	public Response<String> down(@ApiParam(name = "id", value = "评论或回复id")@RequestParam("id") Long id, @ApiParam(name = "type", value = "0评论 1回复")@RequestParam("type") Integer type) {
		Boolean up = commentClient.down(id, type);
		if (up) {
			return Response.ok();
		} else {
			return Response.fail();
		}
	}
	
	@ApiOperation(value = "评论信息导出")
	@GetMapping("/list/export")
	public Response<String> export(
			@ApiParam(name = "bizId", value = "业务id") @RequestParam(name = "bizId") Long bizId,
			@ApiParam(name = "bizType", value = "业务类型 0课程 7培训项目 12精选案例 15专辑") @RequestParam("bizType") Integer bizType,
			@ApiParam(name = "bizName", value = "业务名称") @RequestParam(name = "bizName") String bizName) {
		return Response.ok(commentClient.export(bizId,bizType, bizName).get("result").toString());
	}
}
