/**
 * FileName: DocPagesAsynchronizationDeal
 * Author:   wenjunlong
 * Date:     2018/5/30 14:41
 * Description: 文档异步解析处理
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.application.course.util;



import com.yizhi.application.course.constant.UtilConstants;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.course.application.feign.MaterialClient;
import com.yizhi.course.application.vo.DocPagesVO;
import com.yizhi.course.application.vo.domain.MaterialEntityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br>
 * 〈文档异步解析处理〉
 *
 * @author wenjunlong
 * @create 2018/5/30
 * @since 1.0.0
 */
@Component
public class DocPagesAsynchronizationDeal extends AbstractDefaultTask<String, Map<String, Object>> {

    @Value("${ACTIVE}")
    public String active;

    @Autowired
    ScormXMLImporter scormXMLImporter;

    @Autowired
    WebUpConvert webUpConvert;

    @Autowired
    private MaterialClient materialClient;

    @Override
    protected String execute(Map<String, Object> stringObjectMap) {

        TaskContext taskContext = null;
        MaterialEntityVo materialVo = null;
        try {
            materialVo = (MaterialEntityVo) stringObjectMap.get("material");
            // 任务id   任务名字   操作人id  操作时间
            taskContext = new TaskContext(System.currentTimeMillis(), materialVo.getName(), materialVo.getCreateById(), new Date(),
                    materialVo.getSiteId(), materialVo.getCompanyId());
            working(taskContext);
            String imageDir = webUpConvert.convert(materialVo.getOriginalFileUrl(), materialVo.getOriginalFile(), UtilConstants.DOC_PATH, 200, 0, UtilConstants.OPENOFFICE_PATH);
            File dir = new File(imageDir);
            File[] files = dir.listFiles();

            String uploadFile;
            String key;
            List<DocPagesVO> docPages = new ArrayList<DocPagesVO>();

            if (files.length > 0) {
                for (File file : files) {
                    uploadFile = file.getAbsolutePath();
                    key = materialVo.getOriginalFile().substring(0, materialVo.getOriginalFile().lastIndexOf(".")) + "/" + System.currentTimeMillis()+"/"+file.getName();
                    /*if (materialVo.getDisplayMark()==1) {
                    	String markImg = MarkImageUtils.markImageBySingleText(uploadFile, UtilConstants.DOC_PATH,file.getName().substring(0, file.getName().lastIndexOf(".")), "png", new Color(0, 0, 0,20), materialVo.getWord(), -45);
                    	if (!markImg.equals("添加文字水印失败")) {
                    		uploadFile = markImg;
						}  	
                        taskDetail(taskContext.getTaskId(),markImg);
                    }*/
                    String result = OssUpload.upload(uploadFile, key,active);
                    DocPagesVO docPages1 = new DocPagesVO();
                    docPages1.setDocPage(Integer.parseInt(file.getName().substring(0, file.getName().lastIndexOf("."))));  
                    docPages1.setImageUrl(result);
                    docPages.add(docPages1);
                }
            }
            stringObjectMap.put("docPages", docPages);

            if (stringObjectMap.containsKey("action")) {
                if ("create".equals(stringObjectMap.get("action").toString())) {
                    materialClient.insert(stringObjectMap);
                } else {
                    materialClient.update(stringObjectMap);
                }
            }

            success(taskContext, materialVo.getName() + "解析成功！", null);
        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, materialVo.getOriginalFileUrl() + "解析失败："+e.getMessage());
        }
        return null;
    }
}
