/**
 * FileName: ScormAsynchronizationDeal
 * Author:   wenjunlong
 * Date:     2018/5/30 16:50
 * Description: scorm解析异步处理
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.application.course.util;

import com.alibaba.fastjson.JSON;

import com.yizhi.application.course.constant.UtilConstants;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.course.application.feign.MaterialClient;
import com.yizhi.course.application.feign.TestCaseClient;
import com.yizhi.course.application.vo.ScormVO;
import com.yizhi.course.application.vo.domain.MaterialEntityVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Map;
import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * 〈scorm解析异步处理〉
 *
 * @author wenjunlong
 * @create 2018/5/30
 * @since 1.0.0
 */
@Component
public class ScormAsynchronizationDeal extends AbstractDefaultTask<String, Map<String, Object>> {

    @Autowired
    ScormXMLImporter scormXMLImporter;

    @Autowired
    private MaterialClient materialClient;

    @Autowired
    private TestCaseClient testCaseClient;

    private static final Logger LOG = LoggerFactory.getLogger(ScormAsynchronizationDeal.class);

    @Override
    protected String execute(Map<String, Object> stringObjectMap) {

        TaskContext taskContext = null;
        MaterialEntityVo materialVo = null;
        try {
            materialVo = (MaterialEntityVo) stringObjectMap.get("material");
            // 任务id   任务名字   操作人id  操作时间
            taskContext = new TaskContext(System.currentTimeMillis(), materialVo.getName(), materialVo.getCreateById(), new Date(),
                    materialVo.getSiteId(), materialVo.getCompanyId());
            working(taskContext);
            Long materialId = materialVo.getId();
            if(Objects.isNull(materialId)){
                materialId = testCaseClient.idGeneratorId();
            }
            ScormVO scorm = scormXMLImporter.scormParse(materialVo.getOriginalFileUrl(), UtilConstants.SCORM_SAVE_PATH,
                    materialVo.getOriginalFile(),materialId);
            stringObjectMap.put("scorm", scorm);
            LOG.info("scorm操作action={}",stringObjectMap.get("action"));
            if (stringObjectMap.containsKey("action")) {
                if ("create".equals(stringObjectMap.get("action").toString())) {
                    materialVo.setId(materialId);
                    stringObjectMap.put("material",materialVo);
                    materialClient.insertObj(stringObjectMap);
                    LOG.info("新建scorm课程成功={}", JSON.toJSONString(stringObjectMap));
                } else {
                    materialClient.update(stringObjectMap);
                    LOG.info("更新scorm课程成功={}", JSON.toJSONString(stringObjectMap));
                }
            }
            success(taskContext, materialVo.getName() + "解析成功！",null);
        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, materialVo.getName() + "解析失败！");
        }
        return null;
    }
}
