package com.yizhi.application.exam.controller;


import cn.hutool.json.JSONUtil;
import com.yizhi.application.exam.vo.ImportVO;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;



import java.util.HashMap;
import java.util.Map;

@Log4j2
@Api(tags = "管理端-导入接口", description = "管理端-导入接口")
@RestController
@RequestMapping("/manage/exam")
public class ExamImportController {
	
	@Autowired
	private QuestionSubjectImport qs;

	@Autowired
	private LibrarySubjectImport ls;

	@ApiOperation("题库试题导入")
	@PostMapping("/question/subject/import")
	public Response<String> importQuestionSubject(@RequestBody ImportVO importVO) {
		RequestContext requestContext = ContextHolder.get();
		Long accountId = requestContext.getAccountId();
		String accountName = requestContext.getAccountName();
		Long companyId = requestContext.getCompanyId();
		Long siteId = requestContext.getSiteId();
		Long orgId = requestContext.getOrgId();
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("accountId",accountId);
		map.put("accountName",accountName);
		map.put("companyId",companyId);
		map.put("siteId",siteId);
		map.put("orgId",orgId);
		map.put("libraryId",importVO.getId());
		map.put("url",importVO.getUrl());
		log.info("题目导入入参:{}", JSONUtil.toJsonStr(map));
		ls.execute(map);
		return Response.ok();
	}

	@ApiOperation("考试试题导入")
	@PostMapping("/question/exam/question/import")
	public Response<String> importExamQuestionSubject(@RequestBody ImportVO importVO) {
		RequestContext requestContext = ContextHolder.get();
		Long accountId = requestContext.getAccountId();
		String accountName = requestContext.getAccountName();
		Long companyId = requestContext.getCompanyId();
		Long siteId = requestContext.getSiteId();
		Long orgId = requestContext.getOrgId();
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("accountId",accountId);
		map.put("accountName",accountName);
		map.put("companyId",companyId);
		map.put("siteId",siteId);
		map.put("orgId",orgId);
		map.put("url",importVO.getUrl());
		map.put("examId",importVO.getId());
		qs.execute(map, true);
		return Response.ok();
	}

}
