package com.yizhi.application.language;

import com.yizhi.system.application.system.remote.LanguageClient;
import com.yizhi.system.application.vo.LanguageParam;
import com.yizhi.system.application.vo.LanguageVo;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.plugins.Page;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping("/manage/language")
public class LanguageController {

	private static final Logger logger = LoggerFactory.getLogger(LanguageController.class);

	@Autowired
	private LanguageClient languageClient;

	@ApiOperation(value = "导入翻译", notes = "导入翻译")
	@PostMapping("/upload")
	public Response<String> upload(@RequestBody LanguageParam param) {
		logger.info(param.toString());
		String result = languageClient.upload(param);
		return Response.ok(result);
	}

	@ApiOperation(value = "修改字段翻译", notes = "修改字段翻译")
	@PostMapping("/update")
	public Response<String> update(@RequestBody LanguageVo vo) {
		logger.info(vo.toString());
		int i = languageClient.update(vo);
		if (i == 1) {
			return Response.ok();
		} else {
			return Response.fail();
		}
	}

	@GetMapping("/list")
	public Response<String> list(
			@ApiParam(name = "kwd", required = false) @RequestParam(name = "kwd", required = false) String kwd,
			@ApiParam(name = "type", required = true) @RequestParam(name = "type", required = true) Integer type,
			@ApiParam(name = "state", required = true) @RequestParam(name = "state", required = true) Integer state,
			@ApiParam(name = "classifyId", required = true) @RequestParam(name = "classifyId", required = true) Long classifyId,
			@ApiParam(name = "pageNo", required = false, defaultValue = "1") @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
			@ApiParam(name = "pageSize",required = false,defaultValue = "10")@RequestParam(name = "pageSize",required = false,defaultValue = "10") Integer pageSize) {
		LanguageParam param = new LanguageParam();
		param.setKwd(kwd);
		param.setClassifyId(classifyId);
		param.setState(state);
		param.setType(type);
		param.setPageNo(pageNo);
		param.setPageSize(pageSize);
		logger.info(param.toString());
		Page<LanguageVo> page = languageClient.list(param);
		return Response.ok(page);
	}
	
	@ApiOperation(value = "导出翻译生成excel文件",notes = "导出翻译生成excel文件")
	public Response<String> export(
			@ApiParam(name = "kwd", required = false) @RequestParam(name = "kwd", required = false) String kwd,
			@ApiParam(name = "type", required = true) @RequestParam(name = "type", required = true) Integer type,
			@ApiParam(name = "state", required = true) @RequestParam(name = "state", required = true) Integer state,
			@ApiParam(name = "classifyId", required = true) @RequestParam(name = "classifyId", required = true) Long classifyId){
		LanguageParam param = new LanguageParam();
		param.setKwd(kwd);
		param.setClassifyId(classifyId);
		param.setState(state);
		param.setType(type);
		logger.info(param.toString());
		String result = languageClient.export(param);
		return Response.ok(result);
	}
}
