package com.yizhi.application.marketing.controller;

import com.alibaba.fastjson.JSON;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.MarketingClassifyClient;
import com.yizhi.course.application.feign.MarketingCourseClient;
import com.yizhi.course.application.vo.ClassifyVo;
import com.yizhi.course.application.vo.MarketingClassifyVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 19:51 2018/4/9
 * @Modified By
 */
@Api(tags = "营销分类接口")
@RestController
@RequestMapping("/manage/marketing/classify")
public class MarketingClassifyController {

    private static final Logger LOGGER = LoggerFactory.getLogger(MarketingClassifyController.class);

    @Autowired
    private MarketingClassifyClient marketingClassifyClient;

    @Autowired
    private MarketingCourseClient marketingCourseClient;

    @ApiOperation(value = "新增分类", response = MarketingClassifyVo.class)
    @RequestMapping(value = "/save",method = RequestMethod.POST)
    public Response<MarketingClassifyVo> saveClassify(@ApiParam(name = "marketingClassifyVo", value = "营销分类vo")
                                                @RequestBody MarketingClassifyVo marketingClassifyVo){
        RequestContext rc = ContextHolder.get();
        //LOGGER.info("新增分类请求的上下文="+JSON.toJSONString(ContextHolder.get()));
        LOGGER.info("marketingClassifyVo="+JSON.toJSONString(marketingClassifyVo));
        if(StringUtils.isEmpty(marketingClassifyVo.getName())){
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(), InternationalEnums.MARKETINGCLASSIFYCONTROLLER1.getCode());
        }
        try {
            ClassifyVo classifyVo = marketingClassifyClient.getByName(marketingClassifyVo.getName(),rc.getSiteId(),null);
            if(classifyVo != null && !StringUtils.isEmpty(classifyVo.getName())){
                return Response.fail(ReturnCode.BIZ_FAIL.getCode(), InternationalEnums.MARKETINGCLASSIFYCONTROLLER5.getCode());
            }
            return Response.ok(marketingClassifyClient.saveClassify(marketingClassifyVo));
        } catch (Exception e) {
            LOGGER.info(JSON.toJSONString(e));
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "删除分类")
    @RequestMapping(value = "/delete",method = RequestMethod.GET)
    public Response<Boolean> deleteClassify(@ApiParam(name = "id", value = "营销分类Id", required = true)
                                                @RequestParam Long id){
        LOGGER.info("删除分类请求的上下文="+JSON.toJSONString(ContextHolder.get()));
        LOGGER.info("id="+id);
        if(id == null || id == 0L ){
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(), InternationalEnums.MARKETINGCLASSIFYCONTROLLER7.getCode());
        }
        int courseCount = marketingCourseClient.getByClassifyId(id);
        if(courseCount>0){
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(), InternationalEnums.MARKETINGCLASSIFYCONTROLLER2.getCode());
        }
        return Response.ok(marketingClassifyClient.deleteClassify(id));
    }

    @ApiOperation(value = "更新分类")
    @RequestMapping(value = "/update",method = RequestMethod.POST)
    public Response<Boolean> updateClassify(@ApiParam(name = "marketingClassifyVo", value = "营销分类更新Vo")
                                                @RequestBody MarketingClassifyVo marketingClassifyVo){
        RequestContext rc = ContextHolder.get();
        //LOGGER.info("更新分类请求的上下文="+JSON.toJSONString(ContextHolder.get()));
        LOGGER.info("marketingClassifyVo="+JSON.toJSONString(marketingClassifyVo));
        if(marketingClassifyVo.getId() == null || marketingClassifyVo.getId() == 0L){
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(), InternationalEnums.MARKETINGCLASSIFYCONTROLLER3.getCode());
        }
        if(StringUtils.isEmpty(marketingClassifyVo.getName())){
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(), InternationalEnums.MARKETINGCLASSIFYCONTROLLER4.getCode());
        }
        ClassifyVo classifyVo = marketingClassifyClient.getByName(marketingClassifyVo.getName()
                ,rc.getSiteId(),marketingClassifyVo.getId());
        if(classifyVo != null && !StringUtils.isEmpty(classifyVo.getName())){
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(), InternationalEnums.MARKETINGCLASSIFYCONTROLLER5.getCode());
        }
        return Response.ok(marketingClassifyClient.updateClassify(marketingClassifyVo));
    }

    @ApiOperation(value = "查询全部营销分类")
    @RequestMapping(value = "/list",method = RequestMethod.GET)
    public Response<List<ClassifyVo>> listClassify(){
        LOGGER.info("查询全部营销分类请求的上下文="+JSON.toJSONString(ContextHolder.get()));
        return Response.ok(marketingClassifyClient.listClassify());
    }

    @ApiOperation(value = "查看营销分类", response = ClassifyVo.class)
    @RequestMapping(value = "/view",method = RequestMethod.GET)
    public Response<ClassifyVo> viewClassify(@ApiParam(name = "id", value = "营销分类Id", required = true)
                                                 @RequestParam Long id){
        LOGGER.info("更新分类请求的上下文="+JSON.toJSONString(ContextHolder.get()));
        LOGGER.info("id="+id);
        if(id == null || id == 0L ){
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(), InternationalEnums.MARKETINGCLASSIFYCONTROLLER6.getCode());
        }
        return Response.ok(marketingClassifyClient.viewClassify(id));
    }

}
