package com.yizhi.application.portal.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.exam.application.feign.ExamClient;
import com.yizhi.exam.application.vo.ContextAndPageSizeVO;
import com.yizhi.exam.application.vo.ExamDetailsMarkingVO;
import com.yizhi.site.application.feign.api.EventTrackApiClients;
import com.yizhi.site.application.vo.domain.ExamStaVo;
import com.yizhi.site.application.vo.site.*;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.util.application.date.DateUtil;
import com.yizhi.util.application.domain.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * com.yizhi.site.application.controller.api
 *
 * @author yanglang
 * @create 2025-01-14 10:57:55
 */
@RestController
@RequestMapping("/manage/api/eventTrack")
public class EventTrackManageController {

    @Autowired
    private EventTrackApiClients eventTrackApiClients;

    @Autowired
    private ExamClient examClient;

    @Autowired
    AccountClient accountClient;
    
    @Autowired
    private TaskExecutor taskExecutor;
    @Value("${pc.host.url}")
    String pcHostUrl;
    @Autowired
    private com.yizhi.application.portal.task.WorkbenchExportTask workbenchExportTask;


    @GetMapping("/addEvent")
    public Response addEvent(@RequestParam("type") String type, @RequestParam("businessId") Long businessId){
        eventTrackApiClients.addEvent(type,businessId);
        return Response.ok();
    }


    @GetMapping("/getTodayNum")
    public Response<EventTrackDayNumVo> getTodayNum(@RequestParam(value = "date",required = false) String date, @RequestParam(value = "types",required = false) Integer types){
        return Response.ok(eventTrackApiClients.getTodayNum(date, types));
    }

    @GetMapping("getNumByType")
    public Response<DayNumVo> getNumByType(@RequestParam(value = "date",required = false) String date, @RequestParam("types") List<Integer> types){
        return Response.ok(eventTrackApiClients.getNumByType(date,types));
    }

    @GetMapping("/queryNumByType")
    public Response<List<EventTrackTypeNumVo>> queryNumByType(@RequestParam(value = "date",required = false) String date, @RequestParam("types")List<Integer> types,
                                                              @RequestParam(value = "subName",required = false) String subName){
        return Response.ok(eventTrackApiClients.queryNumByType(date,types,subName));
    }

    @GetMapping("/queryDeptByType")
    public Response<List<EventTrackDeptNumVo>> queryDeptByType(@RequestParam(value = "date",required = false) String date, @RequestParam("types")List<Integer> types){
        return Response.ok(eventTrackApiClients.queryDeptByType(date,types));
    }

    @GetMapping("/queryTgNumByDept")
    public Response<List<EventTrackDeptNumVo>> queryTgNumByDept(@RequestParam(value = "typeId", required = false)Long typeId){
        return Response.ok(eventTrackApiClients.queryTgNumByDept(typeId));
    }

    @GetMapping("/selectExamListBySta")
    public Response<ExamStaVo> selectExamListBySta(){
        String year = DateUtil.toShortYear(new Date());
        RequestContext requestContext = ContextHolder.get();
        Long companyId = requestContext.getCompanyId();
        Long siteId = requestContext.getSiteId();
        ContextAndPageSizeVO contextAndPageSizeVO = new ContextAndPageSizeVO();
        contextAndPageSizeVO.setYear(year);
        contextAndPageSizeVO.setCompanyId(companyId);
        contextAndPageSizeVO.setSiteId(siteId);

        Integer examTotal = eventTrackApiClients.getExamTotal("培训",year);
        ExamStaVo examStaVo = new ExamStaVo();
        if(examTotal!=null){
            examStaVo.setExamNum(examTotal);
        }else{
            examStaVo.setExamNum(0);
        }
        ExamDetailsMarkingVO examDetailsMarkingVO = examClient.selectExamListBySta(contextAndPageSizeVO);
        if(examDetailsMarkingVO != null){
            examStaVo.setJoinNum(examDetailsMarkingVO.getCommitExamNum());
            BigDecimal passRate = new BigDecimal(examDetailsMarkingVO.getQualifidNum())
                    .divide(new BigDecimal(examDetailsMarkingVO.getCommitExamNum()), 4, BigDecimal.ROUND_DOWN);
            examStaVo.setQualifidNum(passRate.toString());
            BigDecimal firstPassRate = new BigDecimal(examDetailsMarkingVO.getQualifiedNumFrist())
                    .divide(new BigDecimal(examDetailsMarkingVO.getCommitExamNum()), 4, BigDecimal.ROUND_DOWN);
            examStaVo.setQualifiedNumFrist(firstPassRate.toString());
        }else{
            examStaVo.setJoinNum(0);
            examStaVo.setQualifidNum("0");
            examStaVo.setQualifiedNumFrist("0");
        }

        return Response.ok(examStaVo);
    }

    public static String percnet(float accountNum,float qualifidNum){
        if(accountNum==0){
            return "0";
        }
        double p = Double.valueOf(qualifidNum)/Double.valueOf(accountNum);
        if(p==0d&&qualifidNum>0){
            return "0.01";
        }
        DecimalFormat nf = (DecimalFormat) NumberFormat.getPercentInstance();
        //00表示小数点2位
        nf.applyPattern("00.00");
        //2表示精确到小数点后2位
        nf.setMaximumFractionDigits(2);
        String parcnet = nf.format(p);
        if(parcnet.startsWith("0")){
            parcnet = parcnet.substring(1);
        }
        return parcnet;
    }

    @GetMapping("/queryExamNum")
    Response<List<EventTrackDeptNumVo>> queryExamNum() {
        return Response.ok(eventTrackApiClients.queryExamNum());
    }

    @GetMapping("/queryRankList")
    public Response<List<EventTrackRankListVo>> queryRankList(@RequestParam(value = "date",required = false) String date, @RequestParam("type") String type){
        return Response.ok(eventTrackApiClients.queryRankList(date, type));
    }
    
    /**
     * 导出首页工作台数据
     * @return
     */
    @GetMapping("/export")
    public Response<String> export() {
        RequestContext context = ContextHolder.get();
        Date submitTime = new Date();
        Long taskId = System.currentTimeMillis();
        String serialNo = "EVENTTRACK-EXPORT-" + taskId.toString();
        String taskName = "首页工作台数据导出_" + taskId.toString();
        
        Map<String, Object> params = new HashMap<>();
        params.put("accountId", context.getAccountId());
        params.put("siteId", context.getSiteId());
        params.put("companyId", context.getCompanyId());
        params.put("taskId", taskId);
        params.put("submitTime", submitTime);
        params.put("serialNo", serialNo);
        params.put("taskName", taskName);
        params.put("exportType", "all");
        params.put("startDate", null);
        params.put("endDate", null);
        
        // 异步执行导出任务
        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {
                workbenchExportTask.execute(params, false);
            }
        });
        
        // 返回文件路径或下载链接
        String fileUrl = pcHostUrl+"/api/v1/buckets/upload/objects/download/?preview=true&prefix=" + taskName + ".xlsx";
        return Response.ok(fileUrl);
    }
}