package com.yizhi.application.portal.controller;

import java.util.HashMap;
import java.util.Map;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.feign.MoreSiteManageFeignClients;
import com.yizhi.site.application.vo.domain.SiteVo;
import com.yizhi.system.application.vo.domain.Site;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.page.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.plugins.Page;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 多站点管理
 * @author mei
 * @Date: 2018/3/17 20:30
 */

@Api(tags = "多站点管理")
@RestController
@RequestMapping("/manage/sites")
public class SiteMoreManageController {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(SiteMoreManageController.class);
	
	@Autowired
	MoreSiteManageFeignClients moreSiteManageFeignClients;
	
	/**
	 * 分页数据
	 */
	@GetMapping("/list")
	@ApiOperation(value = "分页列表", notes = "查询多站点的",response= PageInfo.class)
	public Response<PageInfo> listPage(
			@ApiParam(name = "name", value = "站点检索内容") @RequestParam(name = "name", required = false) String name,
            @ApiParam(name = "state", value = "状态，0停用1启用 ", required = true) @RequestParam(name = "state") Integer state,
            @ApiParam(name = "pageNo", value = "跳转页数,默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数,默认20条", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize){
		
		try{
			Map<String, Object> map = new HashMap<>();
	        map.put("name", name);
	        map.put("state", state);
	        
	        Page<SiteVo> page = new Page<>();
	        page.setCondition(map);
	        page.setCurrent(pageNo);
	        page.setSize(pageSize);
			return Response.ok(moreSiteManageFeignClients.listPage(page));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
	}
	
	/**
	 * 保存站点
	 * @param site
	 * @return
	 */
	@GetMapping("/insert")
	@ApiOperation(value = "保存站点", notes = "保存站点")
	public Response<String> insertDetail(SiteVo site){
		try{
			RequestContext context = ContextHolder.get();
			site.setCreateById(context.getAccountId());
			site.setCreateByName(context.getAccountName());
			site.setParentId(context.getSiteId());
			site.setCompanyId(context.getCompanyId());
			site.setOrgId(context.getOrgId());
			return Response.ok(moreSiteManageFeignClients.insertDetail(site));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
	}
	
	/**
	 * 编辑站点
	 * @param site
	 * @return
	 */
	@GetMapping("/update")
	@ApiOperation(value = "编辑站点", notes = "编辑站点")
	public Response<String> updateById(SiteVo site){
		try{
			return Response.ok(moreSiteManageFeignClients.updateById(site));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
		
	}

	/**
	 * 站点查看
	 * @param id
	 * @return
	 */
	@ApiOperation(value = "站点查看", notes = "站点查看",response=Site.class)
	@GetMapping("/view")
	public Response<Site>  find(@ApiParam(name = "站点id", value = "站点id") @RequestParam("id") Long id){
		try{
			return Response.ok(moreSiteManageFeignClients.find(id));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
	}
	
	/**
	 * 站点上架
	 * @param id
	 * @return
	 */
	@ApiOperation(value = "站点上架", notes = "站点上架")
	@PostMapping("/up")
	public Response<String> siteUp(@ApiParam(name = "站点id", value = "站点id") @RequestParam("id") Long id){
		try{
			return Response.ok(moreSiteManageFeignClients.siteUp(id));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
		
	}
	
	/**
	 * 站点下架
	 * @param id
	 * @return
	 */
	@ApiOperation(value = "站点下架", notes = "站点下架")
	@PostMapping("/down")
	public Response<String> siteDown(@ApiParam(name = "站点id", value = "站点id") @RequestParam("id") Long id){
		try{
			return Response.ok(moreSiteManageFeignClients.siteDown(id));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
	}
	
	/**
	 * 站点设置管理人员
	 */
	@ApiOperation(value = "站点设置管理人员", notes = "站点设置管理人员")
	@PostMapping("/user/manage")
	public Response<Boolean> setManagePersonnal(@ApiParam(name = "站点id", value = "站点id") @RequestParam("siteId") Long siteId, @ApiParam(name = "管理员id", value = "管理员id") @RequestParam("accountId") Long accountId){
		try{
			return Response.ok(moreSiteManageFeignClients.setManagePersonnal(siteId, accountId));
		}catch(Exception e){
			 LOGGER.error("", e);
	         return Response.fail();
		}
	}
}
