package com.yizhi.application.portal.task;

import cn.hutool.core.collection.CollectionUtil;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.domain.FileInfo;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.exam.application.feign.ExamClient;
import com.yizhi.exam.application.vo.ContextAndPageSizeVO;
import com.yizhi.exam.application.vo.ExamDetailsMarkingVO;
import com.yizhi.site.application.feign.PublicationManageFeignClients;
import com.yizhi.site.application.feign.api.EventTrackApiClients;
import com.yizhi.site.application.feign.api.SystemMailboxClients;
import com.yizhi.site.application.vo.domain.EventTrackVo;
import com.yizhi.site.application.vo.domain.ExamStaVo;
import com.yizhi.site.application.vo.domain.PublicationVo;
import com.yizhi.site.application.vo.domain.SystemMailboxParamVo;
import com.yizhi.site.application.vo.site.*;
import com.yizhi.system.application.system.remote.AccountClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;
import java.util.*;

@Component
public class WorkbenchExportTask extends AbstractDefaultTask {

    private static final Logger logger = LoggerFactory.getLogger(WorkbenchExportTask.class);

    @Autowired
    private EventTrackApiClients eventTrackApiClients;

    @Autowired
    private SystemMailboxClients systemMailboxClients;

    @Autowired
    private PublicationManageFeignClients publicationManageFeignClients;

    @Autowired
    private ExamClient examClient;

    @Autowired
    private AccountClient accountClient;

    @Override
    protected Object execute(Object params) {
        Map paramsMap = (Map) params;
        Long accountId = (Long) paramsMap.get("accountId");
        Long siteId = (Long) paramsMap.get("siteId");
        Long companyId = (Long) paramsMap.get("companyId");
        Long taskId = (Long) paramsMap.get("taskId");
        Date submitTime = (Date) paramsMap.get("submitTime");
        String serialNo = (String) paramsMap.get("serialNo");
        String taskName = (String) paramsMap.get("taskName");

        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
        working(taskContext);

        try {
            // 获取当前日期作为默认的开始和结束日期
            String currentDate = new java.text.SimpleDateFormat("yyyy-MM-dd").format(new Date());

            // 创建HSSFWorkbook对象(excel的文档对象)
            HSSFWorkbook wb = new HSSFWorkbook();

            // 创建信箱统计Sheet
            createMailboxSheet(wb, currentDate, currentDate, siteId, companyId);
            
            // 创建活动统计Sheet
            createActivitySheet(wb, currentDate, currentDate, siteId, companyId);
            
            // 创建测试统计Sheet
            createExamSheet(wb, currentDate, currentDate, siteId, companyId);
            
            // 创建投稿统计Sheet
            createPublicationSheet(wb, currentDate, currentDate, siteId, companyId);
            
            // 创建统计数据Sheet
            createStatisticsSheet(wb, currentDate, currentDate, siteId, companyId);

            // 生成文件名
            String fileName = taskName + ".xlsx";
            String filePath = new StringBuffer().append(FileConstant.SAVE_PATH).append(File.separator).append(fileName).toString();
            
            File saveDir = new File(FileConstant.SAVE_PATH);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            
            File file = new File(filePath);
            FileOutputStream os = new FileOutputStream(file);
            wb.write(os);
            os.close();
            
            // 上传到OSS并获取URL
            String upLoadUrl = com.yizhi.core.application.file.util.OssUpload.upload(filePath, fileName);
            
            success(taskContext, "导出成功", upLoadUrl);

            return upLoadUrl;
        } catch (Exception e) {
            logger.error("导出过程中发生错误", e);
            fail(taskContext, "导出过程中发生错误: " + e.getMessage());
            return null;
        }
    }

    /**
     * 创建信箱统计Sheet
     */
    private void createMailboxSheet(HSSFWorkbook wb, String startDate, String endDate, Long siteId, Long companyId) {
        HSSFSheet sheet = wb.createSheet("信箱统计");
        
        // 表头
        HSSFRow headerRow = sheet.createRow(0);
        String[] headers = {"信箱类型", "日期", "投信数量", "投信人"};
        for (int i = 0; i < headers.length; i++) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(headers[i]);
        }
        
        int rowNum = 1;
        
        // 查询信箱统计数据
        try {
            // 获取信箱类型统计（类型3通常代表信箱）
            List<Integer> mailboxTypes = Arrays.asList(3);
//            List<EventTrackVo> mailboxStats = eventTrackApiClients.queryNumByType(startDate, endDate, mailboxTypes, siteId, companyId);
            
//            if (mailboxStats != null && !mailboxStats.isEmpty()) {
//                for (EventTrackVo stat : mailboxStats) {
//                    HSSFRow row = sheet.createRow(rowNum++);
//                    row.createCell(0).setCellValue(stat.getTypeName() != null ? stat.getTypeName() : "未知信箱");
//                    row.createCell(1).setCellValue(stat.getCreateDate() != null ? stat.getCreateDate() : "未知日期");
//                    row.createCell(2).setCellValue(stat.getNum() != null ? stat.getNum() : 0);
//                    row.createCell(3).setCellValue(stat.getAccountName() != null ? stat.getAccountName() : "未知用户");
//                }
//            } else {
//                // 如果没有数据，添加提示信息
//                HSSFRow row = sheet.createRow(rowNum++);
//                row.createCell(0).setCellValue("暂无数据");
//                row.createCell(1).setCellValue("");
//                row.createCell(2).setCellValue("");
//                row.createCell(3).setCellValue("");
//            }
        } catch (Exception e) {
            logger.error("获取信箱统计数据失败", e);
            // 如果出现异常，添加错误提示
            HSSFRow row = sheet.createRow(rowNum++);
            row.createCell(0).setCellValue("数据获取失败");
            row.createCell(1).setCellValue("");
            row.createCell(2).setCellValue("");
            row.createCell(3).setCellValue("");
        }
        
        // 自动调整列宽
        for (int i = 0; i < headers.length; i++) {
            sheet.autoSizeColumn(i);
        }
    }

    /**
     * 创建活动统计Sheet
     */
    private void createActivitySheet(HSSFWorkbook wb, String startDate, String endDate, Long siteId, Long companyId) {
        HSSFSheet sheet = wb.createSheet("活动统计");
        
        // 表头
        HSSFRow headerRow = sheet.createRow(0);
        String[] headers = {"活动名称", "发布支部", "活动日期", "报名数量", "签到数量", "评论数量", "评论人"};
        for (int i = 0; i < headers.length; i++) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(headers[i]);
        }
        
        int rowNum = 1;
        
        try {
            // 获取活动统计数据（类型1通常代表活动）
            List<Integer> activityTypes = Arrays.asList(1);
            List<EventTrackTypeNumVo> activityStats = eventTrackApiClients.queryNumByType(null, activityTypes, null);
            
            if (activityStats != null && !activityStats.isEmpty()) {
                for (EventTrackTypeNumVo stat : activityStats) {
                    // 获取评论数据
                    StringBuilder commentInfo = new StringBuilder();
                    List<EventTrackTypeNumVo> commentStats = eventTrackApiClients.queryNumByType(null, Arrays.asList(5), null); // 假设类型5是评论
                    int commentCount = 0;
                    if (commentStats != null && !commentStats.isEmpty()) {
                        commentCount = commentStats.size();
                        for (int i = 0; i < commentStats.size(); i++) {
                            EventTrackTypeNumVo commentStat = commentStats.get(i);
                            if (i > 0) commentInfo.append(", ");
//                            commentInfo.append(commentStat.getAccountName() != null ? commentStat.getAccountName() : "未知用户");
                        }
                    }
                    
                    HSSFRow row = sheet.createRow(rowNum++);
//                    row.createCell(0).setCellValue(stat.getTypeName() != null ? stat.getTypeName() : "未知活动");
//                    row.createCell(1).setCellValue(stat.getOrgName() != null ? stat.getOrgName() : "未知支部");
//                    row.createCell(2).setCellValue(stat.getCreateDate() != null ? stat.getCreateDate() : "未知日期");
//                    row.createCell(3).setCellValue(stat.getNum() != null ? stat.getNum() : 0);
//                    row.createCell(4).setCellValue(stat.getCheckInNum() != null ? stat.getCheckInNum() : 0); // 假设有签到数量字段
                    row.createCell(5).setCellValue(commentCount);
                    row.createCell(6).setCellValue(commentInfo.toString());
                }
            } else {
                // 如果没有数据，添加提示信息
                HSSFRow row = sheet.createRow(rowNum++);
                for (int i = 0; i < headers.length; i++) {
                    row.createCell(i).setCellValue(i == 0 ? "暂无数据" : "");
                }
            }
        } catch (Exception e) {
            logger.error("获取活动统计数据失败", e);
            // 如果出现异常，添加错误提示
            HSSFRow row = sheet.createRow(rowNum++);
            for (int i = 0; i < headers.length; i++) {
                row.createCell(i).setCellValue(i == 0 ? "数据获取失败" : "");
            }
        }
        
        // 自动调整列宽
        for (int i = 0; i < headers.length; i++) {
            sheet.autoSizeColumn(i);
        }
    }

    /**
     * 创建测试统计Sheet
     */
    private void createExamSheet(HSSFWorkbook wb, String startDate, String endDate, Long siteId, Long companyId) {
        HSSFSheet sheet = wb.createSheet("测试统计");
        
        // 表头
        HSSFRow headerRow = sheet.createRow(0);
        String[] headers = {"测试名称", "发布支部", "发布日期", "参加测试人数", "平均分", "合格率"};
        for (int i = 0; i < headers.length; i++) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(headers[i]);
        }
        
        int rowNum = 1;
        
        try {
            // 获取测试列表
//            ContextAndPageSizeVO contextAndPageSizeVO = new ContextAndPageSizeVO();
//            contextAndPageSizeVO.setSiteId(siteId);
//            contextAndPageSizeVO.setCompanyId(companyId);
//            ExamDetailsMarkingVO examList = examClient.selectExamListBySta(contextAndPageSizeVO);
//
//            if (examList != null && !examList.isEmpty()) {
//                for (ExamStaVo exam : examList) {
//                    HSSFRow row = sheet.createRow(rowNum++);
//                    row.createCell(0).setCellValue(exam.getExamName() != null ? exam.getExamName() : "未知测试");
//                    row.createCell(1).setCellValue(exam.getOrgName() != null ? exam.getOrgName() : "未知支部");
//                    row.createCell(2).setCellValue(exam.getCreateDate() != null ? exam.getCreateDate() : "未知日期");
//                    row.createCell(3).setCellValue(exam.getJoinNum() != null ? exam.getJoinNum() : 0); // 假设有参与人数字段
//                    row.createCell(4).setCellValue(exam.getAverageScore() != null ? exam.getAverageScore() : 0.0); // 假设有平均分字段
//                    row.createCell(5).setCellValue(exam.getPassRate() != null ? exam.getPassRate() + "%" : "0%"); // 假设有合格率字段
//                }
//            } else {
//                // 如果没有数据，添加提示信息
//                HSSFRow row = sheet.createRow(rowNum++);
//                for (int i = 0; i < headers.length; i++) {
//                    row.createCell(i).setCellValue(i == 0 ? "暂无数据" : "");
//                }
//            }
        } catch (Exception e) {
            logger.error("获取测试统计数据失败", e);
            // 如果出现异常，添加错误提示
            HSSFRow row = sheet.createRow(rowNum++);
            for (int i = 0; i < headers.length; i++) {
                row.createCell(i).setCellValue(i == 0 ? "数据获取失败" : "");
            }
        }
        
        // 自动调整列宽
        for (int i = 0; i < headers.length; i++) {
            sheet.autoSizeColumn(i);
        }
    }

    /**
     * 创建投稿统计Sheet
     */
    private void createPublicationSheet(HSSFWorkbook wb, String startDate, String endDate, Long siteId, Long companyId) {
        HSSFSheet sheet = wb.createSheet("投稿统计");
        
        // 表头
        HSSFRow headerRow = sheet.createRow(0);
        String[] headers = {"投稿标题", "投稿人", "投稿板块", "投稿时间"};
        for (int i = 0; i < headers.length; i++) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(headers[i]);
        }
        
        int rowNum = 1;
        
        try {
            // 获取投稿列表
            Map<String, Object> params = new HashMap<>();
            params.put("siteId", siteId);
            params.put("companyId", companyId);
            params.put("startDate", startDate);
            params.put("endDate", endDate);
//            List<PublicationVo> publicationList = publicationManageFeignClients.queryList(params);
            
//            if (publicationList != null && !publicationList.isEmpty()) {
//                for (PublicationVo publication : publicationList) {
//                    HSSFRow row = sheet.createRow(rowNum++);
//                    row.createCell(0).setCellValue(publication.getTitle() != null ? publication.getTitle() : "未知标题");
//                    row.createCell(1).setCellValue(publication.getAccountName() != null ? publication.getAccountName() : "未知用户");
//                    row.createCell(2).setCellValue(publication.getSectionName() != null ? publication.getSectionName() : "未知板块");
//                    row.createCell(3).setCellValue(publication.getCreateDate() != null ? publication.getCreateDate() : "未知时间");
//                }
//            } else {
//                // 如果没有数据，添加提示信息
//                HSSFRow row = sheet.createRow(rowNum++);
//                for (int i = 0; i < headers.length; i++) {
//                    row.createCell(i).setCellValue(i == 0 ? "暂无数据" : "");
//                }
//            }
        } catch (Exception e) {
            logger.error("获取投稿统计数据失败", e);
            // 如果出现异常，添加错误提示
            HSSFRow row = sheet.createRow(rowNum++);
            for (int i = 0; i < headers.length; i++) {
                row.createCell(i).setCellValue(i == 0 ? "数据获取失败" : "");
            }
        }
        
        // 自动调整列宽
        for (int i = 0; i < headers.length; i++) {
            sheet.autoSizeColumn(i);
        }
    }

    /**
     * 创建统计数据Sheet
     */
    private void createStatisticsSheet(HSSFWorkbook wb, String startDate, String endDate, Long siteId, Long companyId) {
        HSSFSheet sheet = wb.createSheet("统计数据");
        
        // 表头
        HSSFRow headerRow = sheet.createRow(0);
        String[] headers = {"统计项目", "数值", "说明"};
        for (int i = 0; i < headers.length; i++) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(headers[i]);
        }
        
        int rowNum = 1;
        
        try {
            // 获取登录量统计（类型2通常代表登录）
            List<Integer> loginTypes = Arrays.asList(2);
//            List<EventTrackVo> loginStats = eventTrackApiClients.queryNumByType(startDate, endDate, loginTypes, siteId, companyId);
//            int loginCount = 0;
//            if (loginStats != null) {
//                for (EventTrackVo stat : loginStats) {
//                    if (stat.getNum() != null) {
//                        loginCount += stat.getNum();
//                    }
//                }
//            }
//
            // 获取浏览量统计（类型4通常代表浏览）
            List<Integer> browseTypes = Arrays.asList(4);
//            List<EventTrackVo> browseStats = eventTrackApiClients.queryNumByType(startDate, endDate, browseTypes, siteId, companyId);
//            int browseCount = 0;
//            if (browseStats != null) {
//                for (EventTrackVo stat : browseStats) {
//                    if (stat.getNum() != null) {
//                        browseCount += stat.getNum();
//                    }
//                }
//            }
            
            // 获取互动量统计（类型5通常代表互动）
//            List<Integer> interactTypes = Arrays.asList(5);
//            List<EventTrackVo> interactStats = eventTrackApiClients.queryNumByType(startDate, endDate, interactTypes, siteId, companyId);
//            int interactCount = 0;
//            if (interactStats != null) {
//                for (EventTrackVo stat : interactStats) {
//                    if (stat.getNum() != null) {
//                        interactCount += stat.getNum();
//                    }
//                }
//            }
            
//            // 获取个人登录统计
//            // 使用queryRankList方法获取用户排名列表（type为2表示用户）
//            List<EventTrackRankListVo> userRankList = eventTrackApiClients.queryRankList(startDate, "2");
//            StringBuilder personalLoginStats = new StringBuilder();
//            if (userRankList != null && !userRankList.isEmpty()) {
//                for (EventTrackRankListVo userStat : userRankList) {
//                    if (personalLoginStats.length() > 0) {
//                        personalLoginStats.append(", ");
//                    }
//                    String userName = userStat.getName() != null ? userStat.getName() : "未知用户";
//                    int loginCountPerUser = userStat.getNum();
//                    personalLoginStats.append(userName).append(":").append(loginCountPerUser).append("次");
//                }
//            } else {
//                personalLoginStats.append("暂无个人登录统计");
//            }
//
//            // 添加统计数据到表格
//            HSSFRow row1 = sheet.createRow(rowNum++);
//            row1.createCell(0).setCellValue("登录量");
////            row1.createCell(1).setCellValue(loginCount);
//            row1.createCell(2).setCellValue("用户登录系统的总次数");
//
//            HSSFRow row2 = sheet.createRow(rowNum++);
//            row2.createCell(0).setCellValue("浏览量");
////            row2.createCell(1).setCellValue(browseCount);
//            row2.createCell(2).setCellValue("用户浏览内容的总次数");
//
//            HSSFRow row3 = sheet.createRow(rowNum++);
//            row3.createCell(0).setCellValue("互动量");
////            row3.createCell(1).setCellValue(interactCount);
//            row3.createCell(2).setCellValue("用户参与互动的总次数");
//
//            HSSFRow row4 = sheet.createRow(rowNum++);
//            row4.createCell(0).setCellValue("个人登录统计");
//            row4.createCell(1).setCellValue(personalLoginStats.toString());
//            row4.createCell(2).setCellValue("每个用户的登录次数");
            
        } catch (Exception e) {
            logger.error("获取统计数据失败", e);
            // 如果出现异常，添加错误提示
            HSSFRow row = sheet.createRow(rowNum++);
            row.createCell(0).setCellValue("数据获取失败");
            row.createCell(1).setCellValue("");
            row.createCell(2).setCellValue("获取统计数据时发生错误");
        }
        
        // 自动调整列宽
        for (int i = 0; i < headers.length; i++) {
            sheet.autoSizeColumn(i);
        }
    }



}