package com.yizhi.application.rangeExport;

import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.library.application.feign.CaseLibraryClient;
import com.yizhi.library.application.vo.CaseLibraryVO;
import com.yizhi.library.application.vo.CaselibraryAuthorizeVO;
import com.yizhi.system.application.model.AccountRangeExportParam;
import com.yizhi.system.application.system.remote.AccountRangeClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component
public class CaseLibraryRangeExport extends AbstractDefaultTask<String, Map<String, Object>> {


    private static final Logger logger = LoggerFactory.getLogger(CaseLibraryRangeExport.class);


    @Autowired
    private CaseLibraryClient caseLibraryClient;
    @Autowired
    private AccountRangeClient accountRangeClient;


    @Override
    protected String execute(Map<String, Object> map) {
        // TODO Auto-generated method stub
        Long caseLibraryId = (Long) map.get("caseLibraryId");
        RequestContext context = (RequestContext) map.get("context");

        List<CaselibraryAuthorizeVO> caseLibraryAuthorizes = caseLibraryClient.getAuthorize(caseLibraryId);
        CaseLibraryVO caseLibrary = caseLibraryClient.getCaseLibrary(caseLibraryId);

        List<Long> accountIds = new ArrayList<>();
        List<Long> orgIds = new ArrayList<>();

        AccountRangeExportParam accountRangeImportParam = new AccountRangeExportParam();
        if (!CollectionUtils.isEmpty(caseLibraryAuthorizes)) {
            for (CaselibraryAuthorizeVO caselibraryAuthorizeVO : caseLibraryAuthorizes) {
                //用户
                if (caselibraryAuthorizeVO.getType() == 2) {
                    accountIds.add(caselibraryAuthorizeVO.getRelationId());
                    //部门
                } else if (caselibraryAuthorizeVO.getType() == 1) {
                    orgIds.add(caselibraryAuthorizeVO.getRelationId());
                }
            }
            accountRangeImportParam.setAccountIds(accountIds);
            if (null != caseLibrary) {
                accountRangeImportParam.setBizName(caseLibrary.getName());
            }
            accountRangeImportParam.setContext(context);
            accountRangeImportParam.setOrgIds(orgIds);
        }
        System.out.println(accountRangeImportParam);
        String result = accountRangeClient.doExport(accountRangeImportParam);
        return result;

    }

}
