package com.yizhi.application.rangeExport;

import java.util.Map;

import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.system.application.model.AccountRangeExportParam;
import com.yizhi.system.application.system.remote.AccountRangeClient;
import com.yizhi.training.application.feign.TrainingProjectClient;
import com.yizhi.training.application.vo.manage.VisibleRangeExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TrainingProjectVisibleRangeExport extends AbstractDefaultTask<String, Map<String,Object>> {
	
	
	private static final Logger logger = LoggerFactory.getLogger(TrainingProjectVisibleRangeExport.class);
	

	@Autowired
	private TrainingProjectClient trainingProjectClient;
	@Autowired
	private AccountRangeClient accountRangeClient;
	
	

	@Override
	protected String execute(Map<String, Object> map) {
		// TODO Auto-generated method stub
		Long trainingProjectId=(Long) map.get("trainingProjectId");
		RequestContext context=(RequestContext) map.get("context");
		
		VisibleRangeExport visibleRangeExport=trainingProjectClient.exportVisibleRange(trainingProjectId);
		AccountRangeExportParam accountRangeImportParam=new AccountRangeExportParam();
		if(visibleRangeExport!=null) {
			accountRangeImportParam.setAccountIds(visibleRangeExport.getAccountIds());
			accountRangeImportParam.setBizName(visibleRangeExport.getBizName());
			accountRangeImportParam.setContext(context);
			accountRangeImportParam.setOrgIds(visibleRangeExport.getOrgIds());
		}
		System.out.println(accountRangeImportParam);
		String result=accountRangeClient.doExport(accountRangeImportParam);
		return result;
		 
	}

}
