package com.yizhi.application.rangeImport;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.course.application.feign.CourseClient;
import com.yizhi.course.application.vo.CourseAccountVO;
import com.yizhi.system.application.model.AccountRangeImportModel;
import com.yizhi.system.application.model.AccountRangeImportParam;
import com.yizhi.system.application.system.remote.AccountRangeClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.IdGenerator;

import java.util.*;

/**
 * @Auther: dingxiaowei
 * @Date: 2018/9/17 15:36
 * @Description:课程可见范围异步导入
 */
@Component
public class CourseRangeImport extends AbstractDefaultTask<String, Map<String, Object>> {

    private static final Logger LOGGER = LoggerFactory.getLogger(CourseRangeImport.class);

    private IdGenerator idGenerator;

    @Autowired
    private AccountRangeClient accountRangeClient;

    @Autowired
    CourseClient courseClient;
    @Autowired
    private RangeUtil importUtil;


    @Override
    protected String execute(Map<String, Object> map) {

        //从map中取值
        String ossUrl = (String) map.get("ossUrl");
        RequestContext res = (RequestContext) map.get("requestContext");
        Long courseId = (Long) map.get("courseId");
        Long siteId = res.getSiteId();
        Long accountId = res.getAccountId();
        Long companyId = res.getCompanyId();
        Date submitTime = new Date();
        Long taskId = (Long) map.get("taskId");
        String serialNo = (String) map.get("serialNo");
        String taskName = (String) map.get("taskName");
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
        working(taskContext);

        //将请求值装入param中
        AccountRangeImportParam param = new AccountRangeImportParam();
        param.setOssUrl(ossUrl);
        param.setRequestContext(res);
        param.setType(AccountRangeImportParam.Type.COURSE);
        List<AccountRangeImportModel.SuccessAccount> successList = null;
        List<AccountRangeImportModel.ErrorAccount> errorList = null;
        List<Integer> integerList = null;
        //进行导入
        try {
            AccountRangeImportModel accountRangeImportModel = accountRangeClient.doImport(param);
            if (null != accountRangeImportModel) {
                successList = accountRangeImportModel.getSuccessList();
                errorList = accountRangeImportModel.getErrorList();
            }

            errorList = (errorList == null ? new ArrayList<>() : errorList);
            successList = (successList == null ? new ArrayList<>() : successList);

            List<CourseAccountVO> courseAccounts = new ArrayList<>();

            CourseAccountVO courseAccount = null;
            if (!CollectionUtils.isEmpty(successList)) {
                for (AccountRangeImportModel.SuccessAccount rangeImportModel : successList) {
                    courseAccount = new CourseAccountVO();
                    courseAccount.setCourseId(courseId);
                    courseAccount.setType(2);
                    courseAccount.setRelationId(rangeImportModel.getId());
                    courseAccount.setName(rangeImportModel.getName().trim());
                    courseAccount.setSiteId(siteId);
                    courseAccounts.add(courseAccount);
                }
                courseClient.insertCourseAccount(courseAccounts);
            }

            System.out.println("开始进入返回过程");
            System.out.println(taskId);

            importUtil.returnResults(taskContext, successList, errorList, ossUrl);
            System.out.println("结束返回过程");
        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, "课程可见范围异步导入过程中出现错误");
            LOGGER.error("课程可见范围异步导入过程中出现错误", e);
        }

        return "OK";
    }
}
