package com.yizhi.application.rangeImport;

import com.yizhi.application.customProject.contoller.ExperiencePoolRangeImport;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.vo.RangeImportParamVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @Auther: dingxiaowei
 * @Date: 2018/9/17 15:44
 * @Description:
 */
@Api(tags = "可见范围导入", description = "可见范围导入")
@RestController
@RequestMapping("/manage/range/import/")
public class RangeImportController {

    private static final Logger LOGGER = LoggerFactory.getLogger(RangeImportController.class);

    @Autowired
    private CourseRangeImport courseRangeImport;

    @Autowired
    private ExamRangeImport examRangeImport;

    @Autowired
    ResearchRangeImport researchRangeImport;

    @Autowired
    private LiveRangeImport liveRangeImport;

//    @Autowired
//    private VoteRangeImport voteRangeImport;

    @Autowired
    private AssignmentRangeImport assignmentRangeImport;

    @Autowired
    private TrainingProjectRangeImport trainingProjectRangeImport;

    @Autowired
    private ExperiencePoolRangeImport poolRangeImport;

    @Autowired
    private CaseLibraryImport caseLibraryImport;


    @ApiOperation(value = "课程可见范围导入", notes = "课程可见范围导入")
    @PostMapping("/course")
    public Response<Object> courseRangeImport(@RequestBody RangeImportParamVo rangeImportParamVo) {
        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "COURSE-RANGE-IMPORT-" + taskId.toString();
        String taskName = "课程可见范围导入-" + taskId.toString();
        String ossUrl = rangeImportParamVo.getOssUrl();
        Long courseId = rangeImportParamVo.getBizdId();
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        map.put("ossUrl", ossUrl);
        map.put("requestContext", res);
        map.put("courseId", courseId);
        map.put("taskId", taskId);
        map.put("serialNo", serialNo);
        map.put("taskName", taskName);
        courseRangeImport.execute(map, true);
        return Response.ok("任务序号:" + serialNo + ",任务名称:" + taskName);

    }

    @ApiOperation(value = "考试可见范围导入", notes = "考试可见范围导入")
    @PostMapping("/exam")
    public Response<Object> examRangeImport(@RequestBody RangeImportParamVo rangeImportParamVo) {
        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "EXAM-RANGE-IMPORT-" + taskId.toString();
        String taskName = "考试可见范围导入-" + taskId.toString();
        String ossUrl = rangeImportParamVo.getOssUrl();
        Long examId = rangeImportParamVo.getBizdId();
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        map.put("ossUrl", ossUrl);
        map.put("requestContext", res);
        map.put("examId", examId);
        map.put("taskId", taskId);
        map.put("serialNo", serialNo);
        map.put("taskName", taskName);
        examRangeImport.execute(map, true);
        return Response.ok("任务序号:" + serialNo + ",任务名称:" + taskName);
    }

    @ApiOperation(value = "调研可见范围导入", notes = "调研可见范围导入")
    @PostMapping("/research")
    public Response<Object> researchRangeImport(@RequestBody RangeImportParamVo rangeImportParamVo) {
        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "RESEARCH-RANGE-IMPORT-" + taskId.toString();
        String taskName = "调研可见范围导入-" + taskId.toString();
        String ossUrl = rangeImportParamVo.getOssUrl();
        Long researchId = rangeImportParamVo.getBizdId();
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        map.put("ossUrl", ossUrl);
        map.put("requestContext", res);
        map.put("researchId", researchId);
        map.put("taskId", taskId);
        map.put("serialNo", serialNo);
        map.put("taskName", taskName);
        researchRangeImport.execute(map, true);
        return Response.ok("任务序号:" + serialNo + ",任务名称:" + taskName);
    }


    @ApiOperation(value = "直播可见范围导入", notes = "直播可见范围导入")
    @PostMapping("/live")
    public Response<Object> liveRangeImport(@RequestBody RangeImportParamVo rangeImportParamVo) {
        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "LIVE-RANGE-IMPORT-" + taskId.toString();
        String taskName = "直播可见范围导入-" + taskId.toString();
        String ossUrl = rangeImportParamVo.getOssUrl();
        Long liveId = rangeImportParamVo.getBizdId();
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        map.put("ossUrl", ossUrl);
        map.put("requestContext", res);
        map.put("liveId", liveId);
        map.put("taskId", taskId);
        map.put("serialNo", serialNo);
        map.put("taskName", taskName);
        liveRangeImport.execute(map, true);
        return Response.ok("任务序号:" + serialNo + ",任务名称:" + taskName);
    }

//    @ApiOperation(value = "投票可见范围导入", notes = "投票可见范围导入")
//    @PostMapping("/vote")
//    public Response<Object> voteRangeImport(@RequestBody RangeImportParamVo rangeImportParamVo) {
//        Date date = new Date();
//        Long taskId = date.getTime();
//        String serialNo = "VOTE-RANGE-IMPORT-" + taskId.toString();
//        String taskName = "投票可见范围导入-" + taskId.toString();
//        String ossUrl = rangeImportParamVo.getOssUrl();
//        Long voteId = rangeImportParamVo.getBizdId();
//        Map<String, Object> map = new HashMap<>();
//        RequestContext res = ContextHolder.get();
//        map.put("ossUrl", ossUrl);
//        map.put("requestContext", res);
//        map.put("voteId", voteId);
//        map.put("taskId", taskId);
//        map.put("serialNo", serialNo);
//        map.put("taskName", taskName);
//        voteRangeImport.execute(map, true);
//        return Response.ok("任务序号:" + serialNo + ",任务名称:" + taskName);
//    }

    @ApiOperation(value = "作业可见范围导入", notes = "作业可见范围导入")
    @PostMapping("/assignment")
    public Response<Object> assignmentRangeImport(@RequestBody RangeImportParamVo rangeImportParamVo) {
        RequestContext res = ContextHolder.get();
        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "ASSIGNMENT-RANGE-IMPORT-" + taskId.toString();
        String taskName = "作业可见范围导入-" + taskId.toString();
        String ossUrl = rangeImportParamVo.getOssUrl();
        Long assignmentId = rangeImportParamVo.getBizdId();
        Map<String, Object> map = new HashMap<>();
        map.put("ossUrl", ossUrl);
        map.put("requestContext", res);
        map.put("assignmentId", assignmentId);
        map.put("taskId", taskId);
        map.put("serialNo", serialNo);
        map.put("taskName", taskName);
        assignmentRangeImport.execute(map, true);
        return Response.ok("任务序号:" + serialNo + ",任务名称:" + taskName);
    }

//    @ApiOperation(value = "证书可见范围导入", notes = "证书可见范围导入")
//    public Response<Object> certificateRangeImport(@ApiParam(value = "阿里云url", required = true) @RequestParam("ossUrl") String ossUrl,
//                                                   @ApiParam(value = "证书id", required = true) Long certificateId) {
//        Map<String, Object> map = new HashMap<>();
//        RequestContext res = ContextHolder.get();
//        map.put("ossUrl", ossUrl);
//        map.put("requestContext", res);
//        map.put("certificateId", certificateId);
//
//
//        return Response.ok();
//    }

    @ApiOperation(value = "培训项目可见范围导入", notes = "培训项目可见范围导入")
    @PostMapping("/trainingProject")
    public Response<Object> trainingProjectRangeImport(@RequestBody RangeImportParamVo rangeImportParamVo) {
        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "TRAININGPROJECT-RANGE-IMPORT-" + taskId.toString();
        String taskName = "培训项目可见范围导入-" + taskId.toString();
        String ossUrl = rangeImportParamVo.getOssUrl();
        Long projectId = rangeImportParamVo.getBizdId();
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
//        res.setAccountId(1314l);
//        res.setAccountName("taoge");
//        res.setCompanyId(1314l);
//        res.setSiteId(1314l);
//        res.setOrgId(1314l);
        map.put("ossUrl", ossUrl);
        map.put("requestContext", res);
        map.put("projectId", projectId);
        map.put("taskId", taskId);
        map.put("serialNo", serialNo);
        map.put("taskName", taskName);
        trainingProjectRangeImport.execute(map, true);
        return Response.ok("任务序号:" + serialNo + ",任务名称:" + taskName);
    }

    @ApiOperation(value = "经验池学员范围导入", notes = "经验池学员范围导入")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "阿里云url", value = "ossUrl", paramType = "body", required = true),
            @ApiImplicitParam(name = "经验池ID", value = "bizdId", paramType = "body", required = true)
    })
    @PostMapping("/experiencePool")
    public Response<String> poolRangeImport(@RequestBody RangeImportParamVo rangeImportParamVo) {
        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "EXPERIENCE-POOL-RANGE-IMPORT-" + taskId.toString();
        String taskName = "经验池学员范围导入-" + taskId.toString();
        String ossUrl = rangeImportParamVo.getOssUrl();
        Long poolId = rangeImportParamVo.getBizdId();
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        map.put("ossUrl", ossUrl);
        map.put("res", res);
        map.put("poolId", poolId);
        map.put("taskId", taskId);
        map.put("serialNo", serialNo);
        map.put("taskName", taskName);
        poolRangeImport.execute(map, true);
        return Response.ok("任务序号:" + serialNo);
    }

    @ApiOperation(value = "案例活动范围导入", notes = "案例活动范围导入")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "阿里云url", value = "ossUrl", paramType = "body", required = true),
            @ApiImplicitParam(name = "案例活动", value = "bizdId", paramType = "body", required = true)
    })
    @PostMapping("/caseLibrary")
    public Response<String> caseLibraryImport(@RequestBody RangeImportParamVo rangeImportParamVo) {
        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "CASE-LIBRARY-RANGE-IMPORT-" + taskId.toString();
        String taskName = "案例活动可见范围导入-" + taskId.toString();
        String ossUrl = rangeImportParamVo.getOssUrl();
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        map.put("ossUrl", ossUrl);
        map.put("res", res);
        map.put("caseLibraryId", rangeImportParamVo.getBizdId());
        map.put("taskId", taskId);
        map.put("serialNo", serialNo);
        map.put("taskName", taskName);
        caseLibraryImport.execute(map, true);
        return Response.ok("任务序号:" + serialNo);
    }
}
