package com.yizhi.application.report.certificate;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.certificate.application.feign.CertificateUserFeignClients;
import com.yizhi.certificate.application.vo.CertificateListVO;
import com.yizhi.certificate.application.vo.CertificateUserListVO;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 证书报表统计
 *
 * @author ding
 */

@Api(tags = "报表统计-证书统计", description = "报表统计-证书统计")
@RestController
@RequestMapping("/manage/report/certificate")
public class ReportCertificateController {

    private static Logger logger = LoggerFactory
            .getLogger(ReportCertificateController.class);

    @Autowired
    private CertificateUserFeignClients clients;

    @Autowired
    private CertificateListExport certificateListExport;

    @Autowired
    private CertificateDetailsExport certificateDetailsExport;

    @ApiOperation(value = "证书统计列表", notes = "证书统计列表")
    @GetMapping("/list")
    public Response<Object> getCertificateList(

            @ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize,
            @ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @ApiParam(value = "开始日期", required = false) @RequestParam(value = "startDate", required = false) String startDate,
            @ApiParam(value = "结束日期", required = false) @RequestParam(value = "endDate", required = false) String endDate,
            @ApiParam(value = "用户名", required = false) @RequestParam(value = "userName", required = false) String userName,
            @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgNameLike", required = false) String orgNameLike) {

        RequestContext context = ContextHolder.get();
        Long companyId = context.getCompanyId();
        Long siteId = context.getSiteId();
        Long accountId = context.getAccountId();
        List<Long> orgIds = null;
        if (!context.isAdmin()) {
            orgIds = context.getOrgIds();
        }
        Page<CertificateUserListVO> page = clients.userRankList(startDate, endDate, pageNo, pageSize, siteId, companyId, userName, orgNameLike, orgIds, context.isAdmin(), accountId);
        Integer pageTotal = 0;
        if (null != page) {
            pageTotal = page.getTotal();
        }
        Map<String, Integer> pageMap = new HashMap<>();
        pageMap.put("pageNo", pageNo);
        pageMap.put("pageSize", pageSize);
        pageMap.put("pageTotal", pageTotal);
        return Response.ok(page, pageMap);
    }


    @ApiOperation(value = "证书统计,下载统计数据", notes = "证书统计,下载统计数据")
    @GetMapping("/certificateListExport")
    public Response<String> certificateListExport(
            @ApiParam(value = "开始日期", required = false) @RequestParam(value = "startDate", required = false) String startDate,
            @ApiParam(value = "结束日期", required = false) @RequestParam(value = "endDate", required = false) String endDate,
            @ApiParam(value = "用户名", required = false) @RequestParam(value = "userName", required = false) String userName,
            @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgNameLike", required = false) String orgNameLike) {
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        Long taskId = System.currentTimeMillis();
        String serialNo = "CERTIFICATE-LIST-EXPORT" + taskId.toString();
        String taskName = "证书统计统计数据下载" + taskId.toString();
        map.put("res", res);
        map.put("taskId", taskId);
        map.put("taskName", taskName);
        map.put("serialNo", serialNo);
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        map.put("orgNameLike", orgNameLike);
        map.put("userName", userName);
        certificateListExport.execute(map, true);
        return Response.ok("任务名称: " + taskName + ",任务序号: " + serialNo);
    }

    @ApiOperation(value = "证书统计,下载明细数据", notes = "证书统计,下载明细数据")
    @GetMapping("/detailsExport")
    public Response<String> certificateDetailsExport(
            @ApiParam(value = "开始日期", required = false) @RequestParam(value = "startDate", required = false) String startDate,
            @ApiParam(value = "结束日期", required = false) @RequestParam(value = "endDate", required = false) String endDate,
            @ApiParam(value = "用户名", required = false) @RequestParam(value = "userName", required = false) String userName,
            @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgNameLike", required = false) String orgNameLike) {
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        Long taskId = System.currentTimeMillis();
        String serialNo = "CERTIFICATE-DETAILS-EXPORT" + taskId.toString();
        String taskName = "证书统计明细数据下载" + taskId.toString();
        map.put("res", res);
        map.put("taskId", taskId);
        map.put("taskName", taskName);
        map.put("serialNo", serialNo);
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        map.put("orgNameLike", orgNameLike);
        map.put("userName", userName);
        certificateDetailsExport.execute(map, true);
        return Response.ok("任务名称: " + taskName + ",任务序号: " + serialNo);
    }

    @ApiOperation(value = "证书统计按证书维度", notes = "证书统计按证书维度")
    @GetMapping("/certificateList")
    public Response<Object> certificateList(

            @ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize,
            @ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @ApiParam(value = "开始日期", required = false) @RequestParam(value = "startDate", required = false) String startDate,
            @ApiParam(value = "结束日期", required = false) @RequestParam(value = "endDate", required = false) String endDate,
            @ApiParam(value = "证书关键字", required = false) @RequestParam(value = "certificateName", required = false) String certificateName) {

        Page<CertificateListVO> page = clients.certificateList(startDate, endDate, pageNo, pageSize, certificateName);
        Integer pageTotal = 0;
        if (null != page) {
            pageTotal = page.getTotal();
        }
        Map<String, Integer> pageMap = new HashMap<>();
        pageMap.put("pageNo", pageNo);
        pageMap.put("pageSize", pageSize);
        pageMap.put("pageTotal", pageTotal);
        return Response.ok(page, pageMap);
    }

    @ApiOperation(value = "证书统计按证书维度", notes = "证书统计按证书维度")
    @GetMapping("/certificateStatisticsExport")
    public Response<Object> certificateStatisticsExport(
            @ApiParam(value = "开始日期", required = false) @RequestParam(value = "startDate", required = false) String startDate,
            @ApiParam(value = "结束日期", required = false) @RequestParam(value = "endDate", required = false) String endDate,
            @ApiParam(value = "证书关键字", required = false) @RequestParam(value = "certificateName", required = false) String certificateName) {

        String serialNo = clients.certificateListExport(startDate, endDate, certificateName);
        return Response.ok("导出成功," + " " + "编号:" + serialNo);
    }

}
