package com.yizhi.application.tools;

import java.nio.charset.Charset;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Component;
/**
 * @Author: XieHaijun
 * @Description: 此处用了重写过的JsonObject，用LinkedHashMap代替了HashMap以保证返回参数的顺序(方便调试查看，可不使用)，
 *                  不使用则改声明中的JSonObject为org的json即可
 * @Date: Created in 15:36 2019/6/3
 * @Modified By
 */
@Component
public class HorseLight {

    private String vid = null;
    private String secretKey = "oj0LfU5fwB";
    private String username = "";
    private String code = "";
    private int status = 1;
    private String t = null;


    private String sign = null;
    //private String msg = "Errormessage!";
    private String fontSize = "18";
    private String fontColor = "0x000000";
    //private String speed = "200";
    private String filter = "on";
    private String setting = "1";
    private String alpha = "0.85";
    private String filterAlpha = "1";
    private String filterColor = "0xffffff";
    private String blurX = "2";
    private String blurY = "2";
    //private String tweenTime = "1";
    //private String interval = "5";
    //private String lifeTime = "3";
    //private String strength = "4";
    private String show = "on";

    public JSONObject getJson() {
        getSign();
        JSONObject object = new JSONObject();
        object.put("status", 1);
        object.put("username", this.username);
        object.put("sign", this.sign);
        //object.put("msg", this.msg);
        object.put("fontSize", this.fontSize);
        object.put("fontColor", this.fontColor);
        //object.put("speed", this.speed);
        object.put("filter", this.filter);
        object.put("setting", this.setting);
        object.put("alpha", this.alpha);
        object.put("filterAlpha", this.filterAlpha);
        object.put("filterColor", this.filterColor);
        object.put("blurX", this.blurX);
        object.put("blurY", this.blurY);
        //object.put("tweenTime", this.tweenTime);
        //object.put("interval", this.interval);
        //object.put("lifeTime", this.lifeTime);
        //object.put("strength", this.strength);
        object.put("show", this.show);
        return object;
    }



    /**
     * @Description: 拼接计算并返回授权sign
     * @return: java.lang.String
     * @Author: LJH
     */
    public String getSignForValidateOnly() {
        String plain = "vid=" + vid + "&secretkey=" + secretKey + "&username=" + username + "&code=" + code + "&status=" + status + "&t=" + t;
        this.sign = DigestUtils.md5Hex(plain.getBytes(Charset.forName("UTF-8")));
        return sign;
    }

    /**
     * @Description: 拼接计算并返回跑马灯sign
     * @return: java.lang.String
     * @Author: LJH
     */
    public String getSign() {
        String plain = "vid=" + this.vid + "&secretkey=" + this.secretKey + "&username=" + this.username + "&code=" + this.code + "&status=" + this.status + "&t=" + this.t;

        //System.out.println("plain="+plain);
        this.sign = DigestUtils.md5Hex(plain.getBytes(Charset.forName("UTF-8")));
        return this.sign;
    }

    /**
     * @Description: 用main做测试类，在此手动填入参数，测试正确的返回sign
     * @return: void
     * @Author: LJH
     */
    public static void main(String[] args) {
        HorseLight horseLight = new HorseLight();
        horseLight.setT("143020010115550947");
        horseLight.setCode("abc");
        horseLight.setVid("8f8482aaab11dd5f45f183a9192a04c5_8");
        horseLight.setUsername("suki");
        horseLight.setSecretKey("AiDQw1mAmi");
        System.out.println("=========s=i=g=n==" + horseLight.getSign() + "=============");
    }

    public void setVid(String vid) {
        this.vid = vid;
        if (null == vid) {
            this.vid = "";
        }
    }

    public void setCode(String code) {
        this.code = code;
        if (null == code) {
            this.code = "";
        }
    }

    public void setT(String t) {
        this.t = t;
        if (null == t) {
            this.t = "";
        }
    }

    public void setUsername(String username) {
        this.username = username;
        if (null == username) {
            this.username = "";
        }
    }

    public void setShow(String show){
        this.show = show;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}
