//package com.yizhi.application.vote.controller;
//
//import com.yizhi.application.context.ContextHolder;
//import com.yizhi.application.context.RequestContext;
//import com.yizhi.application.domain.StatisticsVote;
//import com.yizhi.application.domain.TrVoteOption;
//import com.yizhi.application.domain.Vote;
//import com.yizhi.application.feign.ReportVoteClient;
//import com.yizhi.application.feign.VoteClient;
//import com.yizhi.application.feign.VoteOptionClient;
//import com.yizhi.application.feign.VoteResultClient;
//import com.yizhi.application.report.vote.DownloadVoteAnalyze;
//import com.yizhi.application.report.vote.DownloadVoteGroup;
//import com.yizhi.application.report.vote.DownloadVoteView;
//import com.yizhi.application.report.vote.DownloadVoteViewDetails;
//import com.yizhi.application.util.constant.ReturnCode;
//import com.yizhi.application.util.domain.Response;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import io.swagger.annotations.ApiParam;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.web.bind.annotation.GetMapping;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RequestParam;
//import org.springframework.web.bind.annotation.RestController;
//
//import java.text.SimpleDateFormat;
//import java.util.*;
//
//@Api(tags = "投票-投票下载")
//@RestController
//@RequestMapping("/manage/vote/export")
//public class ExportVoteController {
//    @Autowired
//    private ReportVoteClient reportVoteClient;
//
//    @Autowired
//    private VoteClient voteClient;
//
//    @Autowired
//    private DownloadVoteGroup downVoteGroup;
//
//    @Autowired
//    private DownloadVoteView downloadVoteView;
//
//    @Autowired
//    private DownloadVoteViewDetails downloadVoteViewDetails;
//
//    @Autowired
//    private VoteResultClient voteResultClient;
//
//    @Autowired
//    private VoteOptionClient voteOptionClient;
//
//    @Autowired
//    private DownloadVoteAnalyze downloadVoteAnalyze;
//
//    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-hh HH:mm:ss");
//
//    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMhhHHmmss");
//
//
//    private static final Logger LOGGER = LoggerFactory.getLogger(ExportVoteController.class);
//
//    @ApiOperation("导出投票列表")
//    @GetMapping("/group")
//    public Response<StatisticsVote> exportVoteGroup(
//            @ApiParam(value = "开始时间（yyyy-mm-dd）", required = false) @RequestParam(name = "startDate", required = false) String startDate,
//            @ApiParam(value = "结束时间（yyyy-mm-dd）", required = false) @RequestParam(name = "endDate", required = false) String endDate,
//            @ApiParam(value = "投票关键字", required = false) @RequestParam(name = "voteName", required = false) String voteName
//    ) {
//        try {
//            if(startDate == ""){
//                startDate = null;
//            }
//            if(endDate == ""){
//                endDate = null;
//            }
//            if(voteName !=null){
//                voteName = voteName.replace(" ","");
//            }
//            if(voteName == ""){
//                voteName = null;
//            }
//            RequestContext context = ContextHolder.get();
//            Map<String, Object> map = new HashMap<String, Object>();
//            String serialNo = "VOTE-GROUP-EXPORT-"+ new Date().getTime();
//            String taskName = "投票统计_" + dateFormat.format(new Date());
//            map.put("taskName",taskName);
//            map.put("serialNo", serialNo);
//            map.put("context", context);
//            map.put("voteName", voteName);
//            map.put("startDate", startDate);
//            map.put("endDate", endDate);
//            downVoteGroup.execute(map, true);
//            return Response.ok("任务名称:"+taskName+"任务序号:"+serialNo);
//        } catch (Exception e) {
//            e.printStackTrace();
//            LOGGER.error("", e);
//            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
//        }
//
//    }
//
//    @ApiOperation("导出投票参与名单")
//    @GetMapping("/group/view")
//    public Response<StatisticsVote> exportVoteView(
//            @ApiParam(value = "开始时间（yyyy-mm-dd）", required = false) @RequestParam(name = "startDate", required = false) String startDate,
//            @ApiParam(value = "结束时间（yyyy-mm-dd）", required = false) @RequestParam(name = "endDate", required = false) String endDate,
//            @ApiParam(value = "投票id", required = true) @RequestParam(name = "voteId", required = true) Long voteId,
//            @ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgNameOrCode", required = false) String orgNameOrCode,
//            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountName", required = false) String accountName,
//            @ApiParam(value = "是否投票", required = false) @RequestParam(name = "state", required = false) Integer state
//    ) {
//        try {
//            if(startDate == ""){
//                startDate = null;
//            }
//            if(endDate == ""){
//                endDate = null;
//            }
//            if(orgNameOrCode !=null){
//                orgNameOrCode = orgNameOrCode.replace(" ","");
//            }
//            if(orgNameOrCode == ""){
//                orgNameOrCode = null ;
//            }
//            if(accountName !=null){
//                accountName = accountName.replace(" ","");
//            }
//            if(accountName == ""){
//                accountName = null;
//            }
//            RequestContext context = ContextHolder.get();
//            Vote vote = voteClient.getVote(voteId);
//            if (vote == null) {
//                return Response.fail("该投票不存在");
//            }
//            Map<String, Object> map = new HashMap<String, Object>();
//            String serialNo = "VOTE-EXPORT-"+ new Date().getTime();
//            String taskName = vote.getVoteName() + "_" + dateFormat.format(new Date());
//            map.put("taskName",taskName);
//            map.put("serialNo", serialNo);
//            map.put("context", context);
//            map.put("vote", vote);
//            map.put("voteId",voteId);
//            map.put("orgNameOrCode", orgNameOrCode);
//            map.put("accountName", accountName);
//            map.put("state", state);
//            map.put("startDate", startDate);
//            map.put("endDate", endDate);
//            downloadVoteView.execute(map, true);
//            return Response.ok("任务名称:"+taskName+"任务序号:"+serialNo);
//        } catch (Exception e) {
//            LOGGER.error("", e);
//            e.printStackTrace();
//            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
//        }
//    }
//
//    @ApiOperation("导出投票明细统计")
//    @GetMapping("/group/view/details")
//    public Response<StatisticsVote> exportVoteViewDetails(
//            @ApiParam(value = "开始时间（yyyy-mm-dd）", required = false) @RequestParam(name = "startDate", required = false) String startDate,
//            @ApiParam(value = "结束时间（yyyy-mm-dd）", required = false) @RequestParam(name = "endDate", required = false) String endDate,
//            @ApiParam(value = "投票id", required = true) @RequestParam(name = "voteId", required = true) Long voteId,
//            @ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgNameOrCode", required = false) String orgNameOrCode,
//            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountName", required = false) String accountName,
//            @ApiParam(value = "是否投票", required = false) @RequestParam(name = "state", required = false) Integer state
//    ) {
//        try {
//            if(startDate == ""){
//                startDate = null;
//            }
//            if(endDate == ""){
//                endDate = null;
//            }
//            if(orgNameOrCode !=null){
//                orgNameOrCode = orgNameOrCode.replace(" ","");
//            }
//            if(orgNameOrCode == ""){
//                orgNameOrCode = null ;
//            }
//            if(accountName !=null){
//                accountName = accountName.replace(" ","");
//            }
//            if(accountName == ""){
//                accountName = null;
//            }
//            RequestContext context = ContextHolder.get();
//            String serialNo = "VOTE-DETAILS-EXPORT-"+ new Date().getTime();
//            Vote vote = voteClient.getVote(voteId);
//            Map<String, Object> map = new HashMap<String, Object>();
//            String taskName = vote.getVoteName() + "_" + dateFormat.format(new Date());
//            map.put("taskName",taskName);
//            map.put("serialNo", serialNo);
//            map.put("context", context);
//            map.put("serialNo", serialNo);
//            map.put("orgNameOrCode", orgNameOrCode);
//            map.put("accountName", accountName);
//            map.put("state", state);
//            map.put("vote", vote);
//            map.put("startDate", startDate);
//            map.put("endDate", endDate);
//            downloadVoteViewDetails.execute(map, true);
//            return Response.ok("任务名称:"+taskName+"任务序号:"+serialNo);
//        } catch (Exception e) {
//            LOGGER.error("", e);
//            e.printStackTrace();
//            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
//        }
//    }
//
//    @ApiOperation("导出选项票数统计")
//    @GetMapping("/group/view/analyze")
//    public Response<StatisticsVote> exportVoteViewAnalyze(
//            @ApiParam(value = "开始时间（yyyy-mm-dd）", required = false) @RequestParam(name = "startDate", required = false) String startDate,
//            @ApiParam(value = "结束时间（yyyy-mm-dd）", required = false) @RequestParam(name = "endDate", required = false) String endDate,
//            @ApiParam(value = "投票id", required = true) @RequestParam(name = "voteId", required = true) Long voteId,
//            @ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgNameOrCode", required = false) String orgNameOrCode,
//            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountName", required = false) String accountName,
//            @ApiParam(value = "是否签到", required = false) @RequestParam(name = "state", required = false) Integer state
//    ) {
//        try {
//            if(startDate == ""){
//                startDate = null;
//            }
//            if(endDate == ""){
//                endDate = null;
//            }
//            if(orgNameOrCode !=null){
//                orgNameOrCode = orgNameOrCode.replace(" ","");
//            }
//            if(orgNameOrCode == ""){
//                orgNameOrCode = null ;
//            }
//            if(accountName !=null){
//                accountName = accountName.replace(" ","");
//            }
//            if(accountName == ""){
//                accountName = null;
//            }
//
//            RequestContext context = ContextHolder.get();
//            Vote vote = voteClient.getVote(voteId);
//            if (vote == null) {
//                return Response.fail("该投票不存在");
//            }
//            List<TrVoteOption> trVoteOptions = voteOptionClient.getOptionList(voteId);
//            if (trVoteOptions == null) {
//                trVoteOptions = new ArrayList<TrVoteOption>();
//            }
//            Map<String, Object> map = new HashMap<String, Object>();
//            String serialNo = "VOTE-ANALYZE-EXPORT-"+ new Date();
//            String taskName = vote.getVoteName() + "选项票数统计_" + dateFormat.format(new Date());
//            map.put("taskName",taskName);
//            map.put("serialNo", serialNo);
//            map.put("trVoteOptions", trVoteOptions);
//            map.put("vote", vote);
//            map.put("startDate", startDate);
//            map.put("endDate", endDate);
//            map.put("context", context);
//            map.put("orgNameOrCode", orgNameOrCode);
//            map.put("accountName", accountName);
//            map.put("state", state);
//            downloadVoteAnalyze.execute(map, true);
//            return Response.ok("任务名称:"+taskName+"任务序号:"+serialNo);
//        } catch (Exception e) {
//            LOGGER.error("", e);
//            e.printStackTrace();
//            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
//        }
//
//    }
//}
