package com.yizhi.application.album;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.album.application.feign.AlbumClient;
import com.yizhi.album.application.vo.AlbumDetailVo;
import com.yizhi.album.application.vo.AlbumThemeVo;
import com.yizhi.album.application.vo.ApiListAlbumVo;
import com.yizhi.album.application.vo.ApiSearchAlbumVo;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;



import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(tags = "移动端-专辑", description = "专辑接口")
@RestController
@RequestMapping("/api/album")
public class AlbumStuController { 

	@Autowired
	private AlbumClient albumClient;
	
	@ApiOperation(value = "学员端专辑首页列表",response = ApiListAlbumVo.class)
	@PostMapping("/searchPage")
	public Response searchPage(@RequestBody ApiSearchAlbumVo apiSearchAlbumVo) {
		RequestContext context = ContextHolder.get();
		Long accountId = context.getAccountId();
		Long siteId = context.getSiteId();
		Long companyId = context.getCompanyId();
		List<Long> ids = context.getRelationIds();
		apiSearchAlbumVo.setAccountId(accountId);
		apiSearchAlbumVo.setCompanyId(companyId);
		apiSearchAlbumVo.setSiteId(siteId);
		apiSearchAlbumVo.setIds(ids);
		Page<ApiListAlbumVo> page = albumClient.searchPage(apiSearchAlbumVo);
		return Response.ok(page);
	}
	
	@ApiOperation(value = "学员端我的专辑列表",response = ApiListAlbumVo.class)
	@GetMapping("/getMyAlbumList")
	public Response getMyAlbumList(@ApiParam(name = "pageNo",value = "跳转页数 默认第一页")@RequestParam(name = "pageNo",defaultValue = "1") Integer pageNo,
			@ApiParam(name = "pageSize",value = "分页大小")@RequestParam(name = "pageSize",defaultValue = "10") Integer pageSize) {
		RequestContext context = ContextHolder.get();
		Long accountId = context.getAccountId();
		Long siteId = context.getSiteId();
		Page<ApiListAlbumVo> page = albumClient.getMyAlbumList(siteId, accountId, pageNo, pageSize);
		return Response.ok(page);
	}
	
	@ApiOperation(value = "学员端专辑详情",response = AlbumDetailVo.class)
	@GetMapping("/getDetail")
	public Response getDetail(@ApiParam(value = "专辑id")@RequestParam(name = "albumId") Long albumId) {
		RequestContext context = ContextHolder.get();
		Long accountId = context.getAccountId();
		Long siteId = context.getSiteId();
		Long companyId = context.getCompanyId();
		AlbumDetailVo vo = albumClient.getDeatil(albumId, accountId, siteId, companyId);
		if (vo!=null) {
			return Response.ok(vo);
		}else {
			return Response.fail(Constants.ALBUM_HAS_OFFLINE.getCode().toString(),Constants.ALBUM_HAS_OFFLINE.getName());
		}
	}
	
	@ApiOperation(value = "学员端专辑内容",response = AlbumThemeVo.class)
	@GetMapping("/getContent")
	public Response getContent(@ApiParam(value = "专辑id")@RequestParam(name = "albumId") Long albumId,@ApiParam(value = "排序类型 1正序 2倒序")@RequestParam(name = "type") Integer type,@ApiParam(value = "显示未解锁 0不显示 1显示 默认不显示")@RequestParam(name = "display",defaultValue = "0") Integer display) {
		RequestContext context = ContextHolder.get();
		Long accountId = context.getAccountId();
		Long siteId = context.getSiteId();
		Long companyId = context.getCompanyId();
		List<AlbumThemeVo> list = albumClient.getContent(albumId, accountId, siteId, companyId, type, display); 
		return Response.ok(list); 
	}
}
