package com.yizhi.application.course.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.ClassifyClient;
import com.yizhi.course.application.vo.ApiClassifyVo;
import com.yizhi.course.application.vo.domain.ClassifyEntityVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created with IntelliJ. IDEA
 * User:zhuwenwen
 * Date: 2018/3/20
 * Time: 13:28
 **/
@Api(tags="学员端-课程分类api",description="学员端-课程分类接口")
@RestController
@RequestMapping("/api/classify")
public class ClassifyStuController {
    @Autowired
    private ClassifyClient classifyClient;

    @ApiOperation(value = "学员端课程分类",response = ClassifyEntityVo.class)
    @RequestMapping(value = "/list",method = RequestMethod.GET)
    public Response<String> listStudentCourse(){

        RequestContext requestContext = ContextHolder.get();
        Page<ApiClassifyVo> page = classifyClient.pageList(null,1,999,requestContext.getCompanyId(),requestContext.getSiteId(),null);
        List<ApiClassifyVo> apiClassifyVos = new ArrayList<>();
        for (ApiClassifyVo apiClassifyVo : page.getRecords()) {
            apiClassifyVos.add(apiClassifyVo);
            if (null != apiClassifyVo.getChildren()&&apiClassifyVo.getChildren().size()>0) {
                for (ApiClassifyVo childApiClassifyVo : apiClassifyVo.getChildren()) {
                    apiClassifyVos.add(childApiClassifyVo);
                    if (null != childApiClassifyVo.getChildren() && childApiClassifyVo.getChildren().size() > 0) {
                        apiClassifyVos.addAll(childApiClassifyVo.getChildren());
                        childApiClassifyVo.setChildren(null);
                    }
                }
                apiClassifyVo.setChildren(null);
            }
        }
        return Response.ok(apiClassifyVos);
    }

    @ApiOperation(value = "根据课程分类id查询分类名称")
    @GetMapping("/find/id")
    public Response<String> getById(@ApiParam(value = "课程分类id") @RequestParam("id") Long id){
        ClassifyEntityVo classify = classifyClient.getById(id);
        return Response.ok(classify.getName());
    }

}

