package com.yizhi.application.marketing.controller;

import com.alibaba.fastjson.JSON;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.course.application.feign.MarketingClassifyClient;
import com.yizhi.course.application.feign.MarketingCourseClient;
import com.yizhi.course.application.vo.ClassifyVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 19:51 2018/4/9
 * @Modified By
 */
@Api(tags = "营销分类接口")
@RestController
@RequestMapping("/api/marketing/classify")
public class ClassifyController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ClassifyController.class);

    @Autowired
    private MarketingClassifyClient marketingClassifyClient;

    @Autowired
    private MarketingCourseClient marketingCourseClient;

    @ApiOperation(value = "查询全部营销分类")
    @RequestMapping(value = "/list",method = RequestMethod.GET)
    public Response<List<ClassifyVo>> listClassify(){
        LOGGER.info("查询全部营销分类请求的上下文="+JSON.toJSONString(ContextHolder.get()));
        return Response.ok(marketingClassifyClient.listClassify());
    }

    @ApiOperation(value = "查看营销分类", response = ClassifyVo.class)
    @RequestMapping(value = "/view",method = RequestMethod.GET)
    public Response<ClassifyVo> viewClassify(@ApiParam(name = "id", value = "营销分类Id", required = true)
                                                 @RequestParam Long id){
        LOGGER.info("更新分类请求的上下文="+JSON.toJSONString(ContextHolder.get()));
        LOGGER.info("id="+id);
        if(id == null || id == 0L ){
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(), "查看的分类的Id不能为空");
        }
        return Response.ok(marketingClassifyClient.viewClassify(id));
    }

}
