package com.yizhi.application.settlement;

import com.yizhi.application.settlement.config.SettlementHandlerContext;
import com.yizhi.application.settlement.handler.SettlementBaseHandler;
import com.yizhi.application.settlement.vo.SettlementBaseVo;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.util.application.domain.BizResponse;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 结算
 */
@RestController
@RequestMapping(path = "/api/settlement/")
public class SettlementController {

    private static Logger logger = LoggerFactory.getLogger(SettlementController.class);

    @Autowired
    private SettlementHandlerContext settlementHandlerContext;

    /**
     * 结算台详情
     *
     * @param type 查询的类型；例如：type=1 项目；
     * @param id   需要查询类型的id；例如：项目id
     */
    @GetMapping("/details/get")
    @ApiOperation(value = "结算台信息展示详情")
    public BizResponse<SettlementBaseVo> getSettlementInfo(@RequestParam("type") Integer type, @RequestParam("id") Long id) {
        RequestContext context = ContextHolder.get();
        logger.info("结算台获取详情入参type= {};id = {},accountId = {},companyId = {},siteId = {}", type, id, context.getAccountId(), context.getCompanyId(), context.getSiteId());
        if (null == type || null == id || type.compareTo(0) < 0 || id.compareTo(0L) < 0) {
            logger.error("结算台获取详情入参为空;");
            return BizResponse.fail(InternationalEnums.INTERNATIONALIZATIONWORDCONTROLLER1.getCode());
        }
        SettlementBaseHandler settlementHandler = settlementHandlerContext.getOrderStrategy(type);
        return settlementHandler.handler(id);
    }
}
