package com.yizhi.application.system.controller;

import com.yizhi.system.application.system.remote.SiteProtectClient;
import com.yizhi.util.application.domain.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path = "/api/site/protect")
public class SiteProtectController {

    @Autowired
    SiteProtectClient siteProtectClient;

    @GetMapping(path = "/list")
    public Response getUserProtectList(){
        String response = siteProtectClient.userProtectList();
        if(StringUtils.isBlank(response)){
            return Response.ok();
        }
        return Response.ok(response);
    }
}
