/**
 * FileName: HtmlTagUtil
 * Author:   wenjunlong
 * Date:     2018/6/26 16:36
 * Description: 处理html标签
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.application.util;

/**
 * 〈一句话功能简述〉<br> 
 * 〈处理html标签〉
 *
 * @author wenjunlong
 * @create 2018/6/26
 * @since 1.0.0
 */
public class HtmlTagUtil {

    /**
     * 删除所有的HTML标签
     *
     * @param source 需要进行除HTML的文本
     * @return
     */
    public static String deleteAllHTMLTag(String source) {

        if (source == null) {
            return "";
        }

        String s = source;
        /** 删除普通标签  */
        s = s.replaceAll("<(S*?)[^>]*>.*?|<.*? />", "");
        /** 删除转义字符 */
        s = s.replaceAll("&.{2,6}?;", "");
        return s;
    }
}
