package com.yizhi.application.calendar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.calendar.application.feign.CalendarStatisticClient;
import com.yizhi.calendar.application.vo.CalendarChartVO;
import com.yizhi.calendar.application.vo.CalendarStatisticVO;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api(tags = "管理端-签到打卡报表接口")
@RestController
@RequestMapping("/report/calendar")
public class CalendarReportController {

    private static final Logger LOG = LoggerFactory.getLogger(CalendarReportController.class);

    @Autowired
    private CalendarStatisticClient calendarStatisticClient;
    
    @ApiOperation(value = "签到打卡折线图",response = CalendarChartVO.class)
    @GetMapping(value = "/chart")
    public Response<List<CalendarChartVO>> signChart(@RequestParam(name = "startDate", required = true) String startDate,
			@RequestParam(name = "endDate", required = true) String endDate){
    	try {
            if(StringUtils.isBlank(startDate) || StringUtils.isBlank(endDate)){
                return Response.ok();
            }
			List<CalendarChartVO> list = calendarStatisticClient.signChart(startDate, endDate);
			return Response.ok(list);
		} catch (Exception e) {
			LOG.error(""+e);
			return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
		}
    }
    
    @ApiOperation(value = "统计数据",response = CalendarStatisticVO.class)
    @GetMapping(value = "/list")
    public Response<CalendarStatisticVO> list(@RequestParam(name = "startDate", required = true) String startDate,
            @RequestParam(name = "endDate", required = true) String endDate,
            @RequestParam(name = "kwd", required = false) String kwd,
            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo){
        if(StringUtils.isBlank(startDate) || StringUtils.isBlank(endDate)){
            return Response.ok();
        }
        try {
			Map<String,Integer> map = new HashMap<String, Integer>();
			Page<CalendarStatisticVO> page = calendarStatisticClient.list(startDate, endDate, kwd, pageSize, pageNo);
			map.put("pageSize", pageSize);
			map.put("pageNo", pageNo);
			map.put("pageTotal", page!=null&&page.getSize()>0?page.getTotal():null);
			List<CalendarStatisticVO> ret = page!=null&&page.getSize()>0?page.getRecords():new ArrayList<CalendarStatisticVO>();
			return Response.ok(ret, map);
        } catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return Response.fail();
		}
    }
    
    @ApiOperation(value = "导出下载统计数据")
    @GetMapping(value = "/list/export")
    public Response<String> listExport(@RequestParam(name = "startDate", required = true) String startDate,
            @RequestParam(name = "endDate", required = true) String endDate,
            @RequestParam(name = "kwd", required = false) String kwd){
    	Map<String, Object> map = calendarStatisticClient.listExport(startDate, endDate, kwd);
				return Response.ok(map.get("result").toString());
    	
    }
    
    @ApiOperation(value = "导出下载用户打卡记录数据")
    @GetMapping(value = "/account/export")
    public Response<String> accountExport(@RequestParam(name = "startDate", required = true) String startDate,
            @RequestParam(name = "endDate", required = true) String endDate,
            @RequestParam(name = "accountId", required = false) Long accountId){
    	Map<String, Object> map = calendarStatisticClient.accountExport(startDate, endDate, accountId);
				return Response.ok(map.get("result").toString());
    	
    }
    
    @ApiOperation(value = "导出下载签到明细数据")
    @GetMapping(value = "/detail/export")
    public Response<String> detailExport(@RequestParam(name = "startDate", required = true) String startDate,
            @RequestParam(name = "endDate", required = true) String endDate,
            @RequestParam(name = "kwd", required = false) String kwd){
    	Map<String, Object> map = calendarStatisticClient.detailExport(startDate, endDate, kwd);
				return Response.ok(map.get("result").toString());
    	
    }
}
