package com.yizhi.application.caseLibrary.controller;

import com.yizhi.application.caseLibrary.constant.Constant;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.library.application.feign.CaseLibraryClassifyClient;
import com.yizhi.library.application.vo.ClassifyListVO;
import com.yizhi.library.application.vo.ClassifyVO;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Ding
 * @className CaseLibraryManageController
 * @description TODO
 * @date 2019/7/3
 **/

@Api(tags = "案例库分类管理接口", description = "案例库分类管理接口")
@RestController
@RequestMapping("/manage/caseLibrary/classify")
public class CaseLibraryClassifyController {

    private static final Logger LOGGER = LoggerFactory.getLogger(CaseLibraryClassifyController.class);

    @Autowired
    CaseLibraryClassifyClient caseLibraryClassifyClient;

    @ApiOperation(value = "新建分类", notes = "新建分类")
    @ApiImplicitParams({@ApiImplicitParam(name = "name", value = "课程名称", paramType = "body", required = false),
            @ApiImplicitParam(name = "level", value = "0:维度, 1:一级分类 2:二级分类", paramType = "body", required = true),
            @ApiImplicitParam(name = "name", value = "名称", paramType = "body", required = false),
            @ApiImplicitParam(name = "parentId", value = "父级id 0为维度没有父级", paramType = "body", required = true),
            @ApiImplicitParam(name = "description", value = "分类描述", paramType = "body", required = false)})
    @PostMapping("/insert")
    public Response<Object> classifyInsert(@RequestBody ClassifyVO classify) {

        try {
            Integer result = caseLibraryClassifyClient.insertClassify(classify);
            if (result.equals(Constant.INSERT_CLASSIFY_SUCCESS)) {
                return Response.ok();
            } else if (result.equals(Constant.INSERT_CLASSIFY_INSUFFICIENT)) {
                return Response.fail(InternationalEnums.CASELIBRARYCLASSIFYCONTROLLER.getCode());
            } else if (result.equals(Constant.INSERT_CLASSIFY_IDENTICAL_NAME)) {
                return Response.fail(InternationalEnums.CERTIFICATECONTROLLER2.getCode());
            } else {
                LOGGER.error("############插入数据过程中出现错误");
                return Response.fail(Constants.MSG_BIZ_FAIL);
            }
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "删除分类", notes = "删除分类")
    @GetMapping("/delete")
    public Response<Object> deleteClassify(@ApiParam(value = "分类id", required = true) @RequestParam("classifyId") Long classifyId) {

        try {
            if (caseLibraryClassifyClient.deleteClassify(classifyId)) {
                return Response.ok();
            } else {
                LOGGER.error("############删除分类过程中出现错误");
                return Response.fail(Constants.MSG_BIZ_FAIL);
            }
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "分类下架", notes = "分类下架")
    @GetMapping("/putDown")
    public Response<Object> putDownClassify(@ApiParam(value = "分类id", required = true) @RequestParam("classifyId") Long classifyId) {

        try {
            return Response.ok(caseLibraryClassifyClient.putDownClassify(classifyId));

        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "分类上架", notes = "分类上架")
    @GetMapping("/release")
    public Response<Object> releaseClassify(@ApiParam(value = "分类id", required = true) @RequestParam("classifyId") Long classifyId) {

        try {
            return Response.ok(caseLibraryClassifyClient.releaseClassify(classifyId));

        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "获取分类列表", notes = "获取分类列表", response = ClassifyListVO.class)
    @GetMapping("/list")
    public Response<ClassifyListVO> getClassifyList() {

        try {
            List<ClassifyListVO> list = caseLibraryClassifyClient.getClassifyList();
//            list = JSON.parseArray(JSON.toJSONString(list), ClassifyListVO.class);
//            String s = JSON.toJSONString(list);
            return Response.ok(list);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "修改分类信息", notes = "修改分类信息")
    @GetMapping("/update")
    public Response<Object> updateClassify(@ApiParam(value = "分类id", required = true) @RequestParam("classifyId") Long classifyId,
                                           @ApiParam(value = "分类名称") @RequestParam(name = "name", required = false) String name,
                                           @ApiParam(value = "分类描述") @RequestParam(name = "description", required = false) String description) {

        try {
            if (caseLibraryClassifyClient.updateClassify(classifyId, name, description)) {
                return Response.ok();
            } else {
                LOGGER.error("############修改分类信息过程中出现错误");
                return Response.fail(InternationalEnums.CERTIFICATECONTROLLER2.getCode());
            }
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "上移下移", notes = "上移下移")
    @GetMapping("/move")
    public Response<Object> moveClassify(@ApiParam(value = "分类id", required = true) @RequestParam("classifyId") Long classifyId,
                                         @ApiParam(value = "上级分类id") @RequestParam(name = "parentId", required = false) Long parentId,
                                         @ApiParam(value = "分类排序") @RequestParam(name = "sort", required = false) Integer sort,
                                         @ApiParam(value = "上移/下移类型,1上移,2下移") @RequestParam(name = "type", required = true) Integer type
    ) {

        try {
            Integer result = caseLibraryClassifyClient.moveClassify(classifyId, parentId, sort, type);
            if (result == 1) {
                //操作成功
                return Response.ok();
            } else if (result == 3) {
                return Response.fail("4002", InternationalEnums.MYITEMCONFIGMANAGECOMTROLLER2.getCode());
            } else if (result == 4) {
                return Response.fail("4003", InternationalEnums.MANAGEASSIGNMENTCONTROLLER3.getCode());
            } else {
                LOGGER.error("############上移下移过程中出现错误");
                return Response.fail(Constants.MSG_BIZ_FAIL);
            }
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }
}
