package com.yizhi.application.caseLibrary.controller;

import java.util.HashMap;
import java.util.Map;

import com.yizhi.library.application.feign.StudentCaseReportClient;
import com.yizhi.library.application.vo.StatisticStudentCaseVO;
import com.yizhi.library.application.vo.StudentCaseAccountExportVO;
import com.yizhi.library.application.vo.StudentCaseOrgExportVO;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.plugins.Page;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(tags = "管理端学员案例报表接口", description = "管理端学员案例报表接口")
@RestController
@RequestMapping("/statistic/studentCase")
public class StatisticStudentCaseController {

	private static final Logger LOGGER = LoggerFactory.getLogger(StatisticStudentCaseController.class);

	@Autowired
	private StudentCaseReportClient studentCaseReportClient;

	@ApiOperation(value = "学员案例报表按部门统计", notes = "学员案例报表", response = StudentCaseOrgExportVO.class)
	@GetMapping("/list/org")
	public Response<StudentCaseOrgExportVO> studentCaseListOrg(
			@ApiParam(value = "案例名称模糊查询", required = false) @RequestParam(name = "kwd", required = false) String kwd,
			@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
			@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
		try {
			Page<StudentCaseOrgExportVO> page = new Page<>(pageNo, pageSize);
			//page = studentCaseReportClient.studentCaseByOrg(kwd, pageSize, pageNo);
			page = studentCaseReportClient.studentCaseByOrg(kwd, pageSize, pageNo);
			Map<String, Integer> pageMap = new HashMap<>(3);
			pageMap.put("pageNo", pageNo);
			pageMap.put("pageSize", pageSize);
			if (null != page) {
				pageMap.put("total", page.getTotal());
			}

			return Response.ok(page, pageMap);
		} catch (Exception e) {
			LOGGER.error("############案例库服务调用出现异常", e);
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}

	@ApiOperation(value = "学员案例报表按用户统计", notes = "学员案例报表", response = StudentCaseAccountExportVO.class)
	@GetMapping("/list/account")
	public Response<StudentCaseAccountExportVO> studentCaseListAccount(
			@ApiParam(value = "案例名称模糊查询", required = false) @RequestParam(name = "kwd", required = false) String kwd,
			@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
			@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
		try {
			Page<StudentCaseAccountExportVO> page = new Page<>(pageNo, pageSize);
			page = studentCaseReportClient.studentCaseByAccount(kwd, pageSize, pageNo);
			Map<String, Integer> pageMap = new HashMap<>(3);
			pageMap.put("pageNo", pageNo);
			pageMap.put("pageSize", pageSize);
			if (null != page) {
				pageMap.put("total", page.getTotal());
			}

			return Response.ok(page, pageMap);
		} catch (Exception e) {
			LOGGER.error("############案例库服务调用出现异常", e);
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}

	@ApiOperation(value = "学员案例报表按案例统计", notes = "学员案例报表", response = StatisticStudentCaseVO.class)
	@GetMapping("/list")
	public Response<StatisticStudentCaseVO> studentCaseList(
			@ApiParam(value = "案例名称模糊查询", required = false) @RequestParam(name = "kwd", required = false) String kwd,
			@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
			@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
			@ApiParam(value = "开始时间（yyyy-mm-dd）", required = false) @RequestParam(name = "startDate", required = false) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = false) @RequestParam(name = "endDate", required = false) String endDate) {
		try {
			Page<StatisticStudentCaseVO> page = new Page<>(pageNo, pageSize);
			page = studentCaseReportClient.studentCaseList(startDate, endDate, kwd, pageSize, pageNo);
			Map<String, Integer> pageMap = new HashMap<>(3);
			pageMap.put("pageNo", pageNo);
			pageMap.put("pageSize", pageSize);
			if (null != page) {
				pageMap.put("total", page.getTotal());
			}

			return Response.ok(page, pageMap);
		} catch (Exception e) {
			LOGGER.error("############案例库服务调用出现异常", e);
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}

	@ApiOperation(value = "学员案例报表按部门统计下载报表", notes = "学员案例报表按部门统计下载报表")
	@GetMapping("/list/org/export")
	public Response<Object> studentCaseListOrgExport(
			@ApiParam(value = "部门名称模糊查询", required = false) @RequestParam(name = "kwd", required = false) String kwd) {
		try {
			Map<String, Object> map = studentCaseReportClient.studentCaseExportByOrg(kwd);
			return Response.ok(map.get("result").toString());
		} catch (Exception e) {
			LOGGER.error("############案例库服务调用出现异常", e);
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}

	@ApiOperation(value = "学员案例报表按用户统计下载报表", notes = "学员案例报表按用户统计下载报表")
	@GetMapping("/list/account/export")
	public Response<Object> studentCaseListAccountExport(
			@ApiParam(value = "用户名称模糊查询", required = false) @RequestParam(name = "kwd", required = false) String kwd) {
		try {
			Map<String, Object> map = studentCaseReportClient.studentCaseExportByAccount(kwd);
			return Response.ok(map.get("result").toString());
		} catch (Exception e) {
			LOGGER.error("############案例库服务调用出现异常", e);
			return Response.fail(Constants.MSG_BIZ_FAIL);
		}
	}

	@ApiOperation(value = "学员案例报表按部门统计下载报表", notes = "学员案例报表按部门统计下载报表")
    @GetMapping("/list/export")
	public Response<Object> studentCaseListExport( @ApiParam(value = "案例名称模糊查询", required = false) @RequestParam(name = "kwd", required = false) String kwd,
			@ApiParam(value = "开始时间（yyyy-mm-dd）", required = false) @RequestParam(name = "startDate", required = false) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = false) @RequestParam(name = "endDate", required = false) String endDate){
    	try {
			Map<String, Object> map = studentCaseReportClient.studentCaseExport(startDate, endDate, kwd);
			return Response.ok(map.get("result").toString());
		} catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
		}
    }
}
