package com.yizhi.application.course.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.course.vo.CourseVO;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.course.application.feign.LessonClient;
import com.yizhi.course.application.vo.MaterialManageDetailsVo;
import com.yizhi.course.application.vo.MaterialManageVo;
import com.yizhi.course.application.vo.MaterialStateUpdateVo;
import com.yizhi.course.application.vo.NoPassReason;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(tags="做课接口",description="LessonManageController")
@RestController
@RequestMapping("/manage")
public class LessonManageController {
	
		private static final Logger logger=LoggerFactory.getLogger(LessonManageController.class);
	
		@Autowired
	    private LessonClient lessonClient;
		
		@Autowired
		private AccountClient accountClient;
		
		
		
		
	    
	    @ApiOperation(value="后台做课列表",notes="后台做课列表")	
	    @GetMapping("/lesson/list")
	    public Response<MaterialManageVo> getLessonList(@ApiParam(name="name",value="模糊查询做课名称",required=false) @RequestParam(name = "name", required = false) String name,
														@ApiParam(name="commitName",value="提交人",required=false) @RequestParam(name = "commitName", required = false) String commitName,
														@ApiParam(name="auditorName",value="审批人",required=false) @RequestParam(name = "auditorName", required = false) String auditorName,
														@ApiParam(name="state",value="状态 0已撤回 1未提交 2审核中 3已通过 4未通过 5删除",required=false) @RequestParam(name = "state", required = false) Integer state,
														@ApiParam(name = "pageNo", value = "要跳转的页数",required=false) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
														@ApiParam(name = "pageSize", value = "每页条数，默认：20", required = false) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize) {
	    	try {
	    		Long orgId= ContextHolder.get().getOrgId();
	    		Long companyId=ContextHolder.get().getCompanyId();
	    		//提交人id
	    		List<Long> listCommintIdList=new ArrayList<Long>();
	    		if(commitName!=null) {
	    			List<AccountVO> list=accountClient.fuzzySearchAccountByName(commitName,companyId);
		    		if(!CollectionUtils.isEmpty(list)) {
		    			for (int i = 0; i <list.size(); i++) {
		    				listCommintIdList.add(list.get(i).getId());
						}
		    		}
	    		}
	    		
	    		
	    		//评阅人
	    		List<Long> listAuditorIdList=new ArrayList<Long>();
	    		if(auditorName!=null) {
	    			List<AccountVO> list2=accountClient.fuzzySearchAccountByName(auditorName, companyId);
		    		if(!CollectionUtils.isEmpty(list2)) {
		    			for (int i = 0; i <list2.size(); i++) {
		    				listAuditorIdList.add(list2.get(i).getId());
						}
		    		}
	    		}
	    		
	    		//返回会的数据
				Page<MaterialManageVo> pageList=lessonClient.getLessonList(name, listCommintIdList, listAuditorIdList, state, pageNo, pageSize,orgId);
				Page<MaterialManageVo> pageList2=new Page<MaterialManageVo>();
				if(pageList!=null) {
					List<MaterialManageVo> list=pageList.getRecords();
					for (int i = 0; i < list.size(); i++) {
						Long accountId=list.get(i).getAccountId();
						list.get(i).setAccountName(accountClient.findById(accountId).getName());
						Long auditorId=list.get(i).getAuditorId();
						list.get(i).setAuditorName(accountClient.findById(auditorId).getName());
					}
					pageList2.setRecords(list);
				}
				if(pageList2!=null) {
					List<MaterialManageVo> listRecords=pageList2.getRecords();
					Map<String,Integer> map=new HashMap<String,Integer>();
					map.put("pageSize", pageSize);
					map.put("pageNo", pageNo);
					map.put("total", pageList.getTotal());
					Pair<List<MaterialManageVo>,Map<String,Integer>> pair=new MutablePair(listRecords, map);
					return Response.ok(pair);
				}
				else {
					return Response.fail(ReturnCode.RESOURCE_NOT_FOUND.getCode(),ReturnCode.RESOURCE_NOT_FOUND.getMsg());
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
			}
	    }
	    
	    
		
		
	    
	    @ApiOperation(value="根据素材id查看单个做课详情",notes="后台单个做课详情")
	    @GetMapping("/lesson/details")
	    public Response<MaterialManageDetailsVo> getLesson(@ApiParam(name="id",value="id主键",required=true)@RequestParam(name="id",required=true)Long id){
	    	try {
				MaterialManageDetailsVo materialManageDetailsVo=lessonClient.getLesson(id);
				if(materialManageDetailsVo!=null){
						return Response.ok(materialManageDetailsVo);
					}
				else {
					return Response.ok(ReturnCode.RESOURCE_NOT_FOUND);
				  }
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
			}
	    	}
	    
	    
	    
	    @ApiOperation(value="根据素材id审核/更改状态",notes="审核/更改状态")
	    @PostMapping("/update/state")
	    public Response<String> updateState(@RequestBody MaterialStateUpdateVo materialStateUpdateVo){
			try {
				materialStateUpdateVo.setContext(ContextHolder.get());
				Boolean x=lessonClient.updateStateManage(materialStateUpdateVo);
				if(x) {
					return Response.ok(ReturnCode.SUCCESS);}
				else {
					return Response.fail(ReturnCode.UPDATE_FAIL.getCode(),ReturnCode.UPDATE_FAIL.getMsg());}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
			}  
	    }
	    
	    
	    
	    @ApiOperation(value="根据素材id审核/更改状态并且得到下一个id",notes="根据素材id审核/更改状态并且得到下一个id")
	    @PostMapping("/update/state/getNextId")
	    public Response<String> updateStateGetNextId(@RequestBody MaterialStateUpdateVo materialStateUpdateVo){
			try {
				Long x=lessonClient.updateStateGetNextId(materialStateUpdateVo);
				if(x!=null) {
					return Response.ok(x);}
				else {
					return Response.ok(ReturnCode.RESOURCE_NOT_FOUND);}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
			}  
	    }
	    
	    
	    

	    
	    @ApiOperation(value="通过做课id查看不通过的原因",notes="查看不通过的原因")
	    @GetMapping("/nopass/reason")
	    public Response<String> updateState(@ApiParam(name="lessonId",value="做课id",required=true) @RequestParam(name = "lessonId", required = true) Long lessonId,
	    		 @ApiParam(name = "pageNo", value = "要跳转的页数",required=false) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                 @ApiParam(name = "pageSize", value = "每页条数，默认：20", required = false) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize){
	    	try {
				List<NoPassReason> list=lessonClient.noPassReason(lessonId, pageNo, pageSize);
				List<CourseVO> listCourseVO=new ArrayList<>();
				if(!CollectionUtils.isEmpty(list)) {
				for (int i = 0; i < list.size(); i++) {
					NoPassReason noPassReason=list.get(i);
					CourseVO courseVO=new CourseVO();
					BeanUtils.copyProperties(noPassReason, courseVO);
					courseVO.setAuditorName(accountClient.findById(courseVO.getAuditorId()).getFullName());
				    listCourseVO.add(courseVO);
				}}

				if(listCourseVO!=null){
					return Response.ok(listCourseVO);
				}
				else {
					return Response.ok(ReturnCode.RESOURCE_NOT_FOUND);
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
			}
	    }
}
