package com.yizhi.application.course.util;

public class BatchUploadUtils {

    private String active;

    private String localFile;

    private String objectName;

    /**
     * 配置信息
     * @param active
     * @param localFile
     * @param objectName
     */
    public BatchUploadUtils(String active,String localFile,String objectName){
        this.active = active;
        this.localFile = localFile;
        this.objectName = objectName;
    }

    public String getActive() {
        return active;
    }

    public String getLocalFile() {
        return localFile;
    }

    public String getObjectName() {
        return objectName;
    }

    /**
     * 上传文件
     * @param isSimpleUpload 是否简单上传
     * @return
     */
    public String upload(boolean isSimpleUpload){
        String ret ="";
        try {
            if(isSimpleUpload){
                ret = UploadOSSUtils.simpleUpload(this.localFile,this.objectName,active);
            }else{
                try {
                    ret = UploadOSSUtils.resumingUpload(this.localFile,this.objectName,active);
                } catch (Throwable throwable) {
                    System.out.println(this.localFile+"上传OSS异常  。objectName= "+this.objectName);
                    throwable.printStackTrace();
                }
            }

        } catch (Exception e) {
            System.out.println(this.localFile+"上传OSS异常   。objectName="+this.objectName);
            System.out.println(e);
            ret = "";
        }
        return ret;
    }
}
