/**
 * FileName: VideoAsynchronizationDeal
 * Author:   wenjunlong
 * Date:     2018/5/30 14:40
 * Description: 视频异步处理
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.application.course.util;

import com.alibaba.fastjson.JSONObject;

import com.yizhi.aliyun.application.feign.AliyunClient;
import com.yizhi.aliyun.application.vo.UploadParamVo;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.course.application.feign.MaterialClient;
import com.yizhi.course.application.vo.AudioVideoVO;
import com.yizhi.course.application.vo.domain.MaterialEntityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 〈一句话功能简述〉<br>
 * 〈视频异步处理〉
 *
 * @author wenjunlong
 * @create 2018/5/30
 * @since 1.0.0
 */
@Component
public class VideoAsynchronizationDeal extends AbstractDefaultTask<String, Map<String, Object>> {

    @Autowired
    private MaterialClient materialClient;

    @Autowired
    private AliyunClient aliyunClient;



    @Override
    protected String execute(Map<String, Object> stringObjectMap) {

        TaskContext taskContext = null;
        MaterialEntityVo materialVo = null;
        try {
            materialVo = (MaterialEntityVo) stringObjectMap.get("material");
            // 任务id   任务名字   操作人id  操作时间
            taskContext = new TaskContext(System.currentTimeMillis(), materialVo.getName(), materialVo.getCreateById(), new Date(), materialVo.getSiteId(), materialVo.getCompanyId());
            working(taskContext);

            if (materialVo.getType() == 2 ) {
                // 进行url文件上传
                UploadParamVo uploadParamVo = new UploadParamVo();
                uploadParamVo.setTitle(materialVo.getName());
                uploadParamVo.setFileName(materialVo.getOriginalFile());
                uploadParamVo.setUrl(materialVo.getOriginalFileUrl());
                String result = aliyunClient.upload(uploadParamVo);
                JSONObject jsStr = JSONObject.parseObject(result);
                System.out.println("文件上传结果" + jsStr);
                if ("Success".equals(jsStr.get("code").toString())) {
                    AudioVideoVO video = (AudioVideoVO) stringObjectMap.get("video");
                    Integer duration = 300;
                    video.setFdUrl(materialVo.getOriginalFileUrl());
                    video.setLdUrl(materialVo.getOriginalFileUrl());
                    video.setSdUrl(materialVo.getOriginalFileUrl());
                    video.setVideoId(jsStr.get("videoId").toString());
                    int hour = duration / 3600;
                    int minute = (duration - hour * 3600) / 60;
                    int second = (duration - hour * 3600 - minute * 60);
                    materialVo.setTextHour(hour);
                    materialVo.setTextMinute(minute);
                    materialVo.setTextSecond(second);
                    stringObjectMap.put("video", video);
                    System.out.println(video.toString());
                    if (stringObjectMap.containsKey("action")) {
                        if ("create".equals(stringObjectMap.get("action").toString())) {
                            materialClient.insert(stringObjectMap);
                        } else {
                            materialClient.update(stringObjectMap);
                        }
                    }
                    success(taskContext, materialVo.getName() + "解析成功！", null);
                } else {
                    fail(taskContext, materialVo.getName() + "解析失败！");
                }
            } else if (materialVo.getType() == 1 ){
                if ("create".equals(stringObjectMap.get("action").toString())) {
                    materialClient.insert(stringObjectMap);
                } else {
                    materialClient.update(stringObjectMap);
                }
                success(taskContext, materialVo.getName() + "解析成功！", null);
            }
            } catch(Exception e){
                e.printStackTrace();
                fail(taskContext, materialVo.getName() + "解析失败！");
            }
        return null;
    }
}
