package com.yizhi.application.customProject.contoller;

import com.baomidou.mybatisplus.plugins.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yizhi.application.accountUtil.AuthorizeQueryAccount;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.assignment.application.feign.AssignmentClient;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.CourseClient;
import com.yizhi.course.application.vo.RangeImportParamVo;
import com.yizhi.custom.api.feign.*;
import com.yizhi.custom.api.param.BizListParam;
import com.yizhi.custom.api.param.ExperiencePoolParam;
import com.yizhi.custom.api.vo.custom.ExperiencePoolVoAutorizeAndProjectVO;
import com.yizhi.custom.api.vo.custom.PoolSaveReturnVO;
import com.yizhi.custom.api.vo.domain.*;
import com.yizhi.exam.application.feign.ExamClient;
import com.yizhi.research.application.feign.ResearchClient;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.*;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;

/**
 * 经验池管理端
 *
 * @author dingxiaowei
 * @date 2018/11/5
 */
@Api(tags = "经验池管理接口", description = "经验池管理接口")
@RestController
@RequestMapping("/manage/experiencePool")
public class ExperiencePoolManageController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExperiencePoolManageController.class);

    @Autowired
    private ExperiencePoolClient experiencePoolClient;

    @Autowired
    private ExperiencePoolLevelClient experiencePoolLevelClient;

    @Autowired
    private ProjectActivityExperienceClient activityExperienceClient;

    @Autowired
    private ProjectActivityExperienceSetClient activityExperienceSetClient;

    @Autowired
    private ExperiencePoolProjectClient poolProjectClient;

    @Autowired
    private ExperienceSetExport experienceSetExport;

    @Autowired
    private ExternalExperienceImport experienceImport;

    @Autowired
    private CourseClient courseClient;

    @Autowired
    private ExamClient examClient;

    @Autowired
    private ResearchClient researchClient;

//    @Autowired
//    private VoteClient voteClient;

    @Autowired
    private ExperiencePoolAuthorizeClient poolAuthorizeClient;

    @Autowired
    private ExternalExperienceModelExport modelExport;

    @Autowired
    private StudentExperienceClient studentExperienceClient;

    @Autowired
    private PushStudentExperience pushStudentExperience;
    @Autowired
    private AuthorizeQueryAccount queryAccount;

    @Autowired
    private AssignmentClient assignmentClient;

    @ApiOperation(value = "显示经验池管理列表", notes = "显示经验池管理列表", response = ExperiencePoolVo.class)
    @GetMapping("/view")
    public Response<ExperiencePoolVo> getExperiencePoolList(@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false) Integer pageNo,

                                                          @ApiParam(value = "每页条数", required = false) @RequestParam(name = "pageSize", required = false) Integer pageSize) {
        Page<ExperiencePoolVo> page = null;
        try {
            RequestContext res = ContextHolder.get();
            Long companyId = res.getCompanyId();
            Long siteId = res.getSiteId();
            List<Long> orgIds = null;
            ExperiencePoolParam experiencePoolParam = new ExperiencePoolParam();
            experiencePoolParam.setCompanyId(companyId);
            experiencePoolParam.setSiteId(siteId);
            experiencePoolParam.setPageNo(pageNo);
            experiencePoolParam.setPageSize(pageSize);
            if (!res.isAdmin() && CollectionUtils.isNotEmpty(res.getOrgIds())) {
                orgIds = res.getOrgIds();
                experiencePoolParam.setOrgIds(orgIds);
            }
            page = experiencePoolClient.getExperiencePoolList(experiencePoolParam);
            return Response.ok(page);
        } catch (Exception e) {
            LOGGER.error("显示经验池列表失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "删除经验池", notes = "删除法经验池")
    @GetMapping("/delete")
    public Response<String> deleteExperiencePool(@ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId) {
        boolean isOk = false;
        try {
            isOk = experiencePoolClient.deleteExperiencePool(poolId);
            if (isOk) {
                return Response.ok();
            } else {
                return Response.fail(ReturnCode.DELETE_FAIL.getCode(),ReturnCode.DELETE_FAIL.getMsg());
            }
        } catch (Exception e) {
            LOGGER.error("删除经验池失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "经验池修改显示", notes = "经验池修改显示", response = ExperiencePoolVoAutorizeAndProjectVO.class)
    @GetMapping("/view/detail")
    public Response<ExperiencePoolVoAutorizeAndProjectVO> viewExperiencePool(@ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId) {
        ExperiencePoolVoAutorizeAndProjectVO autorizeAndProjectVO = null;
        try {
            autorizeAndProjectVO = experiencePoolClient.getExperiencePoolView(poolId);
            return Response.ok(autorizeAndProjectVO);
        } catch (Exception e) {
            LOGGER.error("经验池修改显示失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "课程分页查询", notes = "返回分页结果集")
    @ApiImplicitParams({@ApiImplicitParam(name = "name", value = "课程名称", paramType = "body", required = false),
            @ApiImplicitParam(name = "pageNo", value = "跳转页数", paramType = "body", required = false),
            @ApiImplicitParam(name = "pageSize", value = "每页条数", paramType = "body", required = false),
            @ApiImplicitParam(name = "ids", value = "已选课程id列表", paramType = "body", required = false)})
    @PostMapping("/course/list")
    public Response<Map<String, Object>> getCourseList(@RequestBody BizListParam param) {
        Page<Map<String, Object>> page = null;
        String name = param.getName();
        List<Long> ids = param.getIds();
        Integer pageNo = param.getPageNo();
        Integer pageSize = param.getPageSize();
        try {
            page = courseClient.experiencePoolList(name, ids, pageNo, pageSize);
            return Response.ok(page);
        } catch (Exception e) {
            LOGGER.error("显示课程信息列表失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "显示考试信息列表", notes = "显示考试信息列表")
    @ApiImplicitParams({@ApiImplicitParam(name = "name", value = "考试名称", paramType = "body", required = false),
            @ApiImplicitParam(name = "pageNo", value = "跳转页数", paramType = "body", required = false),
            @ApiImplicitParam(name = "pageSize", value = "每页条数", paramType = "body", required = false),
            @ApiImplicitParam(name = "ids", value = "已选考试id列表", paramType = "body", required = false)})
    @PostMapping("/exam/list")
    public Response<Map<String, Object>> getExamList(@RequestBody BizListParam param) {
        Page<Map<String, Object>> page = null;
        String name = param.getName();
        List<Long> ids = param.getIds();
        Integer pageNo = param.getPageNo();
        Integer pageSize = param.getPageSize();
        try {
            page = examClient.getPoolExamList(name, ids, pageNo, pageSize);
            return Response.ok(page);
        } catch (Exception e) {
            LOGGER.error("显示考试信息列表失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "显示调研信息列表", notes = "显示调研信息列表")
    @ApiImplicitParams({@ApiImplicitParam(name = "name", value = "调研名称", paramType = "body", required = false),
            @ApiImplicitParam(name = "pageNo", value = "跳转页数", paramType = "body", required = false),
            @ApiImplicitParam(name = "pageSize", value = "每页条数", paramType = "body", required = false),
            @ApiImplicitParam(name = "ids", value = "已选调研id列表", paramType = "body", required = false)})
    @PostMapping("/research/list")
    public Response<Map<String, Object>> getResearchList(@RequestBody BizListParam param) {
        Page<Map<String, Object>> page = null;
        String name = param.getName();
        List<Long> ids = param.getIds();
        Integer pageNo = param.getPageNo();
        Integer pageSize = param.getPageSize();
        try {
            page = researchClient.getPoolExamList(name, ids, pageNo, pageSize);

            return Response.ok(page);

        } catch (Exception e) {
            LOGGER.error("显示调研信息列表失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

//    @ApiOperation(value = "显示投票信息列表", notes = "显示投票信息列表")
//    @ApiImplicitParams({@ApiImplicitParam(name = "name", value = "投票名称", paramType = "body", required = false),
//            @ApiImplicitParam(name = "pageNo", value = "跳转页数", paramType = "body", required = false),
//            @ApiImplicitParam(name = "pageSize", value = "每页条数", paramType = "body", required = false),
//            @ApiImplicitParam(name = "ids", value = "已选投票id列表", paramType = "body", required = false)})
//    @PostMapping("/vote/list")
//    public Response<Map<String, Object>> getVoteList(@RequestBody BizListParam param) {
//        Page<Map<String, Object>> page = null;
//        String name = param.getName();
//        List<Long> ids = param.getIds();
//        Integer pageNo = param.getPageNo();
//        Integer pageSize = param.getPageSize();
//        try {
//            page = voteClient.getPoolVoteList(name, ids, pageNo, pageSize);
//
//            return Response.ok(page);
//
//        } catch (Exception e) {
//            LOGGER.error("显示投票信息列表失败", e);
//            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
//        }
//    }

    @ApiOperation(value = "经验池保存(新增,修改下一步)", notes = "经验池保存(新增,修改下一步)", response = PoolSaveReturnVO.class)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "经验池ID", paramType = "body", required = false),
            @ApiImplicitParam(name = "experiencePoolNo", value = "经验池编码", paramType = "body", required = false),
            @ApiImplicitParam(name = "experiencePoolName", value = "经验池名称", paramType = "body", required = false),
            @ApiImplicitParam(name = "visibleRange", value = "经验池可见范围", paramType = "body", required = false),
            @ApiImplicitParam(name = "experiencePoolAuthorizes", value = "经验池可见范围列表", paramType = "body", required = false),
            @ApiImplicitParam(name = "poolProjects", value = "经验池关联项目列表", paramType = "body", required = false),
            @ApiImplicitParam(name = "projectActivityExperiences", value = "经验池关联项目活动经验列表", paramType = "body", required = false)
    })
    @PostMapping("/save")
    public Response<PoolSaveReturnVO> saveExperiencePool(@RequestBody ExperiencePoolVoAutorizeAndProjectVO poolAutorizeAndProjectVO) {
        PoolSaveReturnVO poolSaveReturnVO = null;
        try {
            Map<String, Object> map = new HashMap<>();

            map = experiencePoolClient.insertExperiencePoolAuthorizeAndProject(poolAutorizeAndProjectVO);

            boolean isOk = (boolean) map.get("isOk");
            if (isOk) {
                ObjectMapper objectMapper = new ObjectMapper();
                poolSaveReturnVO = objectMapper.convertValue(map.get("poolSaveReturnVO"), PoolSaveReturnVO.class);
                return Response.ok(poolSaveReturnVO);
            } else {
                return Response.fail(InternationalEnums.EXPERIENCEPOOLMANAGECONTROLLER1.getCode());
            }

        } catch (Exception e) {
            LOGGER.error("经验池保存失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "保存关联项目活动经验(批量设置经验)", notes = "保存关联项目活动经验(批量设置经验)", response = ProjectActivityExperienceVo.class)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "poolId", value = "经验池ID", paramType = "body", required = false),
            @ApiImplicitParam(name = "activityExperienceList", value = "项目活动经验列表", paramType = "body", required = false),
    })
    @PostMapping("/save/saveActivityExperience")
    public Response<String> insertActivityExperiences(@RequestBody PoolSaveReturnVO poolSaveReturnVO) {
        boolean isOk = false;
        List<ProjectActivityExperienceVo> activityExperiences = null;
        if (null != poolSaveReturnVO) {
            activityExperiences = poolSaveReturnVO.getActivityExperienceList();
        }
        try {
            if (CollectionUtils.isNotEmpty(activityExperiences)) {
                isOk = activityExperienceClient.insertProjectActivityExperienceList(activityExperiences);
            }
            if (isOk) {
                return Response.ok();
            } else {
                return  Response.fail(ReturnCode.SAVE_FAIL.getCode(),ReturnCode.SAVE_FAIL.getMsg());
            }
        } catch (Exception e) {
            LOGGER.error("保存关联项目活动经验失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "获取关联项目活动经验设置规则列表", notes = "获取关联项目活动经验设置规则列表")
    @GetMapping("/save/getSets")
    public Response<Map<String, Object>> getProjectActivityExperienceSets(
            @ApiParam(value = "关联项目活动经验ID", required = true) @RequestParam(name = "activityExperienceId", required = true) Long activityExperienceId,
            @ApiParam(value = "经验设置类型", required = false) @RequestParam(name = "setType", required = false) Integer setType
    ) {
        Map<String, Object> map = null;
        try {
            map = activityExperienceSetClient.getProjectActivityExperienceSets(activityExperienceId, setType);

            return Response.ok(map);

        } catch (Exception e) {
            LOGGER.error("获取关联项目活动经验设置规则列表失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "获取单个关联项目活动经验设置规则", notes = "获取单个关联项目活动经验设置规则", response = ProjectActivityExperienceSetVo.class)
    @GetMapping("/save/viewSet")
    public Response<ProjectActivityExperienceSetVo> viewProjectActivityExperienceSet(
            @ApiParam(value = "活动经验设置ID", required = true) @RequestParam(name = "activityExperienceSetId", required = true) Long activityExperienceSetId
    ) {
        ProjectActivityExperienceSetVo activityExperienceSet = null;
        try {
            activityExperienceSet = activityExperienceSetClient.viewProjectActivityExperienceSet(activityExperienceSetId);

            return Response.ok(activityExperienceSet);

        } catch (Exception e) {
            LOGGER.error("获取关联项目活动经验设置规则列表失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "活动经验设置按考试分数范围保存(修改)", notes = "活动经验设置按考试分数范围保存(修改)", response = ProjectActivityExperienceSetVo.class)
    @GetMapping("/save/insertSet")
    public Response<ProjectActivityExperienceSetVo> insertProjectActivityExperienceSet(
            @ApiParam(value = "活动经验设置ID", required = false) @RequestParam(name = "activityExperienceSetId", required = false) Long activityExperienceSetId,
            @ApiParam(value = "关联项目活动经验ID", required = true) @RequestParam(name = "activityExperienceId", required = true) Long activityExperienceId,
            @ApiParam(value = "活动经验设置类型", required = false) @RequestParam(name = "setType", required = true) Integer setType,
            @ApiParam(value = "经验值最小分", required = false) @RequestParam(name = "minScore", required = true) Integer minScore,
            @ApiParam(value = "经验值", required = false) @RequestParam(name = "experience", required = true) Long experience) {
        List<ProjectActivityExperienceSetVo> list = null;
        Map<String, Object> map = new HashMap<>();
        try {
            map = activityExperienceSetClient.insertProjectActivityExperienceSet(activityExperienceSetId, activityExperienceId, setType, minScore, experience);

            boolean isOk = (boolean) map.get("isOk");
            if (isOk) {
                ObjectMapper objectMapper = new ObjectMapper();
                list = objectMapper.convertValue(map.get("list"), List.class);
                return Response.ok(list);
            } else {
                return Response.fail(InternationalEnums.EXPERIENCEPOOLMANAGECONTROLLER2.getCode());
            }

        } catch (Exception e) {
            LOGGER.error("获取关联项目活动经验设置规则列表失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "活动经验设置按考试分数保存(修改)/确定", notes = "活动经验设置按考试分数保存(修改)")
    @GetMapping("/save/insertSet/score")
    public Response<Map<String, Object>> insertProjectActivityExperienceSetWithScore(
            @ApiParam(value = "活动经验设置ID", required = false) @RequestParam(name = "activityExperienceSetId", required = false) Long activityExperienceSetId,
            @ApiParam(value = "关联项目活动经验ID", required = true) @RequestParam(name = "activityExperienceId", required = true) Long activityExperienceId,
            @ApiParam(value = "活动经验设置类型", required = false) @RequestParam(name = "setType", required = true) Integer setType,
            @ApiParam(value = "按分数倍数", required = false) @RequestParam(name = "times", required = false) Integer times) {
        try {

            return Response.ok(activityExperienceSetClient.insertProjectActivityExperienceSetWithScore(activityExperienceSetId, activityExperienceId, setType, times));

        } catch (Exception e) {
            LOGGER.error("获取关联项目活动经验设置规则列表失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "考试范围经验设置规则单个删除", notes = "考试范围经验设置规则单个删除", response = ProjectActivityExperienceSetVo.class)
    @GetMapping("/save/deleteSet")
    public Response<String> deleteProjectActivityExperienceSet(
            @ApiParam(value = "活动经验设置ID", required = true) @RequestParam(name = "activityExperienceSetId", required = true) Long activityExperienceSetId

    ) {
        boolean isOk = false;
        try {
            isOk = activityExperienceSetClient.deleteProjectActivityExperienceSet(activityExperienceSetId);
            if (isOk) {
                return Response.ok();
            } else {
                return Response.fail(ReturnCode.DELETE_FAIL.getCode(),ReturnCode.DELETE_FAIL.getMsg());
            }
        } catch (Exception e) {
            LOGGER.error("考试范围经验设置规则单个删除", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "考试经验设置规则全部删除", notes = "考试经验设置规则全部删除", response = ProjectActivityExperienceSetVo.class)
    @GetMapping("/save/deleteSets")
    public Response<ProjectActivityExperienceVo> deleteProjectActivityExperienceSets(
            @ApiParam(value = "活动经验设置ID", required = true) @RequestParam(name = "activityExperienceId", required = true) Long activityExperienceId

    ) {
        try {
            return Response.ok(activityExperienceSetClient.deleteProjectActivityExperienceSets(activityExperienceId));
        } catch (Exception e) {
            LOGGER.error("考试范围经验设置规则全部删除", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "经验池新增完成", notes = "经验池新增完成")
    @GetMapping("/save/saveActivityExperience/complete")
    public Response<String> complete(@ApiParam(value = "经验池ID", required = true) @RequestParam(name = "experiencePoolId", required = true) Long experiencePoolId) {
        boolean isOk = false;
        try {
            isOk = experiencePoolClient.completeExperiencePool(experiencePoolId);
            if (isOk) {
                return Response.ok();
            } else {
                return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
            }
        } catch (Exception e) {
            LOGGER.error("经验池新增完成失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }

    }


    @ApiOperation(value = "设置经验池等级(显示经验池列表)", notes = "设置经验池等级(显示经验池列表)", response = ExperiencePoolLevelVo.class)
    @GetMapping("/level/list")
    public Response<ExperiencePoolLevelVo> getExperiencePoolLevelList(@ApiParam(value = "经验池ID", required = true) @RequestParam(name = "experiencePoolId", required = true) Long experiencePoolId) {
        List<ExperiencePoolLevelVo> levelList = null;
        try {
            levelList = experiencePoolLevelClient.getExperiencePoolLevelList(experiencePoolId);

            return Response.ok(levelList);

        } catch (Exception e) {
            LOGGER.error("显示经验池等级列表失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "新增(修改)经验池等级,显示单个等级", notes = "新增(修改)经验池等级,显示单个等级", response = ExperiencePoolLevelVo.class)
    @GetMapping("/level/view")
    public Response<ExperiencePoolLevelVo> viewExperiencePoolLevel(@ApiParam(value = "经验池等级ID", required = true) @RequestParam(name = "levelId", required = true) Long levelId) {
        ExperiencePoolLevelVo experiencePoolLevel = null;
        try {
            experiencePoolLevel = experiencePoolLevelClient.getExperiencePoolLevelView(levelId);

            return Response.ok(experiencePoolLevel);

        } catch (Exception e) {
            LOGGER.error("新增(修改)经验池等级,显示单个等级失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "删除经验池等级", notes = "删除经验池等级")
    @GetMapping("/level/delete")
    public Response<String> deleteExperiencePoolLevel(@ApiParam(value = "经验池等级ID", required = true) @RequestParam(name = "levelId", required = true) Long levelId) {
        boolean isOk = false;
        try {
            isOk = experiencePoolLevelClient.deleteExperiencePoolLevel(levelId);
            if (isOk) {
                return Response.ok();
            } else {
                return Response.fail(ReturnCode.DELETE_FAIL.getCode(),ReturnCode.DELETE_FAIL.getMsg());
            }
        } catch (Exception e) {
            LOGGER.error("删除经验池等级", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "新增(修改)经验池等级", notes = "新增(修改)经验池等级", response = ExperiencePoolLevelVo.class)
    @GetMapping("/level/insert")
    public Response<ExperiencePoolLevelVo> insertExperiencePoolLevel(@ApiParam(value = "经验池等级ID", required = false) @RequestParam(name = "levelId", required = false) Long levelId,
                                                                   @ApiParam(value = "经验池ID", required = false) @RequestParam(name = "poolId", required = false) Long poolId,
                                                                   @ApiParam(value = "经验池等级编码", required = false) @RequestParam(name = "levelNo", required = false) String levelNo,
                                                                   @ApiParam(value = "经验池等级名称", required = false) @RequestParam(name = "levelName", required = false) String levelName,
                                                                   @ApiParam(value = "经验池等级最小经验", required = false) @RequestParam(name = "minLevelExperience", required = false) Long minLevelExperience) {
        ExperiencePoolLevelVo experiencePoolLevel = new ExperiencePoolLevelVo();
        Map<String, Object> map = new HashMap<>();
        try {
            if (null != levelId) {
                experiencePoolLevel.setId(levelId);
            }
            if (null != poolId) {
                experiencePoolLevel.setExperiencePoolId(poolId);
            }
            experiencePoolLevel.setLevelNo(levelNo);
            experiencePoolLevel.setLevelName(levelName);
            if (null != minLevelExperience) {
                experiencePoolLevel.setMinLevelExperience(minLevelExperience);
            }
            map = experiencePoolLevelClient.insertExperiencePoolLevel(experiencePoolLevel);
            boolean isOk = (boolean) map.get("isOk");
            if (isOk) {
                ObjectMapper objectMapper = new ObjectMapper();
                experiencePoolLevel = objectMapper.convertValue(map.get("experiencePoolLevel"), ExperiencePoolLevelVo.class);
                return Response.ok(experiencePoolLevel);
            } else {
                return Response.fail(InternationalEnums.EXPERIENCEPOOLMANAGECONTROLLER3.getCode());
            }
        } catch (Exception e) {
            LOGGER.error("经验池等级设置失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "导入外部经验", notes = "导入外部经验")
    @PostMapping("/activityExperiences/import")
    public Response<String> importPoolActivityExperiences(@RequestBody RangeImportParamVo importParam) {
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "EXPERIENCE-IMPORT-" + taskId.toString();
        String taskName = "外部经验导入-" + taskId.toString();
        String url = importParam.getOssUrl();
        Long poolId = importParam.getBizdId();
        map.put("taskId", taskId);
        map.put("taskName", taskName);
        map.put("serialNo", serialNo);
        map.put("res", res);
        map.put("url", url);
        map.put("poolId", poolId);
        experienceImport.execute(map, true);
        return Response.ok("导入成功," + " " + "编号:" + serialNo);
    }

    @ApiOperation(value = "导出外部经验模板下载", notes = "导出外部经验模板下载")
    @GetMapping("/activityExperiences/import/model")
    public Response<String> importPoolActivityExperiencesModel(@ApiParam(value = "经验池名称", required = true) @RequestParam(name = "poolName", required = true) String poolName) {
        try {
            return Response.ok(modelExport.importPoolActivityExperiencesModel(poolName));
        } catch (Exception e) {
            LOGGER.error("导入外部经验模板下载出错", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }


    @ApiOperation(value = "下载经验规则", notes = "下载经验规则", response = ProjectActivityExperienceVo.class)
    @GetMapping("/activityExperiences/export")
    public Response<String> exportPoolExperienceAndRules(@ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId,
                                                         @ApiParam(value = "经验池名称", required = true) @RequestParam(name = "poolName", required = true) String poolName) {
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "EXPERIENCE-SET-EXPORT-" + taskId.toString();
        String taskName = "经验规则下载-" + taskId.toString();
        map.put("taskId", taskId);
        map.put("serialNo", serialNo);
        map.put("taskName", taskName);
        map.put("poolId", poolId);
        map.put("poolName", poolName);
        map.put("res", res);
        experienceSetExport.execute(map, true);
        return Response.ok("导出成功," + " " + "编号:" + serialNo);
    }

    @ApiOperation(value = "学员范围列表", notes = "学员范围列表")
    @GetMapping("/authorize")
    public Response<Map<String, Object>> listAuthorizes(@ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId) {
        try {
            List<Map<String, Object>> ranges = poolAuthorizeClient.getListMap(poolId);


            if (!CollectionUtils.isEmpty(ranges)) {
                List<Long> accountIds = new ArrayList<>(ranges.size());
                for (Map a:ranges){
                    LOGGER.info(a.toString());
                    Object relationId = a.get("relation_id");
                    LOGGER.info("relation_id:"+relationId);
                    if (null!= relationId){
                        Long accountId = Long.valueOf(relationId.toString());
                        accountIds.add(accountId);
                    }
                }
                Map<Long, AccountVO> accountMap = queryAccount.queryAccountByIds(accountIds);

                ranges.forEach(a -> {
                    Object relationId = a.get("relation_id");
                    if (null != relationId) {
                        Long accountId = Long.valueOf(relationId.toString());
                        if (null != accountMap) {
                            LOGGER.info("accountMap:"+accountMap.toString());
                            AccountVO accountVO = accountMap.get(accountId);
                            if (null != accountVO) {
                                a.put("workNum", accountVO.getWorkNum());
                                a.put("fullName", accountVO.getFullName());
                                a.put("name", accountVO.getName());
                            }
                        }
                    }
                });
            }
            return Response.ok(ranges);
        } catch (Exception e) {
            LOGGER.error("显示学员范围列表出错", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "查看关联活动ID", notes = "查看关联活动ID", response = ExperiencePoolProjectVo.class)
    @GetMapping("/project/view")
    public Response<ExperiencePoolProjectVo> getExperiencePoolProjectList(@ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId) {
        List<ExperiencePoolProjectVo> poolProjects = null;
        try {
            poolProjects = poolProjectClient.getExperiencePoolProjectList(poolId);

            return Response.ok(poolProjects);

        } catch (Exception e) {
            LOGGER.error("查看关联活动ID失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "经验池补发经验", notes = "经验池补发经验")
    @GetMapping("/pushStudentExperience")
    public Response<String> pushStudentExperience(@ApiParam(value = "经验池id", required = true) @RequestParam(name = "experiencePoolId", required = true) Long experiencePoolId) {
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        Long taskId = System.currentTimeMillis();
        String serialNo = "PUSH-STUDENT-EXPERIENCE" + taskId.toString();
        String taskName = "经验池学员经验补发-" + taskId.toString();
        map.put("experiencePoolId", experiencePoolId);
        map.put("res", res);
        map.put("serialNo", serialNo);
        map.put("taskId", taskId);
        map.put("taskName", taskName);
        pushStudentExperience.execute(map, true);
        return Response.ok("任务名称:" + taskName + "," + "任务序号:" + serialNo);
    }

    @ApiOperation(value = "作业分页查询", notes = "返回分页结果集")
    @ApiImplicitParams({@ApiImplicitParam(name = "name", value = "课程名称", paramType = "body", required = false),
            @ApiImplicitParam(name = "pageNo", value = "跳转页数", paramType = "body", required = false),
            @ApiImplicitParam(name = "pageSize", value = "每页条数", paramType = "body", required = false),
            @ApiImplicitParam(name = "ids", value = "已选课程id列表", paramType = "body", required = false)})
    @PostMapping("/assignment/list")
    public Response<Map<String, Object>> getAssignmentList(@RequestBody BizListParam param) {
        Page<Map<String, Object>> page = null;
        String name = param.getName();
        List<Long> ids = param.getIds();
        Integer pageNo = param.getPageNo();
        Integer pageSize = param.getPageSize();
        try {
            page = assignmentClient.experiencePoolList(name, ids, pageNo, pageSize);
            return Response.ok(page);
        } catch (Exception e) {
            LOGGER.error("显示作业信息列表失败", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }
}
