package com.yizhi.application.customProject.contoller;


import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.custom.api.feign.ExperiencePoolAuthorizeClient;
import com.yizhi.custom.api.vo.custom.VisibleRangeExportVo;
import com.yizhi.live.application.vo.VisibleRangeExport;
import com.yizhi.system.application.model.AccountRangeExportParam;
import com.yizhi.system.application.system.remote.AccountRangeClient;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author Ding
 * @className ExperiencePoolRangeExport
 * @description 经验池学员范围异步导出
 * @date 2018/11/7
 **/

@Component
public class ExperiencePoolRangeExport extends AbstractDefaultTask<String, Map<String, Object>> {

    @Autowired
    private ExperiencePoolAuthorizeClient poolAuthorizeClient;

    @Autowired
    private AccountRangeClient accountRangeClient;

    @Override
    protected String execute(Map<String, Object> map) {

        Long poolId = (Long) map.get("poolId");
        RequestContext res = (RequestContext) map.get("context");
        VisibleRangeExportVo visibleRangeExport = poolAuthorizeClient.listAuthorizes(poolId);
        AccountRangeExportParam exportParam = new AccountRangeExportParam();
        if (null != visibleRangeExport) {
            if (CollectionUtils.isNotEmpty(visibleRangeExport.getAccountIds())) {
                exportParam.setAccountIds(visibleRangeExport.getAccountIds());
            }
            if (CollectionUtils.isNotEmpty(visibleRangeExport.getOrgIds())) {
                exportParam.setOrgIds(visibleRangeExport.getOrgIds());
            }
            exportParam.setBizName(visibleRangeExport.getBizName());
            if (null != res) {
                exportParam.setContext(res);
            }
            if (null != visibleRangeExport.getMap()) {
                exportParam.setMap(visibleRangeExport.getMap());
            }
        }
        String result = accountRangeClient.doExperiencePoolExport(exportParam);
        return result;
    }
}
