package com.yizhi.application.document;


import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.documents.application.feign.DocumentClassifyClient;
import com.yizhi.documents.application.vo.documents.DocumentClassifyTreeVo;
import com.yizhi.documents.application.vo.documents.DocumentClassifyVo;
import com.yizhi.documents.application.vo.documents.ModelVo;
import com.yizhi.documents.application.vo.documents.ParamsVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author hutao
 * @since 2019-06-11
 */
@Api(tags = "资料库分类管理端接口")
@RestController
@RequestMapping("/manage/DocumentClassify")
public class DocumentClassifyComtroller {


    @Autowired
    DocumentClassifyClient classifyClient;


    //parentId、rootId都为0，一级分类
    //parentId不为0，rootId为0，二级分类
    //parentId、rootId 都不为0，三级分类
    @PostMapping("/save")
    @ApiOperation(value = "资料分类保存", notes = "资料分类保存", response = String.class)
    public Response<String> save(@ApiParam(value = "classify{name:必传，description:'',parentId:0,rootId:0} ") @RequestBody DocumentClassifyVo classify) {


        if (classify.getName() == null || StringUtils.isEmpty(classify.getName().trim())) {
            return Response.fail(InternationalEnums.DOCUMENTCLASSIFYCOMTROLLER1.getCode());
        }

        ParamsVo p = classifyClient.save(classify);
        if (!p.getSuccess()) {
            return Response.fail(p.getErrorMsg());
        }
        return Response.ok("分类创建成功！");
    }

    @PostMapping("/update")
    @ApiOperation(value = "资料分类修改", notes = "资料分类修改", response = Boolean.class)
    public Response<Boolean> update(@ApiParam("classify{id:必传，name:必传，description:'',parentId:}") @RequestBody DocumentClassifyVo classifyVo) {

        if (null != classifyVo) {
            if (classifyVo.getId() == null) {
                return Response.fail(InternationalEnums.DOCUMENTCLASSIFYCOMTROLLER2.getCode());
            }
            if (classifyVo.getName() == null || StringUtils.isEmpty(classifyVo.getName().trim())) {
                return Response.fail(InternationalEnums.DOCUMENTCLASSIFYCOMTROLLER1.getCode());
            }
            if (!classifyClient.update(classifyVo)) {
                return Response.fail(InternationalEnums.DOCUMENTCLASSIFYCOMTROLLER3.getCode());
            }
        }
        return Response.ok("修改成功！");
    }

    @PostMapping("/delete")
    @ApiOperation(value = "资料分类删除", notes = "资料分类删除", response = ParamsVo.class)
    public Response<ParamsVo> delete(@ApiParam("modelVo{id:必传}")@RequestBody ModelVo modelVo) {
        if (modelVo.getId() == null) {
            return Response.fail(InternationalEnums.DOCUMENTCOMTROLLER3.getCode());
        }

        ParamsVo result = classifyClient.delete(modelVo.getId());
        if (result.getSuccess()) {
            return Response.ok("删除成功！");
        } else {
            return Response.fail(result.getErrorMsg());
        }
    }

    /**
     * 查询 树形结构的分类
     *
     * @param showThirdClassfy 是否显示 第三级分类
     * @return
     */
    @GetMapping("/query")
    @ApiOperation(value = "查询资料分类树形结构", notes = "查询资料分类树形结构", response = DocumentClassifyTreeVo.class)
    public Response<List<DocumentClassifyTreeVo>> queryClassfy(@RequestParam(value = "showThirdClassfy") Boolean showThirdClassfy) {

        List<DocumentClassifyTreeVo> classifyTreeVos = classifyClient.queryClassfy(showThirdClassfy);

        return Response.ok(classifyTreeVos);
    }



    @GetMapping("/queryById")
    @ApiOperation(value = "查询分类通过id", notes = "查询分类通过id", response = DocumentClassifyVo.class)
    public Response<DocumentClassifyVo> queryById(@RequestParam(value = "id") Long id) {
        if (id == null) {
            return Response.fail(InternationalEnums.DOCUMENTCLASSIFYCOMTROLLER2.getCode());
        }
        DocumentClassifyVo documentClassifyVo = classifyClient.queryById(id);
        return Response.ok(documentClassifyVo);
    }

}

